/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api;

import java.util.concurrent.TimeUnit;
import org.apache.directory.ldap.client.api.exception.LdapException;
import org.apache.directory.ldap.client.api.future.SearchFuture;
import org.apache.directory.ldap.client.api.message.SearchResponse;
import org.apache.directory.ldap.client.api.message.SearchResultDone;
import org.apache.directory.shared.ldap.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

public class SearchCursor
extends AbstractCursor {
    private SearchFuture future;
    private long timeout;
    private TimeUnit timeUnit;
    private SearchResponse response;
    private boolean done;

    public SearchCursor(SearchFuture future, long timeout, TimeUnit timeUnit) {
        this.future = future;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public boolean next() throws Exception {
        try {
            if (this.future.isCancelled()) {
                this.response = null;
                this.done = true;
                return false;
            }
            this.response = this.future.get(this.timeout, this.timeUnit);
        }
        catch (Exception e) {
            LdapException ldapException = new LdapException("The response queue has been emptied, no response was found.");
            ldapException.initCause(e);
            if (!this.future.isCancelled()) {
                this.future.cancel(true);
            }
            this.close(ldapException);
            throw ldapException;
        }
        if (this.response == null) {
            this.future.cancel(true);
            throw new LdapException("TimeOut occured");
        }
        this.done = this.response instanceof SearchResultDone;
        if (this.done) {
            this.response = null;
        }
        return !this.done;
    }

    public SearchResponse get() throws Exception {
        if (!this.available()) {
            throw new InvalidCursorPositionException();
        }
        return this.response;
    }

    public boolean isElementReused() {
        return true;
    }

    public boolean available() {
        return this.response != null;
    }

    public void close() throws Exception {
        this.close(null);
    }

    public void close(Exception cause) throws Exception {
        if (this.done) {
            super.close();
            return;
        }
        if (!this.future.isCancelled()) {
            this.future.cancel(true);
        }
        if (cause != null) {
            super.close(cause);
        } else {
            super.close();
        }
    }

    public void after(Object element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void afterLast() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void before(Object element) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean first() throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean last() throws Exception {
        throw new UnsupportedOperationException();
    }

    public boolean previous() throws Exception {
        throw new UnsupportedOperationException();
    }
}

