/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spi;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.WSDLConstants;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.wsdl.WSDLManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProviderImpl
extends Provider {
    public static final String JAXWS_PROVIDER = ProviderImpl.class.getName();
    protected static final Logger LOG = LogUtils.getL7dLogger(ProviderImpl.class);
    private static JAXBContext jaxbContext;
    private static final boolean JAXWS_22;

    public static boolean isJaxWs22() {
        return JAXWS_22;
    }

    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        Bus bus = BusFactory.getThreadDefaultBus();
        return new ServiceImpl(bus, url, qname, cls, new WebServiceFeature[0]);
    }

    public ServiceDelegate createServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class serviceClass, WebServiceFeature ... features) {
        Bus bus = BusFactory.getThreadDefaultBus();
        for (WebServiceFeature f : features) {
            if (f.getClass().getName().startsWith("javax.xml.ws")) continue;
            throw new WebServiceException("Unknown feature error: " + f.getClass().getName());
        }
        return new ServiceImpl(bus, wsdlDocumentLocation, serviceName, serviceClass, features);
    }

    protected EndpointImpl createEndpointImpl(Bus bus, String bindingId, Object implementor, WebServiceFeature ... features) {
        return new EndpointImpl(bus, implementor, bindingId, features);
    }

    public Endpoint createEndpoint(String bindingId, Object implementor) {
        EndpointImpl ep = null;
        if (EndpointUtils.isValidImplementor(implementor)) {
            Bus bus = BusFactory.getThreadDefaultBus();
            ep = this.createEndpointImpl(bus, bindingId, implementor, new WebServiceFeature[0]);
            return ep;
        }
        throw new WebServiceException(new org.apache.cxf.common.i18n.Message("INVALID_IMPLEMENTOR_EXC", LOG, new Object[0]).toString());
    }

    public Endpoint createEndpoint(String bindingId, Object implementor, WebServiceFeature ... features) {
        EndpointImpl ep = null;
        if (EndpointUtils.isValidImplementor(implementor)) {
            Bus bus = BusFactory.getThreadDefaultBus();
            ep = this.createEndpointImpl(bus, bindingId, implementor, features);
            return ep;
        }
        throw new WebServiceException(new org.apache.cxf.common.i18n.Message("INVALID_IMPLEMENTOR_EXC", LOG, new Object[0]).toString());
    }

    public Endpoint createAndPublishEndpoint(String url, Object implementor) {
        Endpoint ep = this.createEndpoint(null, implementor);
        ep.publish(url);
        return ep;
    }

    public Endpoint createAndPublishEndpoint(String address, Object implementor, WebServiceFeature ... features) {
        Endpoint ep = this.createEndpoint(null, implementor, features);
        ep.publish(address);
        return ep;
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters) {
        return this.createW3CEndpointReference(address, null, serviceName, portName, metadata, wsdlDocumentLocation, referenceParameters, null, null);
    }

    public static EndpointReferenceType convertToInternal(EndpointReference external) {
        if (external instanceof W3CEndpointReference) {
            try {
                Document doc = XMLUtils.newDocument();
                DOMResult result = new DOMResult(doc);
                external.writeTo((Result)result);
                W3CDOMStreamReader reader = new W3CDOMStreamReader(doc.getDocumentElement());
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                EndpointReferenceType internal = (EndpointReferenceType)context.createUnmarshaller().unmarshal((XMLStreamReader)reader, EndpointReferenceType.class).getValue();
                return internal;
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    public W3CEndpointReference createW3CEndpointReference(String address, QName interfaceName, QName serviceName, QName portName, List<Element> metadata, String wsdlDocumentLocation, List<Element> referenceParameters, List<Element> elements, Map<QName, String> attributes) {
        if (serviceName != null && portName != null && wsdlDocumentLocation != null && interfaceName == null) {
            Bus bus = BusFactory.getThreadDefaultBus();
            WSDLManager wsdlManager = (WSDLManager)bus.getExtension(WSDLManager.class);
            try {
                Definition def = wsdlManager.getDefinition(wsdlDocumentLocation);
                interfaceName = def.getService(serviceName).getPort(portName.getLocalPart()).getBinding().getPortType().getQName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (serviceName == null && portName == null && address == null) {
            throw new IllegalStateException("Address in an EPR cannot be null,  when serviceName or portName is null");
        }
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            writer.setPrefix("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "EndpointReference", "http://www.w3.org/2005/08/addressing");
            writer.writeNamespace("wsa", "http://www.w3.org/2005/08/addressing");
            writer.writeStartElement("wsa", "Address", "http://www.w3.org/2005/08/addressing");
            address = address == null ? "" : address;
            writer.writeCharacters(address);
            writer.writeEndElement();
            if (referenceParameters != null) {
                writer.writeStartElement("wsa", "ReferenceParameters", "http://www.w3.org/2005/08/addressing");
                for (Element ele : referenceParameters) {
                    StaxUtils.writeElement((Element)ele, (XMLStreamWriter)writer, (boolean)true);
                }
                writer.writeEndElement();
            }
            if (wsdlDocumentLocation != null || interfaceName != null || serviceName != null || metadata != null && metadata.size() > 0) {
                writer.writeStartElement("wsa", "Metadata", "http://www.w3.org/2005/08/addressing");
                writer.writeNamespace("wsaw", "http://www.w3.org/2006/05/addressing/wsdl");
                writer.writeNamespace("wsam", "http://www.w3.org/2007/05/addressing/metadata");
                if (wsdlDocumentLocation != null) {
                    boolean includeLocationOnly = false;
                    Message message = PhaseInterceptorChain.getCurrentMessage();
                    if (message != null) {
                        includeLocationOnly = MessageUtils.isTrue((Object)message.getContextualProperty("org.apache.cxf.wsa.metadata.wsdlLocationOnly"));
                    }
                    String attrubuteValue = serviceName != null && !includeLocationOnly ? serviceName.getNamespaceURI() + " " + wsdlDocumentLocation : wsdlDocumentLocation;
                    writer.writeNamespace("wsdli", "http://www.w3.org/ns/wsdl-instance");
                    writer.writeAttribute("wsdli", "http://www.w3.org/ns/wsdl-instance", "wsdlLocation", attrubuteValue);
                }
                if (interfaceName != null) {
                    writer.writeStartElement("wsam", "InterfaceName", "http://www.w3.org/2007/05/addressing/metadata");
                    String portTypePrefix = interfaceName.getPrefix();
                    if (portTypePrefix == null || portTypePrefix.equals("")) {
                        portTypePrefix = "ns1";
                    }
                    writer.writeNamespace(portTypePrefix, interfaceName.getNamespaceURI());
                    writer.writeCharacters(portTypePrefix + ":" + interfaceName.getLocalPart());
                    writer.writeEndElement();
                }
                String serviceNamePrefix = null;
                if (serviceName != null) {
                    serviceNamePrefix = serviceName.getPrefix() == null || serviceName.getPrefix().length() == 0 ? "ns2" : serviceName.getPrefix();
                    writer.writeStartElement("wsam", "ServiceName", "http://www.w3.org/2007/05/addressing/metadata");
                    if (portName != null) {
                        writer.writeAttribute("EndpointName", portName.getLocalPart());
                    }
                    writer.writeNamespace(serviceNamePrefix, serviceName.getNamespaceURI());
                    writer.writeCharacters(serviceNamePrefix + ":" + serviceName.getLocalPart());
                    writer.writeEndElement();
                }
                if (wsdlDocumentLocation != null) {
                    writer.writeStartElement("wsdl", WSDLConstants.QNAME_DEFINITIONS.getLocalPart(), "http://schemas.xmlsoap.org/wsdl/");
                    writer.writeNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
                    writer.writeStartElement("wsdl", WSDLConstants.QNAME_IMPORT.getLocalPart(), WSDLConstants.QNAME_IMPORT.getNamespaceURI());
                    if (serviceName != null) {
                        writer.writeAttribute("namespace", serviceName.getNamespaceURI());
                    }
                    writer.writeAttribute("location", wsdlDocumentLocation);
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                if (metadata != null) {
                    for (Element e : metadata) {
                        StaxUtils.writeElement((Element)e, (XMLStreamWriter)writer, (boolean)true);
                    }
                }
                writer.writeEndElement();
            }
            if (elements != null) {
                for (Element e : elements) {
                    StaxUtils.writeElement((Element)e, (XMLStreamWriter)writer, (boolean)true);
                }
            }
            writer.writeEndElement();
            writer.flush();
            Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
            return (W3CEndpointReference)unmarshaller.unmarshal((Node)writer.getDocument());
        }
        catch (Exception e) {
            throw new WebServiceException(new org.apache.cxf.common.i18n.Message("ERROR_UNMARSHAL_ENDPOINTREFERENCE", LOG, new Object[0]).toString(), (Throwable)e);
        }
    }

    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        ServiceDelegate sd = this.createServiceDelegate(null, null, serviceEndpointInterface);
        return (T)sd.getPort(endpointReference, serviceEndpointInterface, features);
    }

    public EndpointReference readEndpointReference(Source eprInfoset) {
        try {
            Unmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
            return (EndpointReference)unmarshaller.unmarshal(StaxUtils.createXMLStreamReader((Source)eprInfoset));
        }
        catch (JAXBException e) {
            throw new WebServiceException(new org.apache.cxf.common.i18n.Message("ERROR_UNMARSHAL_ENDPOINTREFERENCE", LOG, new Object[0]).toString(), (Throwable)e);
        }
    }

    private JAXBContext getJAXBContext() {
        if (jaxbContext == null) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{W3CEndpointReference.class});
            }
            catch (JAXBException e) {
                throw new WebServiceException(new org.apache.cxf.common.i18n.Message("JAXBCONTEXT_CREATION_FAILED", LOG, new Object[0]).toString(), (Throwable)e);
            }
        }
        return jaxbContext;
    }

    static {
        boolean b = false;
        try {
            Class cls = ClassLoaderUtils.loadClass((String)"javax.xml.ws.spi.http.HttpContext", ProviderImpl.class);
            Method m = Endpoint.class.getMethod("publish", cls);
            b = m != null;
        }
        catch (Throwable ex) {
            b = false;
        }
        JAXWS_22 = b;
    }
}

