/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private static final int THRESHOLD = 5120;
    private Collection<Attachment> atts;
    private boolean isXop;
    private QName lastElementName;

    public JAXBAttachmentMarshaller(Collection<Attachment> attachments) {
        this.atts = attachments;
        this.isXop = attachments != null;
    }

    public QName getLastMTOMElementName() {
        return this.lastElementName;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNS, String elementLocalName) {
        String id;
        if (!this.isXop) {
            return null;
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        if ("application/octet-stream".equals(mimeType) && length < 5120) {
            return null;
        }
        ByteDataSource source = new ByteDataSource(data, offset, length);
        source.setContentType(mimeType);
        DataHandler handler = new DataHandler((DataSource)source);
        try {
            id = AttachmentUtil.createContentID((String)elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault((Throwable)e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(this.isXop);
        this.atts.add((Attachment)att);
        this.lastElementName = new QName(elementNS, elementLocalName);
        return "cid:" + id;
    }

    public String addMtomAttachment(DataHandler handler, String elementNS, String elementLocalName) {
        String id;
        if (!this.isXop) {
            return null;
        }
        try {
            DataSource ds = handler.getDataSource();
            if (ds instanceof FileDataSource) {
                FileDataSource fds = (FileDataSource)ds;
                File file = fds.getFile();
                if (file.length() < 5120L) {
                    return null;
                }
            } else if (ds.getClass().getName().endsWith("ObjectDataSource")) {
                Object o = handler.getContent();
                if (o instanceof String && ((String)o).length() < 5120) {
                    return null;
                }
                if (o instanceof byte[] && ((byte[])o).length < 5120) {
                    return null;
                }
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        try {
            id = AttachmentUtil.createContentID((String)elementNS);
        }
        catch (UnsupportedEncodingException e) {
            throw new Fault((Throwable)e);
        }
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(this.isXop);
        this.atts.add((Attachment)att);
        this.lastElementName = new QName(elementNS, elementLocalName);
        return "cid:" + id;
    }

    public String addSwaRefAttachment(DataHandler handler) {
        String id = UUID.randomUUID() + "@apache.org";
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(false);
        this.atts.add((Attachment)att);
        return id;
    }

    public void setXOPPackage(boolean xop) {
        this.isXop = xop;
    }

    public boolean isXOPPackage() {
        return this.isXop;
    }
}

