/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.spring.configurator.ResourceFilter;
import org.apache.cocoon.spring.configurator.impl.AbstractSettingsElementParser;
import org.apache.cocoon.spring.configurator.impl.RunningModeHelper;
import org.apache.cocoon.spring.configurator.impl.ServletContextFactoryBean;
import org.apache.cocoon.spring.configurator.impl.SettingsBeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SettingsElementParser
extends AbstractSettingsElementParser {
    public static final String RUNNING_MODE_ATTR = "runningMode";
    public static final String READ_FROM_CLASSPATH_ATTR = "readFromClasspath";
    public static final String READ_FROM_GLOBAL_LOCATION_ATTR = "readFromGlobalLocation";

    protected void createSettingsBeanFactoryPostProcessor(Element element, ParserContext parserContext, String runningMode) {
        List propertiesIncludes;
        Properties additionalProps;
        RootBeanDefinition beanDef = this.createBeanDefinition(SettingsBeanFactoryPostProcessor.class.getName(), "init", false);
        ResourceFilter resourceFilter = this.getResourceFilter();
        if (resourceFilter != null) {
            beanDef.getPropertyValues().addPropertyValue("resourceFilter", (Object)resourceFilter);
        }
        if ((additionalProps = this.getAdditionalProperties(element)) != null) {
            beanDef.getPropertyValues().addPropertyValue("additionalProperties", (Object)additionalProps);
        }
        if ((propertiesIncludes = this.getPropertyIncludes(element)) != null) {
            beanDef.getPropertyValues().addPropertyValue("directories", (Object)propertiesIncludes);
        }
        Boolean readFromClasspath = Boolean.valueOf(this.getAttributeValue(element, READ_FROM_CLASSPATH_ATTR, "true"));
        Boolean readFromGlobalLocation = Boolean.valueOf(this.getAttributeValue(element, READ_FROM_GLOBAL_LOCATION_ATTR, "true"));
        beanDef.getPropertyValues().addPropertyValue(READ_FROM_CLASSPATH_ATTR, (Object)readFromClasspath);
        beanDef.getPropertyValues().addPropertyValue(READ_FROM_GLOBAL_LOCATION_ATTR, (Object)readFromGlobalLocation);
        if (runningMode != null) {
            beanDef.getPropertyValues().addPropertyValue(RUNNING_MODE_ATTR, (Object)runningMode);
        }
        this.register((BeanDefinition)beanDef, Settings.ROLE, parserContext.getRegistry());
    }

    protected String getRunningMode(Element e) {
        return RunningModeHelper.determineRunningMode(this.getAttributeValue(e, RUNNING_MODE_ATTR, null));
    }

    protected List getBeanIncludes(Element settingsElement) {
        List includes = super.getBeanIncludes(settingsElement);
        boolean readFromClasspath = Boolean.valueOf(this.getAttributeValue(settingsElement, READ_FROM_CLASSPATH_ATTR, "true"));
        if (readFromClasspath) {
            includes.add(0, "classpath*:META-INF/cocoon/spring");
        }
        return includes;
    }

    protected List getBeanPropertyOverrideIncludes(Element settingsElement) {
        List includes = super.getBeanPropertyOverrideIncludes(settingsElement);
        boolean readFromClasspath = Boolean.valueOf(this.getAttributeValue(settingsElement, READ_FROM_CLASSPATH_ATTR, "true"));
        boolean readFromGlobalLocation = Boolean.valueOf(this.getAttributeValue(settingsElement, READ_FROM_GLOBAL_LOCATION_ATTR, "true"));
        if (readFromGlobalLocation) {
            int pos = readFromClasspath ? 1 : 0;
            includes.add(pos, "/WEB-INF/cocoon/spring");
        }
        return includes;
    }

    protected void registerComponents(Element settingsElement, ParserContext parserContext) {
        super.registerComponents(settingsElement, parserContext);
        this.addComponent(ServletContextFactoryBean.class.getName(), ServletContext.class.getName(), null, false, parserContext.getRegistry());
    }
}

