/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ChildXmlWebApplicationContext
extends XmlWebApplicationContext {
    protected String baseUrl;
    protected String beanDefinition;

    public ChildXmlWebApplicationContext() {
    }

    public ChildXmlWebApplicationContext(String url, String rootDefinition) {
        this.setBaseUrl(url);
        this.setBeanDefinition(rootDefinition);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url.endsWith("/") ? url : url + '/';
    }

    public String getBeanDefinition() {
        return this.beanDefinition;
    }

    public void setBeanDefinition(String beanDefinition) {
        this.beanDefinition = beanDefinition;
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws BeansException, IOException {
        if (this.beanDefinition != null) {
            reader.loadBeanDefinitions((Resource)new ByteArrayResource(this.beanDefinition.getBytes("utf-8")));
        }
        super.loadBeanDefinitions(reader);
    }

    protected Resource getResourceByPath(String path) {
        if (this.baseUrl != null && path != null && !path.startsWith("/") && !ResourceUtils.isUrl((String)path)) {
            String absoluteUrl = this.baseUrl + path;
            if (absoluteUrl.startsWith("classpath:")) {
                return new ClassPathResource(absoluteUrl.substring("classpath:".length()), this.getClassLoader());
            }
            try {
                URL url = new URL(absoluteUrl);
                return new UrlResource(url);
            }
            catch (MalformedURLException ex) {
                return super.getResourceByPath(absoluteUrl);
            }
        }
        return super.getResourceByPath(path);
    }

    protected String[] getDefaultConfigLocations() {
        return new String[0];
    }
}

