/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import org.apache.cocoon.spring.configurator.impl.AbstractElementParser;
import org.apache.cocoon.spring.configurator.impl.BeanMap;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class BeanMapElementParser
extends AbstractElementParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Class typeClass;
        RootBeanDefinition beanDef = this.createBeanDefinition(BeanMap.class, null, false);
        String type = this.getAttributeValue(element, "type", null);
        try {
            typeClass = ClassUtils.forName((String)type);
        }
        catch (ClassNotFoundException e) {
            throw new BeanDefinitionStoreException("Unable to load aspect class: " + type, (Throwable)e);
        }
        beanDef.getPropertyValues().addPropertyValue("type", (Object)typeClass);
        beanDef.getPropertyValues().addPropertyValue("checkParent", (Object)this.getAttributeValue(element, "check-parent", "true"));
        beanDef.getPropertyValues().addPropertyValue("stripPrefix", (Object)this.getAttributeValue(element, "strip-prefix", "true"));
        beanDef.getPropertyValues().addPropertyValue("hasProperties", (Object)this.getAttributeValue(element, "has-properties", ""));
        beanDef.getPropertyValues().addPropertyValue("keyProperty", (Object)this.getAttributeValue(element, "key-property", ""));
        if (!parserContext.isNested()) {
            this.register((BeanDefinition)beanDef, element, parserContext.getRegistry());
        }
        return beanDef;
    }
}

