/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class Axis2PortProvider
extends AbstractPortProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Axis2PortProvider.class);

    protected BindingProvider createPortObject(AbstractPortProvider.CmisServiceHolder serviceHolder) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating Web Service port object of " + serviceHolder.getServiceName() + "...");
        }
        try {
            int readTimeout;
            BindingProvider portObject = this.createPortObjectFromServiceHolder(serviceHolder, new WebServiceFeature[]{new MTOMFeature()});
            AuthenticationProvider authProvider = CmisBindingsHelper.getAuthenticationProvider(this.getSession());
            Map httpHeaders = null;
            if (authProvider != null) {
                Element soapHeader = authProvider.getSOAPHeaders((Object)portObject);
                if (soapHeader != null) {
                    TransformerFactory transFactory = TransformerFactory.newInstance();
                    Transformer transformer = transFactory.newTransformer();
                    StringWriter headerXml = new StringWriter();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform(new DOMSource(soapHeader), new StreamResult(headerXml));
                    HashMap<QName, List<String>> header = new HashMap<QName, List<String>>();
                    header.put(new QName(soapHeader.getNamespaceURI(), soapHeader.getLocalName()), Collections.singletonList(headerXml.toString()));
                    portObject.getRequestContext().put("jaxws.binding.soap.headers.outbound", header);
                }
                String url = serviceHolder.getEndpointUrl() != null ? serviceHolder.getEndpointUrl().toString() : serviceHolder.getServiceObject().getWSDLDocumentLocation().toString();
                httpHeaders = authProvider.getHTTPHeaders(url);
            }
            this.setHTTPHeaders(portObject, httpHeaders);
            this.setEndpointUrl(portObject, serviceHolder.getEndpointUrl());
            portObject.getRequestContext().put("REUSE_HTTP_CLIENT", "true");
            int connectTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                portObject.getRequestContext().put("CONNECTION_TIMEOUT", connectTimeout);
            }
            if ((readTimeout = this.getSession().get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                portObject.getRequestContext().put("SO_TIMEOUT", readTimeout);
            }
            return portObject;
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot initalize Web Services port object: " + e.getMessage(), (Throwable)e);
        }
    }
}

