/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingImpl;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisBindingFactory {
    public static final String BINDING_SPI_ATOMPUB = "org.apache.chemistry.opencmis.client.bindings.spi.atompub.CmisAtomPubSpi";
    public static final String BINDING_SPI_WEBSERVICES = "org.apache.chemistry.opencmis.client.bindings.spi.webservices.CmisWebServicesSpi";
    public static final String BINDING_SPI_BROWSER = "org.apache.chemistry.opencmis.client.bindings.spi.browser.CmisBrowserBindingSpi";
    public static final String BINDING_SPI_LOCAL = "org.apache.chemistry.opencmis.client.bindings.spi.local.CmisLocalSpi";
    public static final String DEFAULT_HTTP_INVOKER = "org.apache.chemistry.opencmis.client.bindings.spi.http.DefaultHttpInvoker";
    public static final String STANDARD_AUTHENTICATION_PROVIDER = "org.apache.chemistry.opencmis.client.bindings.spi.StandardAuthenticationProvider";
    public static final String NTLM_AUTHENTICATION_PROVIDER = "org.apache.chemistry.opencmis.client.bindings.spi.NTLMAuthenticationProvider";
    private Map<String, String> defaults = CmisBindingFactory.createNewDefaultParameters();

    public static CmisBindingFactory newInstance() {
        return new CmisBindingFactory();
    }

    public Map<String, String> getDefaultSessionParameters() {
        return this.defaults;
    }

    public void setDefaultSessionParameters(Map<String, String> sessionParameters) {
        this.defaults = sessionParameters == null ? CmisBindingFactory.createNewDefaultParameters() : sessionParameters;
    }

    public CmisBinding createCmisBinding(Map<String, String> sessionParameters) {
        return this.createCmisBinding(sessionParameters, null);
    }

    public CmisBinding createCmisBinding(Map<String, String> sessionParameters, AuthenticationProvider authenticationProvider) {
        CmisBindingFactory.checkSessionParameters(sessionParameters, true);
        this.addDefaultParameters(sessionParameters);
        return new CmisBindingImpl(sessionParameters, authenticationProvider);
    }

    public CmisBinding createCmisAtomPubBinding(Map<String, String> sessionParameters) {
        return this.createCmisAtomPubBinding(sessionParameters, null);
    }

    public CmisBinding createCmisAtomPubBinding(Map<String, String> sessionParameters, AuthenticationProvider authenticationProvider) {
        CmisBindingFactory.checkSessionParameters(sessionParameters, false);
        sessionParameters.put("org.apache.chemistry.opencmis.binding.spi.classname", BINDING_SPI_ATOMPUB);
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.httpinvoker.classname")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", DEFAULT_HTTP_INVOKER);
        }
        if (authenticationProvider == null && !sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.classname")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.classname", STANDARD_AUTHENTICATION_PROVIDER);
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.http.basic")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.http.basic", "true");
        }
        sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", "false");
        this.addDefaultParameters(sessionParameters);
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.atompub.url");
        return new CmisBindingImpl(sessionParameters, authenticationProvider);
    }

    public CmisBinding createCmisWebServicesBinding(Map<String, String> sessionParameters) {
        return this.createCmisWebServicesBinding(sessionParameters, null);
    }

    public CmisBinding createCmisWebServicesBinding(Map<String, String> sessionParameters, AuthenticationProvider authenticationProvider) {
        CmisBindingFactory.checkSessionParameters(sessionParameters, false);
        sessionParameters.put("org.apache.chemistry.opencmis.binding.spi.classname", BINDING_SPI_WEBSERVICES);
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.httpinvoker.classname")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", DEFAULT_HTTP_INVOKER);
        }
        if (authenticationProvider == null && !sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.classname")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.classname", STANDARD_AUTHENTICATION_PROVIDER);
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", "true");
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.http.basic")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.http.basic", "true");
        }
        this.addDefaultParameters(sessionParameters);
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.ACLService", "org.apache.chemistry.opencmis.binding.webservices.ACLService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", "org.apache.chemistry.opencmis.binding.webservices.DiscoveryService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", "org.apache.chemistry.opencmis.binding.webservices.MultiFilingService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.NavigationService", "org.apache.chemistry.opencmis.binding.webservices.NavigationService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.ObjectService", "org.apache.chemistry.opencmis.binding.webservices.ObjectService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.PolicyService", "org.apache.chemistry.opencmis.binding.webservices.PolicyService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.RelationshipService", "org.apache.chemistry.opencmis.binding.webservices.RelationshipService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.RepositoryService", "org.apache.chemistry.opencmis.binding.webservices.RepositoryService.endpoint");
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.webservices.VersioningService", "org.apache.chemistry.opencmis.binding.webservices.VersioningService.endpoint");
        return new CmisBindingImpl(sessionParameters, authenticationProvider);
    }

    public CmisBinding createCmisBrowserBinding(Map<String, String> sessionParameters) {
        return this.createCmisBrowserBinding(sessionParameters, null);
    }

    public CmisBinding createCmisBrowserBinding(Map<String, String> sessionParameters, AuthenticationProvider authenticationProvider) {
        CmisBindingFactory.checkSessionParameters(sessionParameters, false);
        sessionParameters.put("org.apache.chemistry.opencmis.binding.spi.classname", BINDING_SPI_BROWSER);
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.httpinvoker.classname")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", DEFAULT_HTTP_INVOKER);
        }
        if (authenticationProvider == null && !sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.classname")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.classname", STANDARD_AUTHENTICATION_PROVIDER);
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.browser.succinct")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.browser.succinct", "true");
        }
        if (!sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.auth.http.basic")) {
            sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.http.basic", "true");
        }
        sessionParameters.put("org.apache.chemistry.opencmis.binding.auth.soap.usernametoken", "false");
        this.addDefaultParameters(sessionParameters);
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.browser.url");
        return new CmisBindingImpl(sessionParameters, authenticationProvider);
    }

    public CmisBinding createCmisLocalBinding(Map<String, String> sessionParameters) {
        CmisBindingFactory.checkSessionParameters(sessionParameters, false);
        sessionParameters.put("org.apache.chemistry.opencmis.binding.spi.classname", BINDING_SPI_LOCAL);
        this.addDefaultParameters(sessionParameters);
        CmisBindingFactory.check(sessionParameters, "org.apache.chemistry.opencmis.binding.local.classname");
        return new CmisBindingImpl(sessionParameters);
    }

    private static void checkSessionParameters(Map<String, String> sessionParameters, boolean mustContainSPI) {
        if (sessionParameters == null) {
            throw new IllegalArgumentException("Session parameter map not set!");
        }
        String spiClass = sessionParameters.get("org.apache.chemistry.opencmis.binding.spi.classname");
        if (mustContainSPI && (spiClass == null || spiClass.trim().length() == 0)) {
            throw new IllegalArgumentException("SPI class entry (org.apache.chemistry.opencmis.binding.spi.classname) is missing!");
        }
    }

    private static void check(Map<String, String> sessionParameters, String ... parameters) {
        for (String parameter : parameters) {
            if (!sessionParameters.containsKey(parameter)) continue;
            return;
        }
        if (parameters.length == 1) {
            throw new IllegalArgumentException("Parameter '" + parameters[0] + "' is missing!");
        }
        throw new IllegalArgumentException("One of the following parameters must be set: " + Arrays.asList(parameters).toString());
    }

    private void addDefaultParameters(Map<String, String> sessionParameters) {
        for (String key : this.defaults.keySet()) {
            if (sessionParameters.containsKey(key)) continue;
            sessionParameters.put(key, this.defaults.get(key));
        }
    }

    private static Map<String, String> createNewDefaultParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("org.apache.chemistry.opencmis.binding.cache.repositories.size", "10");
        result.put("org.apache.chemistry.opencmis.binding.cache.types.size", "100");
        result.put("org.apache.chemistry.opencmis.binding.cache.links.size", "400");
        return result;
    }
}

