/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.beanclass;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.beanclass.ClassEndpoint;
import org.apache.camel.util.IntrospectionSupport;

public class ClassComponent
extends BeanComponent {
    public ClassComponent() {
        super(ClassEndpoint.class);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BeanHolder holder;
        ClassEndpoint endpoint = new ClassEndpoint(uri, this);
        endpoint.setBeanName(remaining);
        String name = endpoint.getBeanName();
        Class<?> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(name);
        Map<String, Object> options = IntrospectionSupport.extractProperties(parameters, "bean.");
        endpoint.setParameters(options);
        if (!options.isEmpty()) {
            Object bean = this.getCamelContext().getInjector().newInstance(clazz);
            this.setProperties(bean, options);
            holder = new ConstantBeanHolder(bean, this.getCamelContext());
        } else {
            holder = new ConstantTypeBeanHolder(clazz, this.getCamelContext());
        }
        this.validateParameters(uri, options, null);
        endpoint.setBeanHolder(holder);
        return endpoint;
    }
}

