/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.translation.ocl.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.Bag;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.lang.StringUtils;

public final class OCLCollections {
    public static int count(Collection collection, Object item) {
        return collection == null ? 0 : CollectionUtils.cardinality((Object)item, (Collection)collection);
    }

    public static boolean excludes(Collection collection, Object item) {
        return collection == null || !collection.contains(item);
    }

    public static boolean excludesAll(Collection collection, Collection items) {
        boolean excludesAll = true;
        for (Object object : items) {
            if (OCLCollections.excludes(collection, object)) continue;
            excludesAll = false;
            break;
        }
        return excludesAll;
    }

    public static boolean includes(Collection collection, Object item) {
        return collection != null && collection.contains(item);
    }

    public static boolean includesAll(Collection collection, Collection items) {
        return collection != null && collection.containsAll(items);
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Object object) {
        boolean isEmpty;
        boolean bl = isEmpty = object == null;
        if (!isEmpty) {
            if (object instanceof Collection) {
                isEmpty = ((Collection)object).isEmpty();
            } else if (object instanceof String) {
                isEmpty = OCLCollections.isEmpty((String)object);
            } else if (object != null && object.getClass().isArray()) {
                isEmpty = ((Object[])object).length == 0;
            }
        }
        return isEmpty;
    }

    public static boolean isEmpty(String string) {
        return StringUtils.isBlank((String)string);
    }

    public static boolean notEmpty(Collection collection) {
        return collection != null && !OCLCollections.isEmpty(collection);
    }

    public static boolean notEmpty(Object object) {
        boolean notEmpty;
        boolean bl = notEmpty = object != null;
        if (notEmpty) {
            if (object instanceof Collection) {
                notEmpty = !((Collection)object).isEmpty();
            } else if (object instanceof String) {
                notEmpty = OCLCollections.notEmpty((String)object);
            } else if (object != null && object.getClass().isArray()) {
                notEmpty = ((Object[])object).length > 0;
            }
        }
        return notEmpty;
    }

    public static boolean notEmpty(String string) {
        return StringUtils.isNotBlank((String)string);
    }

    public static int size(Object object) {
        int size = 0;
        if (object != null) {
            if (object instanceof Collection) {
                size = OCLCollections.size((Collection)object);
            } else if (object.getClass().isArray()) {
                size = ((Object[])object).length;
            }
        }
        return size;
    }

    public static int size(Collection collection) {
        int size = 0;
        if (collection != null) {
            size = collection.size();
        }
        return size;
    }

    public static double sum(Object collection) {
        double sum = 0.0;
        if (collection != null) {
            if (collection instanceof Collection) {
                sum = OCLCollections.sum(collection);
            } else if (collection.getClass().isArray()) {
                sum = OCLCollections.sum(Arrays.asList((Object[])collection));
            }
        }
        return sum;
    }

    public static double sum(Collection collection) {
        double sum = 0.0;
        if (collection != null && !collection.isEmpty()) {
            for (Object object : collection) {
                if (object instanceof Number) {
                    sum += ((Number)object).doubleValue();
                    continue;
                }
                throw new UnsupportedOperationException("In order to calculate the sum of a collection's elements all of them must extend Number, found: " + object.getClass().getName());
            }
        }
        return sum;
    }

    public static boolean append(List list, Object item) {
        return list == null ? false : list.add(item);
    }

    public static Object prepend(List list, Object item) {
        return list.set(0, item);
    }

    public static boolean append(Bag collection, Object item) {
        return collection == null ? false : collection.add(item);
    }

    public static Bag asBag(Collection collection) {
        return collection == null ? new HashBag() : new HashBag(collection);
    }

    public static Set asOrderedSet(Collection collection) {
        return collection == null ? Collections.emptySet() : SetUtils.orderedSet(new TreeSet(collection));
    }

    public static List asSequence(Collection collection) {
        return collection == null ? Collections.emptyList() : new ArrayList(collection);
    }

    public static Set asSet(Collection collection) {
        return collection == null ? Collections.emptySet() : new HashSet(collection);
    }

    public static Object at(List list, int index) {
        return list == null ? null : list.get(index);
    }

    public static boolean excluding(Collection collection, Object item) {
        return collection == null ? false : collection.remove(item);
    }

    public static boolean including(Collection collection, Object item) {
        return collection == null ? false : collection.add(item);
    }

    public static Collection flatten(Collection collection) {
        ArrayList flattenedCollection = new ArrayList();
        for (Object object : collection) {
            if (object instanceof Collection) {
                flattenedCollection.addAll(OCLCollections.flatten((Collection)object));
                continue;
            }
            flattenedCollection.add(object);
        }
        return flattenedCollection;
    }

    public static int indexOf(List collection, Object item) {
        return collection == null ? -1 : collection.indexOf(item);
    }

    public static void insertAt(List collection, int index, Object item) {
        collection.add(index, item);
    }

    public static Collection intersection(Collection first, Collection second) {
        return CollectionUtils.intersection((Collection)first, (Collection)second);
    }

    public static Collection union(Collection first, Collection second) {
        return CollectionUtils.union((Collection)first, (Collection)second);
    }

    public static Object last(Object object) {
        Object last = null;
        List list = OCLCollections.objectToList(object);
        if (!list.isEmpty()) {
            last = list.get(list.size() - 1);
        }
        return last;
    }

    public static Object first(Object object) {
        Object first = null;
        List list = OCLCollections.objectToList(object);
        if (!list.isEmpty()) {
            first = list.get(0);
        }
        return first;
    }

    public static Collection symmetricDifference(Collection first, Collection second) {
        return CollectionUtils.disjunction((Collection)first, (Collection)second);
    }

    public static Set subOrderedSet(Set collection) {
        throw new UnsupportedOperationException(OCLCollections.class.getName() + ".subOrderedSet");
    }

    public static List subSequence(List collection) {
        throw new UnsupportedOperationException(OCLCollections.class.getName() + ".subSequence");
    }

    public static Object any(Collection collection, Predicate predicate) {
        ArrayList selectedElements = new ArrayList(OCLCollections.select(collection, predicate));
        Random random = new Random(System.currentTimeMillis());
        return selectedElements.isEmpty() ? null : selectedElements.get(random.nextInt(selectedElements.size()));
    }

    public static Collection collect(Collection collection, Transformer transformer) {
        return CollectionUtils.collect((Collection)collection, (Transformer)transformer);
    }

    public static Collection collectNested(Collection collection) {
        throw new UnsupportedOperationException(OCLCollections.class.getName() + ".collectNested");
    }

    public static boolean exists(Collection collection, Predicate predicate) {
        return CollectionUtils.exists((Collection)collection, (Predicate)predicate);
    }

    public static boolean exists(Object collection, Predicate predicate) {
        return collection instanceof Collection ? OCLCollections.exists((Collection)collection, predicate) : false;
    }

    public static boolean forAll(Collection collection, Predicate predicate) {
        boolean valid;
        block1: {
            Object object;
            boolean bl = valid = collection != null;
            if (!valid || collection == null) break block1;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && (valid = predicate.evaluate(object = iterator.next()))) {
            }
        }
        return valid;
    }

    public static boolean forAll(Object collection, Predicate predicate) {
        boolean valid = false;
        if (collection instanceof Collection) {
            valid = OCLCollections.forAll((Collection)collection, predicate);
        }
        return valid;
    }

    public static boolean isUnique(Collection collection, Transformer transformer) {
        boolean unique = true;
        HashSet<Object> collected = new HashSet<Object>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && unique) {
            Object result = transformer.transform(iterator.next());
            if (collected.contains(result)) {
                unique = false;
                continue;
            }
            collected.add(result);
        }
        return unique;
    }

    public static boolean isUnique(Object collection, Transformer transformer) {
        boolean unique;
        boolean bl = unique = collection != null;
        if (unique && collection != null && Collection.class.isAssignableFrom(collection.getClass())) {
            unique = OCLCollections.isUnique((Collection)collection, transformer);
        }
        return unique;
    }

    public static Collection iterate(Collection collection) {
        throw new UnsupportedOperationException(OCLCollections.class.getName() + ".iterate");
    }

    public static boolean one(Collection collection, Predicate predicate) {
        boolean found = false;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                if (found) {
                    found = false;
                    break;
                }
                found = true;
            }
        }
        return found;
    }

    public static boolean one(Object collection, Predicate predicate) {
        return collection != null && Collection.class.isAssignableFrom(collection.getClass()) && OCLCollections.one((Collection)collection, predicate);
    }

    public static Collection reject(Collection collection, Predicate predicate) {
        return CollectionUtils.selectRejected((Collection)collection, (Predicate)predicate);
    }

    public static Collection select(Collection collection, Predicate predicate) {
        return CollectionUtils.select((Collection)collection, (Predicate)predicate);
    }

    public static Collection select(Object collection, Predicate predicate) {
        return CollectionUtils.select((Collection)((Collection)collection), (Predicate)predicate);
    }

    public static Collection sortedBy(Collection collection) {
        throw new UnsupportedOperationException(OCLCollections.class.getName() + ".sortedBy");
    }

    private static List objectToList(Object object) {
        List list = null;
        if (object instanceof Collection) {
            Collection collection = object;
            if (!(object instanceof List)) {
                object = new ArrayList(collection);
            }
            list = object;
        } else {
            list = new ArrayList();
            if (object != null) {
                list.add(object);
            }
        }
        return list;
    }
}

