/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.memoryimpl;

import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.StorageException;

public class TransactionLog {
    private static final byte OP_NONE = 0;
    private static final byte OP_ADD = 1;
    private static final byte OP_REMOVE = 2;
    private static final byte OP_REPLACE = 3;
    private HashMap log = new HashMap();
    private SinglevaluedIndex index;
    private boolean rollingBack = false;

    public TransactionLog(SinglevaluedIndex index) {
        this.index = index;
    }

    public void clear() {
        this.log.clear();
    }

    public void logAdd(Object key) {
        if (this.rollingBack) {
            return;
        }
        Record rec = (Record)this.log.get(key);
        if (rec == null) {
            rec = new Record(2, null);
            this.log.put(key, rec);
        } else {
            rec.opCode = (byte)3;
        }
    }

    public void logRemove(Object key, Object value) {
        if (this.rollingBack) {
            return;
        }
        Record rec = (Record)this.log.get(key);
        if (rec == null) {
            rec = new Record(1, value);
            this.log.put(key, rec);
        } else {
            this.log.remove(key);
        }
    }

    public void logReplace(Object key, Object oldValue) {
        if (this.rollingBack) {
            return;
        }
        Record rec = (Record)this.log.get(key);
        if (rec == null) {
            rec = new Record(3, oldValue);
            this.log.put(key, rec);
        }
    }

    public void logValue(Object key, Object value) {
        if (this.rollingBack) {
            return;
        }
        this.log.put(key, new Record(0, value));
    }

    public boolean isLogged(Object key) {
        return this.log.get(key) != null;
    }

    public void setDirty(Object key) {
        if (this.rollingBack) {
            return;
        }
        Record rec = (Record)this.log.get(key);
        if (rec.opCode == 0) {
            rec.opCode = (byte)3;
        }
    }

    public void rollBack() throws StorageException {
        this.rollingBack = true;
        Iterator iter = this.log.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Record rec = (Record)this.log.get(key);
            if (rec.opCode == 0) continue;
            Object value = rec.value instanceof ValueLog ? ((ValueLog)rec.value).resolveOriginalValue() : rec.value;
            switch (rec.opCode) {
                case 1: {
                    this.index.add(key, value);
                    break;
                }
                case 2: {
                    this.index.remove(key);
                    break;
                }
                case 3: {
                    this.index.replace(key, value);
                }
            }
        }
        this.rollingBack = false;
    }

    private static class Record {
        byte opCode;
        Object value;

        public Record(byte opCode, Object value) {
            this.opCode = opCode;
            this.value = value;
        }
    }

    public static interface ValueLog {
        public Object resolveOriginalValue() throws StorageException;
    }
}

