/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.repositories.emf.uml22;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.metafacade.ModelAccessFacade;
import org.andromda.core.repository.RepositoryFacadeException;
import org.andromda.metafacades.emf.uml22.UMLModelAccessFacade;
import org.andromda.metafacades.emf.uml22.UmlUtilities;
import org.andromda.repositories.emf.EMFRepositoryFacade;
import org.andromda.repositories.emf.uml22.EMXProxyResolvingResourceSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mapping.ecore2xml.Ecore2XMLPackage;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.resource.UML22UMLExtendedMetaData;
import org.eclipse.uml2.uml.resource.UML22UMLResource;
import org.eclipse.uml2.uml.resource.UMLResource;

public class EMFUML2RepositoryFacade
extends EMFRepositoryFacade {
    private static final Logger logger = Logger.getLogger(EMFUML2RepositoryFacade.class);

    public ResourceSet createNewResourceSet() {
        String m2repository;
        URI uri;
        String path;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registering resource factories");
        }
        EMXProxyResolvingResourceSet proxyResourceSet = new EMXProxyResolvingResourceSet();
        EPackage.Registry packageRegistry = proxyResourceSet.getPackageRegistry();
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/1.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.1.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.2.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/2.3.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/3.0.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/uml2/3.1.0/UML", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2005/Ecore2XML", (Object)Ecore2XMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.0", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.0.1", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.1", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.1.1", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.1.2", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.2", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/XMI/2.3", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/UML/2.0", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/UML/2.1", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/UML/2.1.1", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/UML/2.1.2", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/UML/2.2", (Object)UMLPackage.eINSTANCE);
        packageRegistry.put((Object)"http://schema.omg.org/spec/UML/2.3", (Object)UMLPackage.eINSTANCE);
        Map extensionToFactoryMap = proxyResourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensionToFactoryMap.put("uml", UMLResource.Factory.INSTANCE);
        extensionToFactoryMap.put("emx", UMLResource.Factory.INSTANCE);
        extensionToFactoryMap.put("epx", UMLResource.Factory.INSTANCE);
        extensionToFactoryMap.put("uml2", UML22UMLResource.Factory.INSTANCE);
        extensionToFactoryMap.put("xmi", new XMIResourceFactoryImpl());
        extensionToFactoryMap.put("xml", new XMIResourceFactoryImpl());
        this.registerOptionalRsmMetamodels(proxyResourceSet.getPackageRegistry());
        URL url = ((Object)((Object)this)).getClass().getResource("/libraries/UMLPrimitiveTypes.library.uml");
        if (url != null) {
            String path2 = url.getPath().substring(0, url.getPath().indexOf("libraries"));
            URI uri2 = URI.createURI((String)("jar:" + path2));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_LIBRARIES/"), uri2.appendSegment("libraries").appendSegment(""));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_METAMODELS/"), uri2.appendSegment("metamodels").appendSegment(""));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML_PROFILES/"), uri2.appendSegment("profiles").appendSegment(""));
        } else {
            logger.error((Object)"Could not load UML2 org.eclipse.uml2.resources jar from classpath");
        }
        Map uriMap = proxyResourceSet.getURIConverter().getURIMap();
        uriMap.putAll(UML22UMLExtendedMetaData.getURIMap());
        uriMap.put(URI.createURI((String)"http://schema.omg.org/spec/UML/2.0"), URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        uriMap.put(URI.createURI((String)"http://schema.omg.org/spec/UML/2.1"), URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        uriMap.put(URI.createURI((String)"http://schema.omg.org/spec/UML/2.1.1"), URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        uriMap.put(URI.createURI((String)"http://schema.omg.org/spec/UML/2.1.2"), URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        uriMap.put(URI.createURI((String)"http://schema.omg.org/spec/UML/2.2"), URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        uriMap.put(URI.createURI((String)"http://schema.omg.org/spec/UML/2.3"), URI.createURI((String)"http://www.eclipse.org/uml2/3.0.0/UML"));
        url = ((Object)((Object)this)).getClass().getResource("/profiles/Default.epx");
        if (url != null) {
            path = url.getPath().substring(0, url.getPath().indexOf("profiles"));
            uri = URI.createURI((String)("jar:" + path));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://UML2_MSL_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        }
        if ((url = ((Object)((Object)this)).getClass().getResource("/profiles/RUPAnalysis.epx")) != null) {
            path = url.getPath().substring(0, url.getPath().indexOf("profiles"));
            uri = URI.createURI((String)("jar:" + path));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://RUP_PROFILES/"), uri.appendSegment("profiles").appendSegment(""));
        }
        if ((m2repository = System.getenv("M2_REPO")) != null) {
            uri = URI.createURI((String)("file:" + m2repository.replace("\\", "/") + '/'));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://m2repository/"), uri.appendSegment(""));
            URIConverter.URI_MAP.put(URI.createURI((String)"pathmap://M2_REPO/"), uri.appendSegment(""));
        }
        Map loadOptions = this.getLoadOptions();
        loadOptions.put("DISABLE_NOTIFY", Boolean.FALSE);
        loadOptions.put("DOM_USE_NAMESPACES_IN_SCOPE", Boolean.TRUE);
        loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        loadOptions.put("DEFER_ATTACHMENT", Boolean.TRUE);
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("RECORD", Boolean.TRUE);
        return proxyResourceSet;
    }

    private boolean registerOptionalRsmMetamodels(EPackage.Registry registry) {
        boolean registered = this.registerOptionalMetamodel(registry, "com.ibm.xtools.umlnotation.UmlnotationPackage");
        registered = this.registerOptionalMetamodel(registry, "org.eclipse.gmf.runtime.notation.NotationPackage");
        return registered;
    }

    private boolean registerOptionalMetamodel(EPackage.Registry registry, String ePackageClassName) {
        boolean registered = false;
        try {
            Class<?> ePackageClass = Class.forName(ePackageClassName);
            if (ePackageClass != null) {
                String nsURI = (String)ePackageClass.getField("eNS_URI").get(null);
                Object eInstance = ePackageClass.getField("eINSTANCE").get(null);
                registry.put((Object)nsURI, eInstance);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Optional metamodel registered: " + nsURI));
                }
                registered = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return registered;
    }

    public final void readModel(String[] modelUris, String[] moduleSearchPaths) {
        super.readModel(modelUris, moduleSearchPaths);
    }

    public void readModel(String uri) {
        UmlUtilities.getModels().clear();
        super.readModel(uri);
        for (Resource modelResource : this.model) {
            EObject modelPackage = (EObject)EcoreUtil.getObjectByType((Collection)modelResource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEObject());
            if (modelPackage == null) {
                throw new RepositoryFacadeException("Model '" + uri + "' is not a valid EMF UML2 model: Model element not found");
            }
            if (!(modelPackage instanceof Model) && !(modelPackage instanceof Package)) {
                throw new RepositoryFacadeException("Model '" + uri + "' package " + modelPackage + " is not a valid EMF UML2 model");
            }
            if (uri.contains("profile.") || uri.contains("_Profile.")) continue;
            Package pkg = (Package)modelPackage;
            if (UmlUtilities.getModels().contains(pkg)) continue;
            UmlUtilities.getModels().add(pkg);
        }
    }

    public ModelAccessFacade getModel() {
        return this.getModel(null);
    }

    public ModelAccessFacade getModel(String uri) {
        if (this.modelFacade == null) {
            try {
                this.modelFacade = (ModelAccessFacade)ComponentContainer.instance().newComponent(UMLModelAccessFacade.class, ModelAccessFacade.class);
            }
            catch (Throwable throwable) {
                throw new RepositoryFacadeException(throwable);
            }
        }
        if (StringUtils.isNotBlank((String)uri)) {
            URI resource = URI.createURI((String)uri);
            Resource uriModel = this.resourceSet.getResource(resource, true);
            this.modelFacade.setModel((Object)uriModel);
        }
        if (this.model != null) {
            this.modelFacade.setModel((Object)this.model);
        } else {
            this.modelFacade = null;
        }
        return this.modelFacade;
    }

    public void close() {
    }
}

