/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.GeneralizableElementFacade;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.ParameterFacade;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;

public class MetafacadeUtils {
    private static final String at = "@";
    private static final char period = '.';
    private static final char underscore = '_';

    public static Object getElementAsType(Object element, Class type) {
        Class<?> elementClass;
        Object elementAsType = null;
        if (element != null && type != null && type.isAssignableFrom(elementClass = element.getClass())) {
            elementAsType = element;
        }
        return elementAsType;
    }

    public static void filterByStereotype(Collection modelElements, final String stereotype) {
        if (StringUtils.isNotBlank((String)stereotype)) {
            CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return ((ModelElementFacade)object).hasStereotype(stereotype);
                }
            });
        }
    }

    public static void filterByType(Collection modelElements, final Class type) {
        if (type != null) {
            CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return type.isAssignableFrom(object.getClass());
                }
            });
        }
    }

    public static void filterByNotType(Collection modelElements, final Class type) {
        if (type != null) {
            CollectionUtils.filter((Collection)modelElements, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    return !type.isAssignableFrom(object.getClass());
                }
            });
        }
    }

    public static String toRelationName(String roleName, String targetRoleName, String separator) {
        if (roleName.compareTo(targetRoleName) <= 0) {
            return roleName + separator + targetRoleName;
        }
        return targetRoleName + separator + roleName;
    }

    public static void sortByFullyQualifiedName(List metafacades) {
        Collections.sort(metafacades, new FullyQualifiedNameComparator());
    }

    public static String getTypedArgumentList(Collection<ParameterFacade> arguments, boolean withArgumentNames, String modifier) {
        StringBuilder buffer = new StringBuilder();
        boolean commaNeeded = false;
        for (ParameterFacade parameter : arguments) {
            String type = null;
            ClassifierFacade classifier = parameter.getType();
            if (classifier != null) {
                type = parameter.getGetterSetterTypeName();
            }
            if (commaNeeded) {
                buffer.append(", ");
            }
            if (StringUtils.isNotBlank((String)modifier)) {
                buffer.append(modifier);
                buffer.append(' ');
            }
            buffer.append(type);
            if (withArgumentNames) {
                buffer.append(' ');
                buffer.append(parameter.getName());
            }
            commaNeeded = true;
        }
        return buffer.toString();
    }

    public static String getSignature(String name, Collection<ParameterFacade> arguments, boolean withArgumentNames, String argumentModifier) {
        StringBuilder signature = new StringBuilder(name);
        signature.append('(');
        signature.append(MetafacadeUtils.getTypedArgumentList(arguments, withArgumentNames, argumentModifier));
        signature.append(')');
        return signature.toString();
    }

    public static String getEmfTaggedValue(String name) {
        if (name == null) {
            return name;
        }
        if (name.startsWith(at)) {
            name = name.substring(1);
        }
        name = name.replace('.', '_');
        return name;
    }

    public static String getUml14TaggedValue(String name) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith(at)) {
            name = at + name;
        }
        name = name.replace('_', '.');
        return name;
    }

    public static long calculateDefaultSUID(ClassifierFacade object) {
        StringBuilder buffer = new StringBuilder(object.getName());
        for (GeneralizableElementFacade generalizableElementFacade : object.getAllGeneralizations()) {
            ClassifierFacade classifier = (ClassifierFacade)generalizableElementFacade;
            buffer.append(classifier.getName());
        }
        for (AttributeFacade attribute : object.getAttributes()) {
            buffer.append(attribute.getName());
            buffer.append(attribute.getVisibility());
            buffer.append(attribute.getType().getName());
        }
        for (OperationFacade operation : object.getOperations()) {
            buffer.append(operation.getName());
            buffer.append(operation.getVisibility());
            buffer.append(operation.getReturnType().getName());
            for (ParameterFacade parameter : operation.getArguments()) {
                buffer.append(parameter.getName());
                buffer.append(parameter.getType().getName());
            }
        }
        String signature = buffer.toString();
        long serialVersionUID = 0L;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(signature.getBytes());
            long hash = 0L;
            for (int ctr = Math.min(hashBytes.length, 8) - 1; ctr >= 0; --ctr) {
                hash = hash << 8 | (long)(hashBytes[ctr] & 0xFF);
            }
            serialVersionUID = hash;
        }
        catch (NoSuchAlgorithmException ignore) {
            // empty catch block
        }
        return serialVersionUID;
    }

    private static final class FullyQualifiedNameComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        FullyQualifiedNameComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            ModelElementFacade a = (ModelElementFacade)objectA;
            ModelElementFacade b = (ModelElementFacade)objectB;
            return this.collator.compare(a.getFullyQualifiedName() != null ? a.getFullyQualifiedName() : "", b.getFullyQualifiedName() != null ? b.getFullyQualifiedName() : "");
        }
    }
}

