/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.metafacades.uml;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.metafacades.uml.AssociationEndFacade;
import org.andromda.metafacades.uml.AttributeFacade;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.Entity;
import org.andromda.metafacades.uml.EntityAssociationEnd;
import org.andromda.metafacades.uml.EntityAttribute;
import org.andromda.metafacades.uml.MetafacadeUtils;
import org.andromda.metafacades.uml.ModelElementFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EntityMetafacadeUtils {
    private static final Logger LOGGER = Logger.getLogger(EntityMetafacadeUtils.class);
    private static List<Entity> sortedEntities;
    private static Collection<String> foreignKeyConstraintNameCache;

    public static String toSqlName(String modelElementName, Object separator) {
        ExceptionUtils.checkEmpty((String)"modelElementName", (String)modelElementName);
        StringBuilder sqlName = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(StringUtils.uncapitalize((String)modelElementName));
        char character = iterator.first();
        while (character != '\uffff') {
            if (Character.isUpperCase(character)) {
                sqlName.append(separator);
            }
            character = Character.toUpperCase(character);
            sqlName.append(character);
            character = iterator.next();
        }
        return StringEscapeUtils.escapeSql((String)sqlName.toString());
    }

    public static String getSqlNameFromTaggedValue(String prefix, ModelElementFacade element, String name, Short nameMaxLength, Object separator) {
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue(prefix, element, name, nameMaxLength, null, separator);
    }

    public static String getSqlNameFromTaggedValue(ModelElementFacade element, String name, Short nameMaxLength, String suffix, Object separator) {
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue(null, element, name, nameMaxLength, suffix, separator);
    }

    public static String getSqlNameFromTaggedValue(ModelElementFacade element, String name, Short nameMaxLength, Object separator) {
        return EntityMetafacadeUtils.getSqlNameFromTaggedValue(null, element, name, nameMaxLength, null, separator);
    }

    public static String getSqlNameFromTaggedValue(String prefix, ModelElementFacade element, String name, Short nameMaxLength, String suffix, Object separator) {
        if (element != null) {
            Object value = element.findTaggedValue(name);
            StringBuilder buffer = new StringBuilder(StringUtils.trimToEmpty((String)((String)value)));
            if (StringUtils.isEmpty((String)buffer.toString())) {
                buffer = new StringBuilder(EntityMetafacadeUtils.toSqlName(element.getName(), separator));
                suffix = StringUtils.trimToEmpty((String)suffix);
                prefix = StringUtils.trimToEmpty((String)prefix);
                if (nameMaxLength != null) {
                    short maxLength = (short)(nameMaxLength - suffix.length() - prefix.length());
                    buffer = new StringBuilder(EntityMetafacadeUtils.ensureMaximumNameLength(buffer.toString(), maxLength));
                }
                if (StringUtils.isNotBlank((String)prefix)) {
                    buffer.insert(0, prefix);
                }
                if (StringUtils.isNotBlank((String)suffix)) {
                    buffer.append(suffix);
                }
            }
            name = buffer.toString();
        }
        return name;
    }

    public static List<Entity> sortEntities(Collection<Entity> entities, boolean ascending) {
        ArrayList<Entity> sorted = new ArrayList();
        if (sortedEntities != null && !sortedEntities.isEmpty()) {
            sorted = sortedEntities;
        } else if (entities != null) {
            ArrayList<Entity> toBeMoved = new ArrayList<Entity>();
            ArrayList<Entity> unsorted = new ArrayList<Entity>();
            for (Entity entity : entities) {
                if (entity.isAbstract()) {
                    toBeMoved.add(entity);
                    continue;
                }
                Collection<ClassifierFacade> ends = entity.getNavigableConnectingEnds();
                if (entity.getNavigableConnectingEnds().size() == 0) {
                    sorted.add(entity);
                    continue;
                }
                unsorted.add(entity);
            }
            for (Entity entity : toBeMoved) {
                entities.remove(entity);
            }
            int moveCount = 1;
            while (unsorted.size() > 0 && moveCount > 0) {
                toBeMoved = new ArrayList();
                for (Entity entity : unsorted) {
                    Collection<ClassifierFacade> ends = entity.getNavigableConnectingEnds();
                    boolean createFirst = true;
                    for (ClassifierFacade entityEnd : ends) {
                        int referencedPosition = unsorted.lastIndexOf(entityEnd);
                        if (referencedPosition <= -1 || entityEnd.getFullyQualifiedName().equals(entity.getFullyQualifiedName())) continue;
                        createFirst = false;
                        break;
                    }
                    if (!createFirst) continue;
                    toBeMoved.add(entity);
                }
                moveCount = toBeMoved.size();
                for (Entity entity : toBeMoved) {
                    unsorted.remove(entity);
                    sorted.add(entity);
                }
            }
            if (moveCount == 0 && unsorted.size() > 0) {
                String circular = "Circular relationships between Entities:";
                for (Entity entity : unsorted) {
                    circular = circular + " " + entity.getName();
                }
                LOGGER.error((Object)circular);
            }
            sorted.addAll(unsorted);
            sortedEntities = sorted;
        }
        if (!ascending) {
            Collections.reverse(sorted);
        }
        return sorted;
    }

    public static int getPriority(Entity entity) {
        int priority = 0;
        if (sortedEntities != null && !sortedEntities.isEmpty()) {
            priority = sortedEntities.indexOf(entity);
            priority = priority < 1 ? 0 : priority * 10 + 10;
        }
        return priority;
    }

    public static String ensureMaximumNameLength(String name, Short nameMaxLength) {
        if (StringUtils.isNotBlank((String)name) && nameMaxLength != null) {
            short max = nameMaxLength;
            if (name.length() > max) {
                name = name.substring(0, max);
            }
        }
        return name;
    }

    public static Collection<EntityAttribute> getIdentifiers(Entity entity, boolean follow) {
        ArrayList<AttributeFacade> attributes = new ArrayList<AttributeFacade>(entity.getAttributes());
        MetafacadeUtils.filterByStereotype(attributes, UMLProfile.STEREOTYPE_IDENTIFIER);
        ArrayList<EntityAttribute> identifiers = new ArrayList<EntityAttribute>();
        identifiers.addAll(attributes);
        if (identifiers.isEmpty() && follow && entity.getGeneralization() instanceof Entity) {
            identifiers.addAll(EntityMetafacadeUtils.getIdentifiers((Entity)entity.getGeneralization(), follow));
        }
        return identifiers;
    }

    public static Collection<EntityAttribute> getIdentifierAttributes(Entity entity, boolean follow) {
        String joinOrder;
        ArrayList<EntityAttribute> identifierAttributes = new ArrayList<EntityAttribute>();
        Collection<EntityAttribute> identifiers = EntityMetafacadeUtils.getIdentifiers(entity, follow);
        for (EntityAttribute identifier : identifiers) {
            if (identifier instanceof AssociationEndFacade) {
                AssociationEndFacade associationEnd = (AssociationEndFacade)((Object)identifier);
                ClassifierFacade classifier = associationEnd.getType();
                if (!(classifier instanceof Entity)) continue;
                Collection<EntityAttribute> entityIdentifiers = EntityMetafacadeUtils.getIdentifierAttributes((Entity)classifier, true);
                identifierAttributes.addAll(entityIdentifiers);
                continue;
            }
            identifierAttributes.add(identifier);
        }
        if (identifiers.isEmpty() && follow && entity.getGeneralization() instanceof Entity) {
            identifierAttributes.addAll(EntityMetafacadeUtils.getIdentifiers((Entity)entity.getGeneralization(), follow));
        }
        if (StringUtils.isNotBlank((String)(joinOrder = (String)entity.findTaggedValue("andromda_persistence_joincolumn_order")))) {
            String[] joinList;
            ArrayList<EntityAttribute> sortedIdentifiers = new ArrayList<EntityAttribute>();
            for (String column : joinList = StringUtils.split((String)joinOrder, (String)" ,;|")) {
                for (EntityAttribute facade : identifierAttributes) {
                    EntityAttribute attr = facade;
                    if (!attr.getColumnName().equalsIgnoreCase(column)) continue;
                    sortedIdentifiers.add(attr);
                }
            }
            if (sortedIdentifiers.size() < identifierAttributes.size()) {
                for (EntityAttribute facade : identifierAttributes) {
                    if (sortedIdentifiers.contains(facade)) continue;
                    sortedIdentifiers.add(facade);
                }
            }
            identifierAttributes = sortedIdentifiers;
        } else {
            identifiers.addAll(identifierAttributes);
        }
        return identifierAttributes;
    }

    public static String constructSqlTypeName(String typeName, String columnLength) {
        String value = typeName;
        if (StringUtils.isNotBlank((String)typeName)) {
            int beginChar = 40;
            int endChar = 41;
            int beginIndex = value.indexOf(40);
            int endIndex = value.indexOf(41);
            if (beginIndex != -1 && endIndex != -1 && endIndex > beginIndex) {
                String replacement = value.substring(beginIndex, endIndex) + ')';
                value = StringUtils.replace((String)value, (String)replacement, (String)('(' + columnLength + ')'));
            } else {
                value = value + '(' + columnLength + ')';
            }
        }
        return value;
    }

    public static String getForeignKeyConstraintName(EntityAssociationEnd associationEnd, String suffix, String sqlNameSeparator, String maxLengthProperty) {
        String constraintName;
        Object taggedValueObject = associationEnd.findTaggedValue(UMLProfile.TAGGEDVALUE_PERSISTENCE_FOREIGN_KEY_CONSTRAINT_NAME);
        if (taggedValueObject == null) {
            StringBuilder buffer = new StringBuilder();
            ClassifierFacade type = associationEnd.getOtherEnd().getType();
            if (type instanceof Entity) {
                Entity entity = (Entity)type;
                buffer.append(entity.getTableName());
            } else {
                buffer.append(type.getName().toUpperCase());
            }
            buffer.append(sqlNameSeparator);
            buffer.append(associationEnd.getColumnName());
            constraintName = buffer.toString();
            short maxLength = (short)(Short.valueOf(maxLengthProperty) - suffix.length());
            buffer = new StringBuilder(EntityMetafacadeUtils.ensureMaximumNameLength(constraintName, maxLength));
            buffer.append(suffix);
            constraintName = EntityMetafacadeUtils.getUniqueForeignKeyConstraintName(buffer.toString());
        } else {
            constraintName = taggedValueObject.toString();
        }
        return constraintName;
    }

    private static String getUniqueForeignKeyConstraintName(String proposedName) {
        char[] characters = proposedName.toCharArray();
        int numericValue = 0;
        for (int ctr = 0; ctr < characters.length; ++ctr) {
            numericValue += Character.getNumericValue(characters[0]);
        }
        return EntityMetafacadeUtils.getUniqueForeignKeyConstraintName(proposedName, new Random(numericValue));
    }

    private static String getUniqueForeignKeyConstraintName(String proposedName, Random random) {
        String name;
        if (foreignKeyConstraintNameCache.contains(proposedName)) {
            char[] characters = proposedName.toCharArray();
            int randomInt = random.nextInt(characters.length);
            char randomChar = Character.toUpperCase(characters[randomInt]);
            proposedName = proposedName.substring(0, proposedName.length() - 1) + randomChar;
            name = EntityMetafacadeUtils.getUniqueForeignKeyConstraintName(proposedName, random);
        } else {
            name = proposedName;
            foreignKeyConstraintNameCache.add(name);
        }
        return name;
    }

    public static void clearForeignKeyConstraintNameCache() {
        foreignKeyConstraintNameCache.clear();
    }

    static {
        foreignKeyConstraintNameCache = new ArrayList<String>();
    }
}

