/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.runners;

import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepPublisher;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.Statement;

public class ThucydidesStatement
extends Statement {
    private final Statement statement;
    private final StepPublisher publisher;

    public ThucydidesStatement(Statement statement, StepPublisher publisher) {
        this.statement = statement;
        this.publisher = publisher;
    }

    public void evaluate() throws Throwable {
        try {
            this.statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            StepEventBus.getEventBus().assumptionViolated(e.getMessage());
        }
        this.checkForStepFailures();
        this.checkForAssumptionViolations();
    }

    private void checkForStepFailures() throws Throwable {
        if (this.publisher.aStepHasFailed()) {
            System.out.println(this.publisher.getTestFailureCause().toException());
            throw this.publisher.getTestFailureCause().toException();
        }
    }

    private void checkForAssumptionViolations() {
        if (StepEventBus.getEventBus().assumptionViolated()) {
            throw new AssumptionViolatedException(StepEventBus.getEventBus().getAssumptionViolatedMessage());
        }
    }
}

