/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.junit.finder;

import net.thucydides.junit.finder.DataDrivenTestFinder;
import net.thucydides.junit.finder.DefaultTestFinder;
import net.thucydides.junit.finder.FinderType;
import net.thucydides.junit.finder.NormalTestFinder;
import net.thucydides.junit.finder.TestFinder;

public class TestFinderBuilder {
    private final FinderType finderType;

    public static TestFinderBuilder on(FinderType finderType) {
        return new TestFinderBuilder(finderType);
    }

    protected TestFinderBuilder(FinderType finderType) {
        this.finderType = finderType;
    }

    public TestFinder inPackage(String rootPackage) {
        switch (this.finderType) {
            case NORMAL_TESTS: {
                return new NormalTestFinder(rootPackage);
            }
            case DATA_DRIVEN_TESTS: {
                return new DataDrivenTestFinder(rootPackage);
            }
        }
        return new DefaultTestFinder(rootPackage);
    }
}

