/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveDriver;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.SuffixSet;

class ArchiveDriverRegistry
extends HashMap {
    private static final long serialVersionUID = 3445783613096128268L;
    private static final String CLASS_NAME = "de/schlichtherle/io/ArchiveDriverRegistry".replace('/', '.');
    private static final ResourceBundle resources = ResourceBundle.getBundle(CLASS_NAME);
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    static final String KWD_DRIVER = "DRIVER";
    static final String KWD_DEFAULT = "DEFAULT";
    private final ArchiveDriverRegistry delegate;

    ArchiveDriverRegistry() {
        this.delegate = null;
    }

    ArchiveDriverRegistry(ArchiveDriverRegistry delegate, Map config) {
        if (delegate == null) {
            throw new NullPointerException(ArchiveDriverRegistry.getString("null", "delegate"));
        }
        this.delegate = delegate;
        this.registerArchiveDrivers(config, true);
    }

    final void registerArchiveDrivers(Map config, boolean eager) {
        try {
            for (Map.Entry entry : config.entrySet()) {
                String key = (String)entry.getKey();
                if (KWD_DRIVER.equals(key)) {
                    throw new IllegalArgumentException(ArchiveDriverRegistry.getString("keyword", KWD_DRIVER));
                }
                Object value = entry.getValue();
                if (KWD_DEFAULT.equals(key)) {
                    if (eager) {
                        throw new IllegalArgumentException(ArchiveDriverRegistry.getString("keyword", KWD_DEFAULT));
                    }
                    SuffixSet set = (SuffixSet)super.get(key);
                    if (set != null) {
                        set.addAll((String)value);
                        continue;
                    }
                    super.put(key, new SuffixSet((String)value));
                    continue;
                }
                this.registerArchiveDriver(key, value, eager);
            }
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (RuntimeException rte) {
            IllegalArgumentException iae = new IllegalArgumentException(rte.toString());
            iae.initCause(rte);
            throw iae;
        }
    }

    private void registerArchiveDriver(String list, Object driver, boolean eager) {
        if (list == null) {
            throw new NullPointerException(ArchiveDriverRegistry.getString("noSuffixes"));
        }
        SuffixSet set = new SuffixSet(list);
        if (set.isEmpty()) {
            if (eager) {
                throw new IllegalArgumentException(ArchiveDriverRegistry.getString("noSuffixes"));
            }
            logger.log(Level.WARNING, "noSuffixes");
        } else {
            driver = eager ? ArchiveDriverRegistry.createArchiveDriver(driver) : (String)driver;
            Iterator i = set.iterator();
            while (i.hasNext()) {
                super.put((String)i.next(), driver);
            }
        }
    }

    public final synchronized ArchiveDriver getArchiveDriver(String suffix) {
        Object driver = super.get(suffix);
        if (!(driver instanceof ArchiveDriver)) {
            if (driver == null) {
                if (super.containsKey(suffix) || this.delegate == null) {
                    return null;
                }
                driver = this.delegate.getArchiveDriver(suffix);
            } else {
                driver = ArchiveDriverRegistry.createArchiveDriver(driver);
                logger.log(Level.FINE, "installed", new Object[]{suffix, driver});
            }
            super.put(suffix, driver);
        }
        return (ArchiveDriver)driver;
    }

    private static final ArchiveDriver createArchiveDriver(Object driver) {
        try {
            if (driver instanceof String) {
                driver = Thread.currentThread().getContextClassLoader().loadClass((String)((Object)driver));
            }
            if (driver instanceof Class) {
                driver = ((Class)driver).newInstance();
            }
            return (ArchiveDriver)((Object)driver);
        }
        catch (Exception ex) {
            throw new IllegalArchiveDriverException(ArchiveDriverRegistry.getString("cannotCreate"), ex);
        }
    }

    public final SuffixSet suffixes() {
        return this.decorate(this.delegate != null ? this.delegate.suffixes() : new SuffixSet());
    }

    public final SuffixSet decorate(SuffixSet set) {
        SuffixSet local = new SuffixSet(super.keySet());
        for (String suffix : local) {
            assert (super.containsKey(suffix));
            if (super.get(suffix) != null) {
                set.addAll(suffix);
                continue;
            }
            set.removeAll(suffix);
        }
        return set;
    }

    private static final String getString(String key) {
        return resources.getString(key);
    }

    private static final String getString(String key, String arg) {
        return MessageFormat.format(resources.getString(key), arg);
    }

    static class IllegalArchiveDriverException
    extends IllegalArgumentException {
        private IllegalArchiveDriverException(String msg, Exception ex) {
            super(msg);
            this.initCause(ex);
        }
    }
}

