/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.scope;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import net.contextfw.web.application.PageHandle;
import net.contextfw.web.application.WebApplication;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.configuration.SettableProperty;
import net.contextfw.web.application.scope.ScopedWebApplicationExecution;
import net.contextfw.web.application.scope.WebApplicationStorage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultWebApplicationStorage
implements WebApplicationStorage {
    private static final int MAX_LENGTH = 16;
    private Logger logger = LoggerFactory.getLogger(DefaultWebApplicationStorage.class);
    private final Map<PageHandle, Holder> pages = new HashMap<PageHandle, Holder>();
    public static final SettableProperty<Boolean> PROXIED = Configuration.createProperty(Boolean.class, DefaultWebApplicationStorage.class.getName() + ".proxied");
    private final boolean proxied;

    @Inject
    public DefaultWebApplicationStorage(Configuration configuration) {
        this.proxied = configuration.getOrElse(PROXIED, false);
        Timer timer = new Timer(true);
        this.logger.info("Starting scheduled removal for expired web applications");
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DefaultWebApplicationStorage.this.removeExpiredPages();
            }
        }, configuration.get(Configuration.REMOVAL_SCHEDULE_PERIOD), (long)configuration.get(Configuration.REMOVAL_SCHEDULE_PERIOD));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(WebApplication application, HttpServletRequest request, long validThrough, ScopedWebApplicationExecution execution) {
        PageHandle handle = this.createHandle();
        application.setHandle(handle);
        Holder holder = new Holder(application, this.getRemoteAddr(request), validThrough);
        Object object = this;
        synchronized (object) {
            this.pages.put(handle, holder);
        }
        object = holder;
        synchronized (object) {
            execution.execute(holder.application);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(PageHandle handle, HttpServletRequest request, long validThrough, ScopedWebApplicationExecution execution) {
        Holder holder = this.getHolder(handle, request);
        if (holder != null) {
            Holder holder2 = holder;
            synchronized (holder2) {
                holder.validThrough = validThrough;
                execution.execute(holder.application);
            }
        } else {
            execution.execute(null);
        }
    }

    @Override
    public void refresh(PageHandle handle, HttpServletRequest request, long validThrough) {
        Holder holder = this.getHolder(handle, request);
        if (holder != null) {
            holder.validThrough = validThrough;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder getHolder(PageHandle handle, HttpServletRequest request) {
        Holder holder;
        DefaultWebApplicationStorage defaultWebApplicationStorage = this;
        synchronized (defaultWebApplicationStorage) {
            holder = this.pages.get(handle);
        }
        String remoteAddr = this.getRemoteAddr(request);
        long now = System.currentTimeMillis();
        if (holder != null && holder.remoteAddr.equals(remoteAddr) && holder.validThrough >= now) {
            return holder;
        }
        return null;
    }

    @Override
    public synchronized void remove(PageHandle handle, HttpServletRequest request) {
        Holder holder = this.getHolder(handle, request);
        if (holder != null) {
            this.pages.remove(handle);
            this.pageRemoved(handle, this.pages.size(), this.getRemoteAddr(request));
        }
    }

    protected String getRemoteAddr(HttpServletRequest request) {
        if (this.proxied) {
            String proxy = StringUtils.trimToEmpty((String)request.getHeader("X-Forwarded-For"));
            int length = proxy.length();
            if (length > 16) {
                return proxy.substring(length - 16, length);
            }
            return proxy;
        }
        return request.getRemoteAddr();
    }

    protected void pageRemoved(PageHandle handle, int pageCount, String remoteAddr) {
    }

    protected void pageExpired(PageHandle handle, int pageCount, String remoteAddr) {
    }

    protected void throttle() {
    }

    private synchronized void removeExpiredPages() {
        long now = System.currentTimeMillis();
        try {
            Iterator<Map.Entry<PageHandle, Holder>> iterator = this.pages.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<PageHandle, Holder> entry = iterator.next();
                if (entry.getValue().validThrough >= now) continue;
                this.pageExpired(entry.getKey(), this.pages.size(), entry.getValue().remoteAddr);
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    protected PageHandle createHandle() {
        PageHandle handle = new PageHandle(UUID.randomUUID().toString());
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(PageHandle handle, ScopedWebApplicationExecution execution) {
        Holder holder;
        Object object = this;
        synchronized (object) {
            holder = this.pages.get(handle);
        }
        if (holder != null) {
            object = holder;
            synchronized (object) {
                execution.execute(holder.application);
            }
        } else {
            execution.execute(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeLarge(PageHandle handle, String key, Object obj) {
        if (handle == null) {
            throw new IllegalArgumentException("Handle cannot be null");
        }
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        DefaultWebApplicationStorage defaultWebApplicationStorage = this;
        synchronized (defaultWebApplicationStorage) {
            Holder holder = this.pages.get(handle);
            if (holder == null) {
                throw new WebApplicationException("Page scope does not exist!");
            }
            if (obj == null) {
                holder.largeObjects.remove(key);
            } else {
                holder.largeObjects.put(key, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T loadLarge(PageHandle handle, String key, Class<T> type) {
        if (handle == null) {
            throw new IllegalArgumentException("Handle cannot be null");
        }
        if (StringUtils.isBlank((String)key)) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        DefaultWebApplicationStorage defaultWebApplicationStorage = this;
        synchronized (defaultWebApplicationStorage) {
            Holder holder = this.pages.get(handle);
            if (holder == null) {
                throw new WebApplicationException("Page scope does not exist!");
            }
            return (T)holder.largeObjects.get(key);
        }
    }

    private static final class Holder {
        private long validThrough;
        private final String remoteAddr;
        private final WebApplication application;
        private final Map<String, Object> largeObjects = new HashMap<String, Object>();

        private Holder(WebApplication application, String remoteAddr, long validThrough) {
            this.application = application;
            this.remoteAddr = remoteAddr;
            this.validThrough = validThrough;
        }
    }
}

