/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.internal.util.AbstractScanner;
import net.contextfw.web.application.internal.util.ResourceEntry;
import net.contextfw.web.application.remote.Remoted;

public class ClassScanner
extends AbstractScanner {
    private static final int POSTFIX = "class.".length();

    public static List<Class<?>> getClasses(String ... packageNames) {
        ArrayList<String> list = new ArrayList<String>(packageNames.length);
        Collections.addAll(list, packageNames);
        return ClassScanner.getClasses(list);
    }

    public static List<Class<?>> getClasses(Iterable<String> packageNames) {
        ArrayList classes = new ArrayList();
        try {
            for (String packageName : packageNames) {
                ArrayList<String> resourcePaths = new ArrayList<String>();
                resourcePaths.add(packageName);
                List<ResourceEntry> entries = ClassScanner.findResourceEntries(resourcePaths);
                for (ResourceEntry entry : entries) {
                    Class<?> klass;
                    String fileName = entry.getPath();
                    if (!fileName.endsWith(".class") || fileName.contains("$")) continue;
                    String className = ClassScanner.toClassName(fileName);
                    try {
                        klass = Class.forName(className);
                    }
                    catch (ExceptionInInitializerError e) {
                        klass = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
                    }
                    classes.add(klass);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new WebApplicationException(e);
        }
        return classes;
    }

    private static String toClassName(String fileName) {
        return fileName.substring(0, fileName.length() - POSTFIX).replaceAll("/", "\\.");
    }

    public static List<Class<?>> getParamTypes(Class<?> declaringClass, Method method) {
        Type[] types;
        int i;
        HashMap<String, Class> typeVariables = new HashMap<String, Class>();
        Type parametrizedType = declaringClass.getGenericSuperclass();
        if (parametrizedType instanceof ParameterizedType) {
            TypeVariable<Class<?>>[] tv = method.getDeclaringClass().getTypeParameters();
            Type[] paramTypes = ((ParameterizedType)parametrizedType).getActualTypeArguments();
            for (i = 0; i < tv.length; ++i) {
                typeVariables.put(tv[i].getName(), (Class)paramTypes[i]);
            }
        }
        if ((types = method.getGenericParameterTypes()).length == 0) {
            return Collections.emptyList();
        }
        ArrayList rv = new ArrayList(types.length);
        for (i = 0; i < types.length; ++i) {
            if (types[i] instanceof TypeVariable) {
                rv.add((Class<?>)typeVariables.get(((TypeVariable)types[i]).getName()));
                continue;
            }
            rv.add((Class)types[i]);
        }
        return rv;
    }

    public static Method findMethodForName(Class<? extends Component> cls, String methodName) {
        Class<? extends Component> current = cls;
        Method foundMethod = null;
        while (Component.class.isAssignableFrom(current)) {
            for (Method method : current.getDeclaredMethods()) {
                if (foundMethod == null && method.getAnnotation(Remoted.class) == null && method.getName().equals(methodName)) {
                    foundMethod = method;
                    continue;
                }
                if (method.getAnnotation(Remoted.class) == null || !method.getName().equals(methodName)) continue;
                return foundMethod == null ? method : foundMethod;
            }
            current = current.getSuperclass();
        }
        return null;
    }
}

