/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.internal.util.FileResourceEntry;
import net.contextfw.web.application.internal.util.JarResourceEntry;
import net.contextfw.web.application.internal.util.ResourceEntry;

public abstract class AbstractScanner {
    private static final String FILE = "file";
    private static final String CLASSPATH = "classpath";

    protected AbstractScanner() {
    }

    protected static List<ResourceEntry> findResourceEntries(List<String> resourcePaths) {
        ArrayList<ResourceEntry> entries = new ArrayList<ResourceEntry>();
        List<URI> rootURIs = AbstractScanner.toURIs(resourcePaths);
        try {
            for (URI rootURI : rootURIs) {
                if (FILE.equals(rootURI.getScheme())) {
                    entries.addAll(AbstractScanner.findResourcesFromFilesystem(rootURI));
                    continue;
                }
                if (!CLASSPATH.equals(rootURI.getScheme())) continue;
                Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(rootURI.getSchemeSpecificPart());
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    if (FILE.equals(resource.getProtocol())) {
                        entries.addAll(AbstractScanner.findResourcesFromFilesystem(rootURI.getSchemeSpecificPart(), resource));
                        continue;
                    }
                    if ("jar".equals(resource.getProtocol())) {
                        entries.addAll(AbstractScanner.findResourcesFromJar(resource));
                        continue;
                    }
                    throw new WebApplicationException("Protocol " + resource.getProtocol() + " is not supported");
                }
            }
        }
        catch (IOException e) {
            throw new WebApplicationException(e);
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException(e);
        }
        return entries;
    }

    private static Collection<? extends ResourceEntry> findResourcesFromJar(URL directory) throws IOException {
        ArrayList<JarResourceEntry> resources = new ArrayList<JarResourceEntry>();
        String jarPath = directory.getPath().substring(5, directory.getPath().indexOf("!"));
        String path = directory.getPath().substring(directory.getPath().indexOf("!") + 2);
        JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(path) || entry.isDirectory()) continue;
            resources.add(new JarResourceEntry(jar, entry));
        }
        return resources;
    }

    private static Collection<? extends ResourceEntry> findResourcesFromFilesystem(String pathPrefix, URL rootUrl) throws URISyntaxException, FileNotFoundException, UnsupportedEncodingException {
        File rootDirectory = new File(URLDecoder.decode(rootUrl.getFile(), "UTF-8"));
        if (rootDirectory.isDirectory()) {
            return AbstractScanner.findResourcesFromFilesystem(pathPrefix + "/", rootDirectory);
        }
        return Collections.emptyList();
    }

    private static Collection<? extends ResourceEntry> findResourcesFromFilesystem(URI rootURI) throws FileNotFoundException {
        File rootDirectory = new File(rootURI.getSchemeSpecificPart());
        if (!rootDirectory.isDirectory()) {
            throw new WebApplicationException("File " + rootDirectory.getAbsolutePath() + " is not a directory");
        }
        return AbstractScanner.findResourcesFromFilesystem(rootURI.getSchemeSpecificPart() + "/", rootDirectory);
    }

    private static Collection<? extends ResourceEntry> findResourcesFromFilesystem(String pathPrefix, File rootDirectory) throws FileNotFoundException {
        ArrayList<FileResourceEntry> entries = new ArrayList<FileResourceEntry>();
        if (!rootDirectory.exists()) {
            throw new WebApplicationException("Directory " + rootDirectory.getAbsolutePath() + " does not exist");
        }
        int length = rootDirectory.getPath().length() + 1;
        ArrayList<File> directories = new ArrayList<File>();
        directories.add(rootDirectory);
        while (!directories.isEmpty()) {
            File dir = (File)directories.remove(0);
            for (File child : dir.listFiles()) {
                if (child.isDirectory()) {
                    directories.add(child);
                    continue;
                }
                entries.add(new FileResourceEntry(pathPrefix + child.getPath().substring(length), child));
            }
        }
        return entries;
    }

    public static List<URI> toURIs(Collection<String> resourcePaths) {
        ArrayList<URI> roots = new ArrayList<URI>(resourcePaths.size());
        for (String path : resourcePaths) {
            int separator = path.indexOf(":");
            try {
                if (separator == -1) {
                    roots.add(new URI(CLASSPATH, path.replaceAll("\\.", "/"), null));
                    continue;
                }
                String scheme = path.substring(0, separator);
                String ssp = path.substring(separator + 1);
                if (!CLASSPATH.equals(scheme) && !FILE.equals(scheme)) {
                    throw new WebApplicationException("Scheme '" + scheme + "' is not supported. Path was: " + path);
                }
                roots.add(new URI(scheme, ssp, null));
            }
            catch (URISyntaxException e) {
                throw new WebApplicationException(e);
            }
        }
        return roots;
    }
}

