/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.servlet;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.internal.servlet.InitServlet;
import net.contextfw.web.application.internal.servlet.UriMapping;

public class RegexUriMapping
extends UriMapping {
    private final Pattern pattern;

    public RegexUriMapping(Class<? extends Component> viewClass, String path, InitServlet initServlet, Map<String, Pattern> variables) {
        super(viewClass, path, initServlet, UriMapping.Type.REGEX, variables);
        this.pattern = Pattern.compile(path);
    }

    @Override
    public boolean matches(String uri) {
        return null != uri && this.pattern.matcher(uri).matches();
    }

    @Override
    public String extractPath(String path) {
        int end;
        Matcher matcher = this.pattern.matcher(path);
        if (matcher.matches() && matcher.groupCount() >= 1 && (end = matcher.start(1)) < path.length()) {
            return path.substring(0, end);
        }
        return null;
    }
}

