/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.development;

import java.util.HashSet;
import java.util.Set;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.development.DevelopmentModeListener;
import net.contextfw.web.application.internal.development.ClassLoaderProvider;
import net.contextfw.web.application.internal.development.InternalDevelopmentTools;
import net.contextfw.web.application.internal.development.ReloadingClassLoaderConf;

public class DevelopmentToolsImpl
implements InternalDevelopmentTools {
    private final Set<DevelopmentModeListener> listeners = new HashSet<DevelopmentModeListener>();
    private final ClassLoaderProvider classLoaderProvider;
    private final boolean developmentMode;

    public DevelopmentToolsImpl(Configuration configuration) {
        this.classLoaderProvider = new ClassLoaderProvider(new ReloadingClassLoaderConf(configuration));
        this.developmentMode = configuration.get(Configuration.DEVELOPMENT_MODE);
    }

    @Override
    public void addListener(DevelopmentModeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    @Override
    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    @Override
    public ClassLoader reloadClasses() {
        ClassLoader classLoader = this.classLoaderProvider.reload();
        for (DevelopmentModeListener listener : this.listeners) {
            listener.classesReloaded(classLoader);
        }
        return classLoader;
    }

    @Override
    public void reloadResources() {
        for (DevelopmentModeListener listener : this.listeners) {
            listener.resourcesReloaded();
        }
    }
}

