/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.component;

import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Attribute;
import net.contextfw.web.application.component.Buildable;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.component.CustomBuild;
import net.contextfw.web.application.component.Element;
import net.contextfw.web.application.component.ScriptContext;
import net.contextfw.web.application.component.ScriptElement;
import net.contextfw.web.application.internal.component.AttributeBuilder;
import net.contextfw.web.application.internal.component.Builder;
import net.contextfw.web.application.internal.component.ComponentBuilder;
import net.contextfw.web.application.internal.component.ElementBuilder;
import net.contextfw.web.application.internal.component.FieldPropertyAccess;
import net.contextfw.web.application.internal.component.MetaComponentException;
import net.contextfw.web.application.internal.component.MethodCustomBuilder;
import net.contextfw.web.application.internal.component.MethodPropertyAccess;
import net.contextfw.web.application.internal.component.NamedBuilder;
import net.contextfw.web.application.internal.component.ScriptElementBuilder;
import net.contextfw.web.application.internal.servlet.UriMapping;
import net.contextfw.web.application.lifecycle.AfterBuild;
import net.contextfw.web.application.lifecycle.BeforeBuild;
import net.contextfw.web.application.remote.PathParam;
import net.contextfw.web.application.remote.RequestParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaComponent {
    private static Map<Class<?>, Class<?>> primitives = new HashMap();
    Logger log = LoggerFactory.getLogger(MetaComponent.class);
    private final Set<String> registeredNames = new HashSet<String>();
    private final List<Method> beforeBuilds = new ArrayList<Method>();
    private final List<Method> afterBuilds = new ArrayList<Method>();
    public final List<Builder> builders = new ArrayList<Builder>();
    public final List<Builder> updateBuilders = new ArrayList<Builder>();
    public final List<Builder> partialBuilders = new ArrayList<Builder>();
    private final List<Field> pathParamFields = new ArrayList<Field>();
    private final List<Method> pathParamMethods = new ArrayList<Method>();
    private final List<Field> requestParamFields = new ArrayList<Field>();
    private final List<Method> requestParamMethods = new ArrayList<Method>();
    private final List<Field> autoregisterFields = new ArrayList<Field>();
    private final List<Field> fields = new ArrayList<Field>();
    public final String buildName;
    public final Buildable annotation;
    private final Class<?> cl;
    private final ComponentBuilder componentBuilder;
    private final Gson gson;
    private final ScriptContext scriptContext;

    public MetaComponent(Class<?> rawCl, ComponentBuilder componentBuilder, Gson gson, ScriptContext scriptContext) {
        this.cl = MetaComponent.getActualClass(rawCl);
        this.componentBuilder = componentBuilder;
        this.gson = gson;
        this.scriptContext = scriptContext;
        this.annotation = this.findBuildable();
        if (this.annotation != null) {
            this.buildName = this.getBuildableName();
            this.iterateFields();
            this.iterateMethods();
        } else {
            this.buildName = null;
        }
    }

    private boolean processFieldBuilders(Field field) {
        FieldPropertyAccess<Object> propertyAccess = new FieldPropertyAccess<Object>(field);
        String name = null;
        NamedBuilder builder = null;
        if (field.getAnnotation(Element.class) != null) {
            Element element = field.getAnnotation(Element.class);
            name = "".equals(element.name()) ? field.getName() : element.name();
            builder = new ElementBuilder(this.componentBuilder, propertyAccess, element.wrap() ? name : null, field.getName());
            this.addToBuilders(element.onCreate(), element.onUpdate(), builder);
            if (element.autoRegister()) {
                this.autoregisterFields.add(field);
            }
        } else if (field.getAnnotation(Attribute.class) != null) {
            Attribute attribute = field.getAnnotation(Attribute.class);
            name = "".equals(attribute.name()) ? field.getName() : attribute.name();
            builder = new AttributeBuilder(propertyAccess, name, field.getName());
            this.addToBuilders(attribute.onCreate(), attribute.onUpdate(), builder);
        } else if (field.getAnnotation(ScriptElement.class) != null) {
            ScriptElement scriptElement = field.getAnnotation(ScriptElement.class);
            name = scriptElement.wrapper();
            builder = new ScriptElementBuilder(this.scriptContext, this.gson, propertyAccess, name, field.getName());
            this.addToBuilders(scriptElement.onCreate(), scriptElement.onUpdate(), builder);
        }
        return builder != null;
    }

    private boolean processMethodBuilders(Method method) {
        String name = null;
        Builder builder = null;
        if (method.getAnnotation(Element.class) != null) {
            Element element = method.getAnnotation(Element.class);
            name = "".equals(element.name()) ? method.getName() : element.name();
            builder = new ElementBuilder(this.componentBuilder, new MethodPropertyAccess(method), element.wrap() ? name : null, method.getName());
            this.addToBuilders(element.onCreate(), element.onUpdate(), builder);
        } else if (method.getAnnotation(Attribute.class) != null) {
            Attribute attribute = method.getAnnotation(Attribute.class);
            name = "".equals(attribute.name()) ? method.getName() : attribute.name();
            builder = new AttributeBuilder(new MethodPropertyAccess(method), name, method.getName());
            this.addToBuilders(attribute.onCreate(), attribute.onUpdate(), builder);
        } else if (method.getAnnotation(CustomBuild.class) != null) {
            CustomBuild customBuild = method.getAnnotation(CustomBuild.class);
            name = "".equals(customBuild.name()) ? method.getName() : customBuild.name();
            builder = new MethodCustomBuilder(method, customBuild.wrap() ? name : null);
            this.addToBuilders(customBuild.onCreate(), customBuild.onUpdate(), builder);
        } else if (method.getAnnotation(ScriptElement.class) != null) {
            ScriptElement scriptElement = method.getAnnotation(ScriptElement.class);
            name = scriptElement.wrapper();
            builder = new ScriptElementBuilder(this.scriptContext, this.gson, new MethodPropertyAccess(method), name, method.getName());
            this.addToBuilders(scriptElement.onCreate(), scriptElement.onUpdate(), builder);
        }
        return builder != null;
    }

    private boolean canProcess(Field field) {
        return !this.registeredNames.contains(field.getName());
    }

    private void setProcessed(Field field) {
        this.registeredNames.add(field.getName());
    }

    private boolean canProcess(Method method) {
        return !this.registeredNames.contains(method.getName());
    }

    private void setProcessed(Method method) {
        this.registeredNames.add(method.getName());
    }

    private void iterateFields() {
        for (Class<?> currentClass = this.cl; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!this.processField(field)) continue;
                this.setProcessed(field);
            }
        }
    }

    private boolean processField(Field field) {
        field.setAccessible(true);
        if (this.canProcess(field)) {
            this.fields.add(field);
            return this.processFieldBuilders(field) || this.processPathParam(field) || this.processRequestParam(field);
        }
        return false;
    }

    private void iterateMethods() {
        for (Class<?> currentClass = this.cl; currentClass != null; currentClass = currentClass.getSuperclass()) {
            for (Method method : currentClass.getDeclaredMethods()) {
                method.setAccessible(true);
                if (this.canProcess(method) && this.processMethodBuilders(method)) {
                    this.setProcessed(method);
                }
                if (this.canProcess(method) && this.processBeforeBuilds(method)) {
                    this.setProcessed(method);
                }
                if (this.canProcess(method) && this.processAfterBuilds(method)) {
                    this.setProcessed(method);
                }
                if (this.canProcess(method) && this.processPathParam(method)) {
                    this.setProcessed(method);
                }
                if (!this.canProcess(method) || !this.processRequestParam(method)) continue;
                this.setProcessed(method);
            }
        }
    }

    public static Class<?> getActualClass(Class<?> cl) {
        Class<?> actual = cl;
        while (actual.getSimpleName().contains("EnhancerByGuice")) {
            actual = actual.getSuperclass();
        }
        return actual;
    }

    private Buildable findBuildable() {
        for (Class<?> current = this.cl; current != null; current = current.getSuperclass()) {
            if (!current.isAnnotationPresent(Buildable.class)) continue;
            return current.getAnnotation(Buildable.class);
        }
        return null;
    }

    private String getBuildableName() {
        if (this.annotation.wrap()) {
            return "".equals(this.annotation.name()) ? this.cl.getSimpleName() : this.annotation.name();
        }
        return null;
    }

    private void addToBuilders(boolean onCreate, boolean onUpdate, Builder builder) {
        if (onCreate) {
            this.builders.add(builder);
        }
        if (onUpdate) {
            this.updateBuilders.add(builder);
        }
        this.partialBuilders.add(builder);
    }

    public boolean processBeforeBuilds(Method method) {
        if (method.getAnnotation(BeforeBuild.class) != null) {
            this.beforeBuilds.add(method);
            return true;
        }
        return false;
    }

    public boolean processAfterBuilds(Method method) {
        if (method.getAnnotation(AfterBuild.class) != null) {
            this.afterBuilds.add(method);
            return true;
        }
        return false;
    }

    public boolean processPathParam(Field field) {
        if (field.isAnnotationPresent(PathParam.class)) {
            if (!primitives.containsKey(field.getType())) {
                try {
                    field.getType().getConstructor(String.class);
                }
                catch (SecurityException e) {
                    throw new WebApplicationException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new WebApplicationException(field, "@PathParam-annotated field type does not contain constructor having String as parameter", (Throwable)e);
                }
            }
            this.pathParamFields.add(field);
            return true;
        }
        return false;
    }

    public boolean processRequestParam(Field field) {
        if (field.isAnnotationPresent(RequestParam.class)) {
            if (!primitives.containsKey(field.getType())) {
                try {
                    field.getType().getConstructor(String.class);
                }
                catch (SecurityException e) {
                    throw new WebApplicationException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new WebApplicationException(field, "@RequestParam-annotated field type does not contain constructor having String as parameter", (Throwable)e);
                }
            }
            this.requestParamFields.add(field);
            return true;
        }
        return false;
    }

    public boolean processPathParam(Method method) {
        if (method.isAnnotationPresent(PathParam.class)) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                throw new WebApplicationException(method, "@PathParam annotated method does not take 1 parameter", null);
            }
            if (!primitives.containsKey(types[0])) {
                try {
                    types[0].getConstructor(String.class);
                }
                catch (SecurityException e) {
                    throw new WebApplicationException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new WebApplicationException(method, "@PathParam-annotated method parameter type does not contain constructor having String as parameter", (Throwable)e);
                }
            }
            this.pathParamMethods.add(method);
            return true;
        }
        return false;
    }

    public boolean processRequestParam(Method method) {
        if (method.isAnnotationPresent(RequestParam.class)) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                throw new WebApplicationException(method, "@RequestParam annotated method does not take 1 parameter", null);
            }
            if (!primitives.containsKey(types[0])) {
                try {
                    types[0].getConstructor(String.class);
                }
                catch (SecurityException e) {
                    throw new WebApplicationException(e);
                }
                catch (NoSuchMethodException e) {
                    throw new WebApplicationException(method, "@RequestParam-annotated method parameter type does not contain constructor having String as parameter", (Throwable)e);
                }
            }
            this.requestParamMethods.add(method);
            return true;
        }
        return false;
    }

    public void applyBeforeBuilds(Object obj) {
        for (Method method : this.beforeBuilds) {
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException(e);
            }
            catch (IllegalAccessException e) {
                throw new WebApplicationException(e);
            }
            catch (InvocationTargetException e) {
                throw new WebApplicationException(e);
            }
        }
    }

    public void applyAfterBuilds(Object obj) {
        for (Method method : this.afterBuilds) {
            try {
                method.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException(e);
            }
            catch (IllegalAccessException e) {
                throw new WebApplicationException(e);
            }
            catch (InvocationTargetException e) {
                throw new WebApplicationException(e);
            }
        }
    }

    public void applyRequestParams(Object obj, HttpServletRequest request) {
        String name;
        RequestParam annotation;
        for (Field field : this.requestParamFields) {
            annotation = field.getAnnotation(RequestParam.class);
            name = "".equals(annotation.name()) ? field.getName() : annotation.name();
            try {
                field.set(obj, this.getValue(annotation, field.getType(), name, request));
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    throw (RuntimeException)e;
                }
                throw new WebApplicationException(e);
            }
        }
        for (Method method : this.requestParamMethods) {
            annotation = method.getAnnotation(RequestParam.class);
            name = "".equals(annotation.name()) ? method.getName() : annotation.name();
            try {
                method.invoke(obj, this.getValue(annotation, method.getParameterTypes()[0], name, request));
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    throw (RuntimeException)e;
                }
                throw new WebApplicationException(e);
            }
        }
    }

    public void applyPathParams(Object obj, UriMapping mapping, String uri) {
        String name;
        PathParam annotation;
        for (Field field : this.pathParamFields) {
            annotation = field.getAnnotation(PathParam.class);
            name = "".equals(annotation.name()) ? field.getName() : annotation.name();
            try {
                field.set(obj, this.getValue(annotation, field.getType(), name, mapping, uri));
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    throw (RuntimeException)e;
                }
                throw new WebApplicationException(e);
            }
        }
        for (Method method : this.pathParamMethods) {
            annotation = method.getAnnotation(PathParam.class);
            name = "".equals(annotation.name()) ? method.getName() : annotation.name();
            try {
                method.invoke(obj, this.getValue(annotation, method.getParameterTypes()[0], name, mapping, uri));
            }
            catch (Exception e) {
                if (e instanceof WebApplicationException) {
                    throw (RuntimeException)e;
                }
                throw new WebApplicationException(e);
            }
        }
    }

    private Object getValue(RequestParam annotation, Class<?> type, String name, HttpServletRequest request) {
        String val = request.getParameter(name);
        if (val == null) {
            switch (annotation.onNull()) {
                case SET_TO_NULL: {
                    return null;
                }
                case RETHROW_CAUSE: {
                    throw new WebApplicationException(this.cl, "Null value for request param: " + name, null);
                }
                case SEND_NOT_FOUND_ERROR: 
                case SEND_BAD_REQUEST_ERROR: {
                    throw new MetaComponentException(annotation.onNull());
                }
            }
        }
        String rv = null;
        if (String.class == type) {
            rv = val;
        } else {
            try {
                rv = primitives.containsKey(type) ? primitives.get(type).getConstructor(String.class).newInstance(val) : type.getConstructor(String.class).newInstance(val);
            }
            catch (Exception e) {
                switch (annotation.onError()) {
                    case SET_TO_NULL: {
                        return null;
                    }
                    case RETHROW_CAUSE: {
                        throw new WebApplicationException(e);
                    }
                    case SEND_NOT_FOUND_ERROR: 
                    case SEND_BAD_REQUEST_ERROR: {
                        throw new MetaComponentException(annotation.onError());
                    }
                }
            }
        }
        return rv;
    }

    private Object getValue(PathParam annotation, Class<?> type, String name, UriMapping mapping, String uri) {
        String val = mapping.findValue(uri, name);
        if (val == null) {
            switch (annotation.onNull()) {
                case SET_TO_NULL: {
                    return null;
                }
                case RETHROW_CAUSE: {
                    throw new WebApplicationException(this.cl, "Null value for path param: " + name, null);
                }
                case SEND_NOT_FOUND_ERROR: 
                case SEND_BAD_REQUEST_ERROR: {
                    throw new MetaComponentException(annotation.onNull());
                }
            }
        }
        String rv = null;
        if (String.class == type) {
            rv = val;
        } else {
            try {
                rv = primitives.containsKey(type) ? primitives.get(type).getConstructor(String.class).newInstance(val) : type.getConstructor(String.class).newInstance(val);
            }
            catch (Exception e) {
                switch (annotation.onError()) {
                    case SET_TO_NULL: {
                        return null;
                    }
                    case RETHROW_CAUSE: {
                        throw new WebApplicationException(e);
                    }
                    case SEND_NOT_FOUND_ERROR: 
                    case SEND_BAD_REQUEST_ERROR: {
                        throw new MetaComponentException(annotation.onError());
                    }
                }
            }
        }
        return rv;
    }

    public void registerChildren(Component parent) {
        for (Field field : this.autoregisterFields) {
            try {
                Object child = field.get(parent);
                if (!(child instanceof Component)) continue;
                parent.registerChild((Component)child);
            }
            catch (IllegalArgumentException e) {
                throw new WebApplicationException(e);
            }
            catch (IllegalAccessException e) {
                throw new WebApplicationException(e);
            }
        }
    }

    static {
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
    }
}

