/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal.component;

import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.component.DOMBuilder;
import net.contextfw.web.application.component.ScriptContext;
import net.contextfw.web.application.internal.component.Builder;
import net.contextfw.web.application.internal.component.ComponentBuilder;
import net.contextfw.web.application.internal.component.MetaComponent;
import net.contextfw.web.application.internal.util.AttributeHandler;

@Singleton
public class ComponentBuilderImpl
implements ComponentBuilder,
ScriptContext {
    private static final Map<Class<?>, MetaComponent> metaModels = new HashMap();
    private static final Map<Class<?>, Class<?>> actualClasses = new WeakHashMap();
    private final AttributeHandler attributeHandler;
    private final Gson gson;

    @Inject
    public ComponentBuilderImpl(AttributeHandler attributeHandler, Gson gson) {
        this.attributeHandler = attributeHandler;
        this.gson = gson;
    }

    @Override
    public MetaComponent getMetaComponent(Class<?> cl) {
        MetaComponent model;
        Class<?> actual = actualClasses.get(cl);
        if (actual == null) {
            actual = ComponentBuilderImpl.getActualClass(cl);
            actualClasses.put(cl, actual);
        }
        if ((model = metaModels.get(actual)) == null) {
            model = new MetaComponent(actual, this, this.gson, this);
            metaModels.put(actual, model);
        }
        return model;
    }

    public void clean() {
        metaModels.clear();
        actualClasses.clear();
    }

    public static Class<?> getActualClass(Object element) {
        return ComponentBuilderImpl.getActualClass(element.getClass());
    }

    public static Class<?> getActualClass(Class<?> cl) {
        Class<?> actual = actualClasses.get(cl);
        if (actual != null) {
            return actual;
        }
        actual = cl;
        while (actual.getSimpleName().contains("EnhancerByGuice")) {
            actual = actual.getSuperclass();
        }
        actualClasses.put(cl, actual);
        return actual;
    }

    @Override
    public String getBuildName(Class<?> cl) {
        MetaComponent model = this.getMetaComponent(cl);
        if (model.annotation != null) {
            return model.buildName;
        }
        throw new WebApplicationException(cl, "Class is not buildable", null);
    }

    @Override
    public void build(DOMBuilder sb, Object component, Object ... buildins) {
        MetaComponent model = this.getMetaComponent(component.getClass());
        if (model.annotation != null) {
            if (component instanceof Component && !((Component)component).isEnabled()) {
                return;
            }
            DOMBuilder b = model.buildName == null ? sb : sb.descend(model.buildName);
            this.build(model, b, component, model.builders, false, null, buildins);
        } else {
            sb.text(this.attributeHandler.serialize(component));
        }
    }

    private void build(MetaComponent model, DOMBuilder b, Object component, List<Builder> builders, boolean partial, Set<String> updates, Object ... buildins) {
        model.applyBeforeBuilds(component);
        if (partial) {
            for (Builder builder : builders) {
                if (!builder.isUpdateBuildable(updates)) continue;
                builder.build(b, component);
            }
        } else {
            for (Builder builder : builders) {
                builder.build(b, component);
            }
        }
        if (buildins != null) {
            for (Object buildIn : buildins) {
                if (buildIn == null) continue;
                MetaComponent bmodel = this.getMetaComponent(buildIn.getClass());
                if (bmodel.annotation == null) continue;
                for (Builder builder : bmodel.builders) {
                    builder.build(b, buildIn);
                }
            }
        }
        model.applyAfterBuilds(component);
    }

    @Override
    public void buildUpdate(DOMBuilder sb, Component component, String updateName) {
        MetaComponent model = this.getMetaComponent(component.getClass());
        if (model.annotation != null) {
            DOMBuilder b = sb.descend(model.buildName + "." + updateName);
            this.build(model, b, (Object)component, model.updateBuilders, false, null, (Object[])null);
        }
    }

    @Override
    public void buildPartialUpdate(DOMBuilder sb, Component component, String updateName, Set<String> updates) {
        MetaComponent model = this.getMetaComponent(component.getClass());
        if (model.annotation != null) {
            DOMBuilder b = sb.descend(model.buildName + "." + updateName);
            this.build(model, b, (Object)component, model.partialBuilders, true, updates, (Object[])null);
        }
    }

    @Override
    public boolean isBuildable(Class<?> cl) {
        return this.getMetaComponent(cl).annotation != null;
    }
}

