/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application.internal;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import net.contextfw.org.dom4j.io.XMLWriter;
import net.contextfw.web.application.DocumentProcessor;
import net.contextfw.web.application.WebApplicationException;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.development.XMLResponseLogger;
import net.contextfw.web.application.internal.InternalWebApplicationException;
import net.contextfw.web.application.internal.Transformers;
import net.contextfw.web.application.internal.configuration.KeyValue;
import net.contextfw.web.application.internal.util.ResourceEntry;
import net.contextfw.web.application.internal.util.ResourceScanner;
import net.contextfw.web.application.internal.util.Utils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WebResponder {
    private static final Pattern XSL_ACCEPTOR = Pattern.compile(".*\\.xsl", 2);
    private Logger logger = LoggerFactory.getLogger(WebResponder.class);
    private List<String> rootResourcePaths = new ArrayList<String>();
    private final List<String> resourcePaths = new ArrayList<String>();
    private final List<KeyValue<String, String>> namespaces = new ArrayList<KeyValue<String, String>>();
    private final Transformers transformers;
    private final XMLResponseLogger responseLogger;
    private final DocumentProcessor xslPostProcessor;
    private final OutputFormat htmlFormat;

    @Inject
    public WebResponder(Configuration configuration, Injector injector) {
        Object obj;
        this.rootResourcePaths.add("net.contextfw.web.application");
        this.transformers = new Transformers();
        this.resourcePaths.addAll((Collection)configuration.get(Configuration.RESOURCE_PATH));
        this.namespaces.addAll((Collection)configuration.get(Configuration.NAMESPACE));
        this.htmlFormat = OutputFormat.createCompactFormat();
        this.htmlFormat.setXHTML(true);
        this.htmlFormat.setTrimText(false);
        this.htmlFormat.setPadText(true);
        this.htmlFormat.setNewlines(false);
        this.htmlFormat.setExpandEmptyElements(true);
        this.xslPostProcessor = configuration.get(Configuration.XSL_POST_PROCESSOR) != null ? (DocumentProcessor)Utils.toInstance(configuration.get(Configuration.XSL_POST_PROCESSOR), injector) : null;
        this.responseLogger = configuration.get(Configuration.LOG_XML).booleanValue() ? ((obj = configuration.get(Configuration.XML_RESPONSE_LOGGER)) instanceof XMLResponseLogger ? (XMLResponseLogger)obj : (obj instanceof Class && XMLResponseLogger.class.isAssignableFrom((Class)obj) ? (XMLResponseLogger)injector.getInstance((Class)obj) : null)) : null;
    }

    public void logXML(Document d) {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            StringWriter xml = new StringWriter();
            XMLWriter writer = new XMLWriter(xml, format);
            writer.write(d);
            this.responseLogger.logXML(xml.toString());
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }

    protected Document getXSLDocument() {
        List<ResourceEntry> rootResources = ResourceScanner.findResources(this.rootResourcePaths, XSL_ACCEPTOR);
        ResourceEntry root = null;
        Iterator<ResourceEntry> iter = rootResources.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                ResourceEntry next = iter.next();
                if (!next.getPath().endsWith("root.xsl")) continue;
                iter.remove();
                root = next;
                break;
            }
        }
        if (root == null) {
            throw new InternalWebApplicationException("root.xsl was not found");
        }
        List<ResourceEntry> resources = ResourceScanner.findResources(this.resourcePaths, XSL_ACCEPTOR);
        SAXReader reader = new SAXReader();
        try {
            InputStream stream = root.getInputStream();
            Document document = reader.read(stream);
            stream.close();
            for (KeyValue<String, String> entry : this.namespaces) {
                document.getRootElement().addNamespace(entry.getKey(), entry.getValue());
            }
            Element stylesheet = (Element)document.selectSingleNode("//stylesheet");
            for (ResourceEntry file : resources) {
                if (!file.getPath().endsWith(".xsl")) continue;
                reader = new SAXReader();
                stream = file.getInputStream();
                try {
                    Document child = reader.read(stream);
                    for (Object el : child.getRootElement().elements()) {
                        if (!(el instanceof Node)) continue;
                        stylesheet.add(((Node)el).detach());
                    }
                }
                catch (DocumentException de) {
                    this.transformers.invalidate();
                    throw new WebApplicationException("Xsl-file " + file.getPath() + " contains errors", de);
                }
                finally {
                    stream.close();
                }
            }
            if (this.xslPostProcessor != null) {
                this.xslPostProcessor.process(document);
            }
            return document;
        }
        catch (DocumentException e) {
            throw new WebApplicationException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException(e);
        }
        catch (IOException e) {
            throw new WebApplicationException(e);
        }
    }

    public void sendResponse(Document document, HttpServletResponse resp, Mode mode) throws ServletException, IOException {
        if (this.responseLogger != null) {
            this.logXML(document);
        }
        if (mode != Mode.XML) {
            this.sendHTMLResponse(document, resp, mode);
        } else {
            this.sendXMLResponse(document, resp);
        }
    }

    private void sendXMLResponse(Document document, HttpServletResponse resp) throws IOException {
        resp.setContentType(Mode.XML.getContentType());
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-Control", "no-cache, no-store");
        OutputFormat format = OutputFormat.createPrettyPrint();
        new XMLWriter(resp.getWriter(), format).write(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHTMLResponse(Document document, HttpServletResponse resp, Mode mode) throws ServletException, IOException {
        resp.setContentType(mode.getContentType());
        resp.setHeader("Expires", "-1");
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-Control", "no-cache, no-store");
        if (!this.transformers.isInitialized()) {
            Transformers transformers = this.transformers;
            synchronized (transformers) {
                if (!this.transformers.isInitialized()) {
                    this.transformers.initialize(this.getXSLDocument());
                }
            }
        }
        Document rDocument = this.transformers.transform(document);
        if (mode == Mode.INIT) {
            rDocument.addDocType("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        }
        new HTMLWriter((Writer)resp.getWriter(), this.htmlFormat).write(rDocument);
    }

    public void clean() {
        this.logger.debug("Reloading resources");
        this.transformers.invalidate();
    }

    public static enum Mode {
        INIT("text/html;charset=UTF-8"),
        UPDATE("text/xml;charset=UTF-8"),
        XML("text/xml;charset=UTF-8");

        private final String contentType;

        private Mode(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

