/*
 * Decompiled with CFR 0.152.
 */
package net.contextfw.web.application;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import net.contextfw.web.application.PageContext;
import net.contextfw.web.application.PageHandle;
import net.contextfw.web.application.PropertyProvider;
import net.contextfw.web.application.component.Component;
import net.contextfw.web.application.component.ComponentRegister;
import net.contextfw.web.application.configuration.BindableProperty;
import net.contextfw.web.application.configuration.Configuration;
import net.contextfw.web.application.development.DevelopmentTools;
import net.contextfw.web.application.internal.WebApplicationServletModule;
import net.contextfw.web.application.internal.component.AutoRegisterListener;
import net.contextfw.web.application.internal.component.InternalComponentRegister;
import net.contextfw.web.application.internal.configuration.KeyValue;
import net.contextfw.web.application.internal.development.DevelopmentToolsImpl;
import net.contextfw.web.application.internal.development.InternalDevelopmentTools;
import net.contextfw.web.application.internal.page.PageScope;
import net.contextfw.web.application.internal.service.DirectoryWatcher;
import net.contextfw.web.application.internal.service.WebApplicationConf;
import net.contextfw.web.application.internal.util.AttributeHandler;
import net.contextfw.web.application.internal.util.ObjectAttributeSerializer;
import net.contextfw.web.application.lifecycle.LifecycleListener;
import net.contextfw.web.application.lifecycle.PageScoped;
import net.contextfw.web.application.lifecycle.RequestInvocationFilter;
import net.contextfw.web.application.scope.WebApplicationStorage;

public final class WebApplicationModule
extends AbstractModule {
    private final Configuration configuration;
    private AutoRegisterListener autoRegisterListener = new AutoRegisterListener();
    private DevelopmentToolsImpl developmentTools;

    public WebApplicationModule(Configuration configuration) {
        this.configuration = configuration;
    }

    private <T> void bind(Class<T> type, BindableProperty<T> property) {
        Object obj = this.configuration.get(property);
        if (obj instanceof Class) {
            this.bind(type).to((Class)obj);
        } else {
            this.bind(type).toInstance(obj);
            this.requestInjection(obj);
        }
    }

    protected void configure() {
        this.handleDevelopmentTools();
        this.bind(WebApplicationStorage.class, Configuration.WEB_APPLICATION_STORAGE);
        this.bind(LifecycleListener.class, Configuration.LIFECYCLE_LISTENER);
        PageScope pageScope = new PageScope();
        this.requestInjection(pageScope);
        this.bindScope(PageScoped.class, pageScope);
        this.bind(PageScope.class).toInstance((Object)pageScope);
        this.bind(PageContext.class).toProvider(pageScope.scope(Key.get(PageContext.class), null));
        this.bind(PageHandle.class).toProvider(pageScope.scope(Key.get(PageHandle.class), null));
        this.bind(ObjectAttributeSerializer.class).to(AttributeHandler.class);
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(ComponentRegister.class).to(InternalComponentRegister.class);
        this.bind(PropertyProvider.class).toInstance((Object)this.configuration.get(Configuration.PROPERTY_PROVIDER));
        this.bind(RequestInvocationFilter.class).toInstance((Object)this.configuration.get(Configuration.REQUEST_INVOCATION_FILTER));
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                if (Component.class.isAssignableFrom(typeLiteral.getRawType())) {
                    typeEncounter.register((InjectionListener)WebApplicationModule.this.autoRegisterListener);
                }
            }
        });
        this.requestInjection((Object)this);
        this.requestInjection(this.autoRegisterListener);
        WebApplicationServletModule servletModule = new WebApplicationServletModule(this.configuration, this.configuration.get(Configuration.PROPERTY_PROVIDER), pageScope, this.developmentTools);
        this.install((Module)servletModule);
    }

    @Singleton
    @Provides
    public Gson provideGson(Injector injector) {
        GsonBuilder builder = new GsonBuilder();
        for (KeyValue entry : (Set)this.configuration.get(Configuration.JSON_SERIALIZER)) {
            builder.registerTypeAdapter((Type)entry.getKey(), injector.getInstance((Class)entry.getValue()));
        }
        for (KeyValue entry : (Set)this.configuration.get(Configuration.JSON_DESERIALIZER)) {
            builder.registerTypeAdapter((Type)entry.getKey(), injector.getInstance((Class)entry.getValue()));
        }
        for (KeyValue entry : (Set)this.configuration.get(Configuration.ATTRIBUTE_JSON_SERIALIZER)) {
            builder.registerTypeAdapter((Type)entry.getKey(), injector.getInstance((Class)entry.getValue()));
        }
        return builder.create();
    }

    @Provides
    @Singleton
    public DirectoryWatcher resourceDirectoryWatcher() {
        ArrayList<String> paths = null;
        if (this.configuration.get(Configuration.DEVELOPMENT_MODE).booleanValue()) {
            paths = new ArrayList<String>();
            paths.addAll((Collection)this.configuration.get(Configuration.RESOURCE_PATH));
        }
        Pattern matcher = Pattern.compile(".+\\.(xsl|css|js|properties)", 2);
        if (!this.configuration.get(Configuration.CLASS_RELOADING_ENABLED).booleanValue()) {
            matcher = Pattern.compile(".+\\.(xsl|css|js|class|properties)", 2);
        }
        return new DirectoryWatcher(paths, matcher);
    }

    @Provides
    @Singleton
    public WebApplicationConf provideWebApplicationConf() {
        return new WebApplicationConf(this.configuration.get(Configuration.DEVELOPMENT_MODE), this.configuration.get(Configuration.XML_PARAM_NAME), (Collection)this.configuration.get(Configuration.NAMESPACE));
    }

    private void handleDevelopmentTools() {
        this.developmentTools = new DevelopmentToolsImpl(this.configuration);
    }

    @Provides
    @Singleton
    public DevelopmentTools provideDevelopmentTools() {
        return this.developmentTools;
    }

    @Provides
    @Singleton
    public InternalDevelopmentTools provideInternalDevelopmentTools() {
        return this.developmentTools;
    }
}

