/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.group.ValueListHandler;
import org.jboss.xb.binding.group.ValueListInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;

public class ValueList {
    private final ValueListInitializer initializer;
    private final ValueListHandler handler;
    private final Class targetClass;
    private List nonRequiredValues = Collections.EMPTY_LIST;

    ValueList(ValueListInitializer initializer, ValueListHandler handler, Class targetClass) {
        this.initializer = initializer;
        this.handler = handler;
        this.targetClass = targetClass;
    }

    void setRequiredValue(int index, int stateIncrement, Object value) {
        throw new UnsupportedOperationException();
    }

    Object getRequiredValue(int index) {
        throw new UnsupportedOperationException();
    }

    int getState() {
        throw new UnsupportedOperationException();
    }

    void setAttributeValue(QName qName, AttributeBinding binding, Object value) {
        this.setNonRequiredValue(qName, binding, null, value);
    }

    void addTextValue(QName qName, ParticleBinding particle, CharactersHandler handler, Object value) {
        this.setNonRequiredValue(qName, particle, handler, value);
    }

    void addTermValue(QName qName, ParticleBinding binding, Object handler, Object value) {
        if (binding.isRepeatable()) {
            NonRequiredValue last = this.nonRequiredValues.isEmpty() ? null : this.nonRequiredValues.get(this.nonRequiredValues.size() - 1);
            if (last == null || last.binding != binding) {
                value = Collections.singletonList(value);
                this.setNonRequiredValue(qName, binding, handler, value);
            } else {
                ArrayList<List<Object>> list = (ArrayList<List<Object>>)last.value;
                if (list.size() == 1) {
                    last.value = list = new ArrayList<List<Object>>(list);
                }
                list.add(value);
            }
        } else {
            this.setNonRequiredValue(qName, binding, handler, value);
        }
    }

    void setNonRequiredValue(QName qName, Object binding, Object handler, Object value) {
        NonRequiredValue val = new NonRequiredValue(qName, binding, handler, value);
        switch (this.nonRequiredValues.size()) {
            case 0: {
                this.nonRequiredValues = Collections.singletonList(val);
                break;
            }
            case 1: {
                this.nonRequiredValues = new ArrayList(this.nonRequiredValues);
            }
            default: {
                this.nonRequiredValues.add(val);
            }
        }
    }

    Object getNonRequiredValue(QName qName) {
        throw new UnsupportedOperationException();
    }

    public ValueListInitializer getInitializer() {
        return this.initializer;
    }

    public List getRequiredValues() {
        throw new UnsupportedOperationException();
    }

    public Map getNonRequiredValues() {
        throw new UnsupportedOperationException();
    }

    public List getNonRequiredBindings() {
        throw new UnsupportedOperationException();
    }

    public ValueListHandler getHandler() {
        return this.handler;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public NonRequiredValue getValue(int i) {
        return (NonRequiredValue)this.nonRequiredValues.get(i);
    }

    public int size() {
        return this.nonRequiredValues.size();
    }

    public static final class NonRequiredValue {
        public final QName qName;
        public final Object binding;
        public final Object handler;
        public Object value;

        public NonRequiredValue(QName qName, Object binding, Object handler, Object value) {
            this.qName = qName;
            this.binding = binding;
            this.handler = handler;
            this.value = value;
        }
    }
}

