/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jboss.vfs.file.JarImpl;
import org.jboss.vfs.spi.VirtualFile;
import org.jboss.vfs.spi.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedJarFromStream
implements VirtualFile {
    private ZipInputStream zis;
    private HashMap<String, JarEntryContents> entries = new HashMap();
    private URL jarURL;
    private URL entryURL;
    private String vfsPath;
    private String name;
    private long lastModified;
    private long size;
    private boolean inited;

    public NestedJarFromStream(ZipInputStream zis, URL jarURL, String jarVfsPath, ZipEntry entry) {
        this.jarURL = jarURL;
        this.name = entry.getName();
        this.vfsPath = jarVfsPath.length() > 0 ? jarVfsPath + "/" + this.name : this.name;
        this.lastModified = entry.getTime();
        this.size = entry.getSize();
        this.zis = zis;
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    public int size() {
        return this.entries.size();
    }

    public Iterator<JarEntryContents> getEntries() throws IOException {
        if (!this.inited) {
            this.init();
        }
        return this.entries.values().iterator();
    }

    public JarEntryContents getEntry(String name) throws IOException {
        if (!this.inited) {
            this.init();
        }
        JarEntryContents jec = this.entries.get(name);
        return jec;
    }

    public ZipEntry getJarEntry(String name) throws IOException {
        JarEntryContents jec;
        if (!this.inited) {
            this.init();
        }
        ZipEntry entry = (jec = this.entries.get(name)) != null ? jec.getEntry() : null;
        return entry;
    }

    public byte[] getContents(String name) throws IOException {
        JarEntryContents jec;
        if (!this.inited) {
            this.init();
        }
        byte[] contents = (jec = this.entries.get(name)) != null ? jec.getContents() : null;
        return contents;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPathName() {
        return this.vfsPath;
    }

    @Override
    public VirtualFile[] getChildren() throws IOException {
        if (!this.inited) {
            this.init();
        }
        VirtualFile[] children = new VirtualFile[this.entries.size()];
        this.entries.values().toArray(children);
        return children;
    }

    @Override
    public List<VirtualFile> getChildrenRecursively() throws IOException {
        ArrayList<VirtualFile> rtn = new ArrayList<VirtualFile>();
        for (VirtualFile vf : this.getChildren()) {
            rtn.add(vf);
        }
        return null;
    }

    @Override
    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
        for (VirtualFile vf : this.getChildrenRecursively()) {
            if (!filter.accepts(vf)) continue;
            filtered.add(vf);
        }
        return filtered;
    }

    @Override
    public VirtualFile findChild(String name) throws IOException {
        if (!this.inited) {
            this.init();
        }
        VirtualFile child = this.entries.get(name);
        return child;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.zis;
    }

    @Override
    public void close() throws IOException {
        this.entries.clear();
        if (this.zis != null) {
            this.zis.close();
        }
    }

    @Override
    public URL toURL() throws MalformedURLException {
        if (this.entryURL == null) {
            this.entryURL = new URL(this.jarURL, this.getName());
        }
        return this.entryURL;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(super.toString());
        tmp.append('[');
        tmp.append("name=");
        tmp.append(this.getName());
        tmp.append(",size=");
        tmp.append(this.getSize());
        tmp.append(",lastModified=");
        tmp.append(this.getLastModified());
        tmp.append(",URL=");
        try {
            tmp.append(this.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        tmp.append(']');
        return tmp.toString();
    }

    protected void init() throws IOException {
        this.inited = true;
        ZipEntry entry = this.zis.getNextEntry();
        while (entry != null) {
            try {
                String url = this.toURL().toExternalForm() + "!/" + entry.getName();
                URL jecURL = new URL(url);
                JarEntryContents jec = new JarEntryContents(entry, jecURL, this.zis, this.getPathName());
                this.entries.put(entry.getName(), jec);
                entry = this.zis.getNextEntry();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.zis.close();
        this.zis = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JarEntryContents
    implements VirtualFile {
        private ZipEntry entry;
        private URL entryURL;
        private String vfsPath;
        private byte[] contents;
        private boolean isJar;
        private NestedJarFromStream njar;
        private InputStream openStream;

        JarEntryContents(ZipEntry entry, URL entryURL, InputStream zis, String parentVfsPath) throws IOException {
            this.entry = entry;
            this.entryURL = entryURL;
            this.vfsPath = parentVfsPath + "/" + entry.getName();
            this.isJar = JarImpl.isJar(entry.getName());
            int size = (int)entry.getSize();
            if (size <= 0) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
            byte[] tmp = new byte[1024];
            while (zis.available() > 0) {
                int length = zis.read(tmp);
                if (length <= 0) continue;
                baos.write(tmp, 0, length);
            }
            this.contents = baos.toByteArray();
        }

        @Override
        public boolean isArchive() {
            return this.isJar;
        }

        public ZipEntry getEntry() {
            return this.entry;
        }

        public byte[] getContents() {
            return this.contents;
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public String getPathName() {
            return this.vfsPath;
        }

        @Override
        public VirtualFile[] getChildren() throws IOException {
            VirtualFile[] children = new VirtualFile[]{};
            if (this.isJar) {
                this.initNestedJar();
                children = this.njar.getChildren();
            }
            return children;
        }

        @Override
        public List<VirtualFile> getChildrenRecursively() throws IOException {
            ArrayList<VirtualFile> rtn = new ArrayList<VirtualFile>();
            for (VirtualFile vf : this.getChildren()) {
                rtn.add(vf);
            }
            return null;
        }

        @Override
        public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
            ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
            for (VirtualFile vf : this.getChildrenRecursively()) {
                if (!filter.accepts(vf)) continue;
                filtered.add(vf);
            }
            return filtered;
        }

        @Override
        public VirtualFile findChild(String name) throws IOException {
            VirtualFile child = null;
            if (!this.isJar) {
                throw new FileNotFoundException("JarEntryContents(" + this.entry.getName() + ") has no children");
            }
            this.initNestedJar();
            child = this.njar.findChild(name);
            return child;
        }

        @Override
        public long getLastModified() {
            return this.entry.getTime();
        }

        @Override
        public long getSize() {
            return this.entry.getSize();
        }

        @Override
        public boolean isDirectory() {
            return this.isJar;
        }

        @Override
        public boolean isFile() {
            return !this.isJar;
        }

        @Override
        public synchronized InputStream openStream() throws IOException {
            this.initNestedJar();
            this.openStream = this.njar != null ? this.njar.openStream() : new ByteArrayInputStream(this.contents);
            return this.openStream;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.openStream != null) {
                this.openStream.close();
                this.openStream = null;
            }
        }

        @Override
        public URL toURL() throws MalformedURLException {
            return this.entryURL;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append('[');
            tmp.append("name=");
            tmp.append(this.entry.getName());
            tmp.append(",size=");
            tmp.append(this.entry.getSize());
            tmp.append(",time=");
            tmp.append(this.entry.getTime());
            tmp.append(",URL=");
            try {
                tmp.append(this.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            tmp.append(']');
            return tmp.toString();
        }

        private synchronized void initNestedJar() throws IOException {
            if (this.isJar && this.njar == null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.contents);
                ZipInputStream zis = new ZipInputStream(bais);
                this.njar = new NestedJarFromStream(zis, this.entryURL, this.getPathName(), this.entry);
            }
        }
    }
}

