/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipInputStream;
import org.jboss.vfs.file.JarFileEntry;
import org.jboss.vfs.file.NestedJarFromStream;
import org.jboss.vfs.spi.VirtualFile;
import org.jboss.vfs.spi.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarImpl
implements VirtualFile {
    private static Set<String> jarSuffixes = new CopyOnWriteArraySet<String>();
    private JarFile jar;
    private File file;
    private String vfsPath;

    public static boolean addJarSuffix(String suffix) {
        boolean added = jarSuffixes.add(suffix);
        return added;
    }

    public static boolean removeJarSuffix(String suffix) {
        boolean removed = jarSuffixes.remove(suffix);
        return removed;
    }

    public static boolean isJar(String name) {
        int lastDot = name.lastIndexOf(46);
        String suffix = name;
        if (lastDot >= 0) {
            suffix = name.substring(lastDot);
        }
        return jarSuffixes.contains(suffix);
    }

    public JarImpl(String path, String vfsPath) throws IOException {
        this.file = new File(path);
        this.vfsPath = vfsPath;
        try {
            this.jar = new JarFile(this.file);
        }
        catch (IOException e) {
            IOException ioe = new IOException("Error on jar: " + path);
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPathName() {
        return this.vfsPath;
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public VirtualFile[] getChildren() throws IOException {
        Enumeration<JarEntry> entries = this.jar.entries();
        ArrayList<VirtualFile> tmp = new ArrayList<VirtualFile>();
        URL jarURL = this.toURL();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (JarImpl.isJar(entry.getName())) {
                InputStream is = this.jar.getInputStream(entry);
                ZipInputStream jis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
                tmp.add(new NestedJarFromStream(jis, jarURL, this.vfsPath, entry));
                continue;
            }
            tmp.add(new JarFileEntry(jarURL, this.vfsPath, entry, this.jar));
        }
        VirtualFile[] children = new VirtualFile[tmp.size()];
        tmp.toArray(children);
        return children;
    }

    @Override
    public List<VirtualFile> getChildrenRecursively() throws IOException {
        ArrayList<VirtualFile> rtn = new ArrayList<VirtualFile>();
        for (VirtualFile vf : this.getChildren()) {
            rtn.add(vf);
        }
        return rtn;
    }

    @Override
    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
        for (VirtualFile vf : this.getChildrenRecursively()) {
            if (!filter.accepts(vf)) continue;
            filtered.add(vf);
        }
        return filtered;
    }

    @Override
    public VirtualFile findChild(String name) throws IOException {
        VirtualFile child = null;
        JarEntry entry = this.jar.getJarEntry(name);
        if (entry != null) {
            URL jarURL = this.toURL();
            if (JarImpl.isJar(entry.getName())) {
                InputStream is = this.jar.getInputStream(entry);
                ZipInputStream jis = is instanceof ZipInputStream ? (ZipInputStream)is : new ZipInputStream(is);
                child = new NestedJarFromStream(jis, jarURL, this.vfsPath, entry);
            } else {
                child = new JarFileEntry(jarURL, this.vfsPath, entry, this.jar);
            }
        }
        return child;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public InputStream openStream() throws IOException {
        return null;
    }

    @Override
    public void close() throws IOException {
        this.jar.close();
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.file.toURL();
    }

    static {
        jarSuffixes.add(".ear");
        jarSuffixes.add(".jar");
        jarSuffixes.add(".rar");
        jarSuffixes.add(".war");
    }
}

