/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.vfs.file.FileSystemVFS;
import org.jboss.vfs.file.JarImpl;
import org.jboss.vfs.spi.VirtualFile;
import org.jboss.vfs.spi.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileImpl
implements VirtualFile,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("rootURL", URL.class), new ObjectStreamField("path", URL.class), new ObjectStreamField("vfsPath", String.class)};
    private URL path;
    private String vfsPath;
    private transient FileSystemVFS vfs;
    private transient File file;
    private transient VirtualFile[] children;
    private transient List<VirtualFile> recursiveChildren;
    private transient InputStream contentIS;

    public FileImpl(URL path, String vfsPath, FileSystemVFS vfs) throws IOException {
        this.path = path;
        this.vfsPath = vfsPath;
        this.file = new File(path.getPath());
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.getCanonicalPath());
        }
        if (this.file.isDirectory() && !vfsPath.endsWith("/")) {
            this.vfsPath = this.vfsPath + '/';
            this.path = new URL(vfs.getRootURL(), this.vfsPath);
        }
        this.vfs = vfs;
    }

    public FileImpl(File file, String vfsPath, FileSystemVFS vfs) throws IOException {
        this.path = file.toURL();
        this.vfsPath = vfsPath;
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException(file.getCanonicalPath());
        }
        this.vfs = vfs;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPathName() {
        return this.vfsPath;
    }

    @Override
    public VirtualFile[] getChildren() throws IOException {
        if (this.isDirectory() && this.children == null) {
            File[] listing = this.file.listFiles();
            ArrayList<VirtualFile> tmp = new ArrayList<VirtualFile>();
            for (File f : listing) {
                VirtualFile child = this.getChild(f.getName());
                tmp.add(child);
            }
            this.children = new VirtualFile[tmp.size()];
            tmp.toArray(this.children);
        }
        return this.children;
    }

    @Override
    public List<VirtualFile> getChildrenRecursively() throws IOException {
        if (this.isDirectory() && this.recursiveChildren == null) {
            this.recursiveChildren = new ArrayList<VirtualFile>();
            this.getChildren();
            if (this.children != null && this.children.length > 0) {
                for (VirtualFile vf : this.children) {
                    this.recursiveChildren.add(vf);
                    if (!vf.isDirectory() || vf.isArchive()) continue;
                    this.recursiveChildren.addAll(vf.getChildrenRecursively());
                }
            }
        }
        return this.recursiveChildren;
    }

    @Override
    public List<VirtualFile> getChildrenRecursively(VirtualFileFilter filter) throws IOException {
        this.getChildrenRecursively();
        ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>();
        for (VirtualFile vf : this.recursiveChildren) {
            if (!filter.accepts(vf)) continue;
            filtered.add(vf);
        }
        return filtered;
    }

    @Override
    public VirtualFile findChild(String name) throws IOException {
        VirtualFile child = this.getChild(name);
        if (child == null) {
            String path = this.file.getAbsolutePath();
            throw new FileNotFoundException(name + ", not found under: " + path);
        }
        return child;
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isArchive() {
        return this.file.isDirectory() && JarImpl.isJar(this.getName());
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.contentIS == null) {
            this.contentIS = this.path.openStream();
        }
        return this.contentIS;
    }

    @Override
    public void close() throws IOException {
        if (this.contentIS != null) {
            this.contentIS.close();
        }
    }

    @Override
    public URL toURL() {
        return this.path;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append('[');
        tmp.append("path=");
        tmp.append(this.path);
        tmp.append(",vfsPath=");
        tmp.append(this.vfsPath);
        tmp.append(",isFile=");
        tmp.append(this.isFile());
        tmp.append(",isDirectory=");
        tmp.append(this.isDirectory());
        tmp.append(",isArchive=");
        tmp.append(this.isArchive());
        tmp.append(']');
        return tmp.toString();
    }

    private VirtualFile getChild(String name) throws IOException {
        VirtualFile child = this.vfs.getChild(this.path, name);
        return child;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("rootURL", this.vfs.getRootURL());
        fields.put("path", this.path);
        fields.put("vfsPath", this.vfsPath);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        URL rootURL = (URL)fields.get("rootURL", null);
        this.path = (URL)fields.get("path", null);
        this.vfsPath = (String)fields.get("vfsPath", null);
        this.file = new File(this.path.getPath());
        this.vfs = FileSystemVFS.getFileSystemVFS(rootURL);
    }
}

