/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.tm.recovery.BatchLog;
import org.jboss.tm.recovery.HexDump;
import org.jboss.tm.recovery.LogRecord;
import org.jboss.tm.recovery.LogRestarter;
import org.jboss.tm.recovery.PendingWriteRequest;
import org.jboss.tm.recovery.TransactionCompletionLogger;
import org.jboss.tm.recovery.TxCompletionHandler;

class BatchWriter
implements Runnable {
    private static Logger errorLog = Logger.getLogger(BatchWriter.class);
    private static boolean traceEnabled = errorLog.isTraceEnabled();
    private final File dir;
    private final int initialCapacity;
    private BatchLog log;
    private final int fileSize;
    private Object header;
    private Exception abort;
    private boolean running = true;
    private final List nextLogs = Collections.synchronizedList(new ArrayList());
    private Object batchLock = new Object();
    private ArrayList currentQueue;
    private Latch currentLatch;
    private LogRestarter logRestarter;

    BatchWriter(Object header, int initialCapacity, File dir, int fileSize, LogRestarter logRestarter) throws IOException {
        this.header = header;
        this.fileSize = fileSize;
        this.initialCapacity = initialCapacity;
        this.currentQueue = new ArrayList(initialCapacity);
        this.currentLatch = new Latch();
        this.dir = dir;
        this.logRestarter = logRestarter;
        this.log = new BatchLog(this, header, dir, fileSize);
        this.nextLogs.add(new BatchLog(this, header, dir, fileSize));
    }

    void restartBatchLog(BatchLog logToRestart) {
        this.logRestarter.add(logToRestart);
    }

    List getNextLogs() {
        return this.nextLogs;
    }

    void clearAbort() {
        this.abort = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.batchLock;
        synchronized (object) {
            this.running = false;
            this.batchLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TxCompletionHandler addBatch(ByteBuffer buffer, boolean expectEndRecord) {
        PendingWriteRequest request = null;
        if (traceEnabled) {
            errorLog.trace("Transaction log record:" + HexDump.fromBuffer(buffer.array()));
            errorLog.trace(LogRecord.toString(buffer));
        }
        Object object = this.batchLock;
        synchronized (object) {
            request = new PendingWriteRequest(buffer, this.currentLatch, expectEndRecord);
            this.currentQueue.add(request);
            this.batchLock.notify();
        }
        TxCompletionHandler completionHandler = request.waitTilDone();
        if (!expectEndRecord) {
            return completionHandler;
        }
        return new TransactionCompletionLogger((BatchLog)completionHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBatch(ByteBuffer buffer, BatchLog destinationLog) {
        PendingWriteRequest receipt = null;
        if (traceEnabled) {
            errorLog.trace("Transaction Log record:" + HexDump.fromBuffer(buffer.array()));
            errorLog.trace(LogRecord.toString(buffer));
        }
        Object object = this.batchLock;
        synchronized (object) {
            receipt = new PendingWriteRequest(buffer, this.currentLatch, destinationLog);
            this.currentQueue.add(receipt);
            this.batchLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList work = null;
        Latch workLatch = null;
        while (this.running) {
            Object object = this.batchLock;
            synchronized (object) {
                if (this.currentQueue.size() > 0) {
                    if (work == null) {
                        work = new ArrayList(this.initialCapacity);
                    }
                } else {
                    try {
                        this.batchLock.wait();
                    }
                    catch (InterruptedException ignored) {
                        if (!this.running) {
                            break;
                        }
                        Thread.interrupted();
                    }
                    continue;
                }
                ArrayList tmp = work;
                work = this.currentQueue;
                this.currentQueue = tmp;
                workLatch = this.currentLatch;
                this.currentLatch = new Latch();
            }
            try {
                this.doWork(work);
            }
            catch (Exception e) {
                break;
            }
            finally {
                workLatch.release();
                work.clear();
            }
        }
        this.cleanup();
    }

    private void doWork(ArrayList work) {
        block11: {
            if (this.abort != null) {
                for (int i = 0; i < work.size(); ++i) {
                    PendingWriteRequest request = (PendingWriteRequest)work.get(i);
                    request.setFailure(this.abort);
                }
                return;
            }
            ByteBuffer[] records = new ByteBuffer[work.size()];
            int offset = 0;
            try {
                int length = records.length;
                int usedSize = this.log.getPosition();
                boolean done = false;
                while (!done) {
                    int j;
                    int numTransactions = 0;
                    for (int i = j = offset; i < length; ++i) {
                        PendingWriteRequest request = (PendingWriteRequest)work.get(i);
                        int type = request.getType();
                        records[j] = request.getBuffer();
                        if (type != -1) {
                            usedSize += records[j].remaining();
                            if (type == 1) {
                                usedSize += LogRecord.TX_END_LEN;
                            }
                            if (usedSize > this.fileSize) {
                                length = i;
                                continue;
                            }
                            ++numTransactions;
                            ++j;
                            continue;
                        }
                        BatchLog requestedLog = request.getLogger();
                        if (requestedLog != this.log) {
                            requestedLog.write(records[j], true);
                            continue;
                        }
                        ++j;
                    }
                    done = length == records.length;
                    this.log.write(records, offset, j - offset, numTransactions);
                    this.setCompletionHandler(offset, length -= offset, work);
                    if (done) continue;
                    this.restart();
                    offset += length;
                    length = records.length;
                    usedSize = this.log.getPosition();
                }
            }
            catch (IOException failure) {
                for (int i = offset; i < records.length - offset; ++i) {
                    PendingWriteRequest request = (PendingWriteRequest)work.get(i);
                    request.setFailure(failure);
                }
                if (this.abort != null) break block11;
                this.restart();
            }
        }
    }

    private void setCompletionHandler(int offset, int length, ArrayList work) {
        for (int i = offset; i < length; ++i) {
            PendingWriteRequest request = (PendingWriteRequest)work.get(i);
            if (request.getType() == -1) continue;
            request.setCompletionHandler(this.log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        List list = this.nextLogs;
        synchronized (list) {
            for (int i = 0; i < this.nextLogs.size(); ++i) {
                BatchLog nextLog = (BatchLog)this.nextLogs.get(i);
                nextLog.close();
            }
        }
        this.log.close();
    }

    private void restart() {
        this.log.markForRestart();
        if (this.nextLogs.size() > 0) {
            this.log = (BatchLog)this.nextLogs.remove(0);
        } else {
            try {
                this.log = new BatchLog(this, this.header, this.dir, this.fileSize);
            }
            catch (IOException e) {
                this.abort = new Exception("FAILED TO RESTART RECOVERY LOG AFTER BEING FULL", e);
            }
        }
    }
}

