/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.lang.reflect.Proxy;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.CoordinatorFactory;
import org.jboss.tm.GlobalId;
import org.jboss.tm.JBossRollbackException;
import org.jboss.tm.LastResource;
import org.jboss.tm.LocalId;
import org.jboss.tm.OTSContextFactory;
import org.jboss.tm.ResourceFactory;
import org.jboss.tm.StringRemoteRefConverter;
import org.jboss.tm.TMUtil;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TxManager;
import org.jboss.tm.TxUtils;
import org.jboss.tm.XAExceptionFormatter;
import org.jboss.tm.XidFactoryBase;
import org.jboss.tm.XidFactoryImpl;
import org.jboss.tm.XidImpl;
import org.jboss.tm.integrity.TransactionIntegrity;
import org.jboss.tm.recovery.HeuristicStatus;
import org.jboss.tm.recovery.LogRecord;
import org.jboss.tm.recovery.RecoveryLogger;
import org.jboss.tm.recovery.RecoveryTestingException;
import org.jboss.tm.recovery.TxCompletionHandler;
import org.jboss.tm.recovery.XAResourceAccess;
import org.jboss.tm.recovery.XAWork;
import org.jboss.tm.remoting.interfaces.Coordinator;
import org.jboss.tm.remoting.interfaces.HeuristicHazardException;
import org.jboss.tm.remoting.interfaces.RecoveryCoordinator;
import org.jboss.tm.remoting.interfaces.Resource;
import org.jboss.tm.remoting.interfaces.TransactionAlreadyPreparedException;
import org.jboss.tm.remoting.interfaces.TransactionInactiveException;
import org.jboss.tm.remoting.interfaces.TransactionNotPreparedException;
import org.jboss.tm.remoting.interfaces.TxPropagationContext;
import org.jboss.tm.remoting.interfaces.Vote;
import org.jboss.util.timeout.Timeout;
import org.jboss.util.timeout.TimeoutFactory;
import org.jboss.util.timeout.TimeoutTarget;

public class TransactionImpl
implements Transaction,
TimeoutTarget {
    private static final int HEUR_NONE = 0;
    private static final int HEUR_UNKNOWN = 4;
    private static final int RS_NEW = 0;
    private static final int RS_ENLISTED = 1;
    private static final int RS_SUSPENDED = 2;
    private static final int RS_ENDED = 3;
    private static final int RS_VOTE_READONLY = 4;
    private static final int RS_VOTE_OK = 5;
    private static final int RS_FORGOT = 6;
    private static final int RS_COMMITTED = 7;
    private static final int RS_ROLLEDBACK = 8;
    private static final int RS_HEUR_OUTCOME = 8;
    private static final int RS_ERROR = 9;
    private boolean trace = log.isTraceEnabled();
    private XidImpl xid;
    private HashSet threads = new HashSet(1);
    private Map transactionLocalMap = Collections.synchronizedMap(new HashMap());
    private Throwable cause;
    private final boolean foreignTx;
    private Coordinator parentCoordinator = null;
    private Resource registeredResource = null;
    private RecoveryCoordinator recoveryCoordinator = null;
    private byte[] inboundBranchQualifier = null;
    private Synchronization[] sync = new Synchronization[3];
    private int syncAllocSize = 3;
    private int syncCount = 0;
    private ArrayList xaResources = new ArrayList(3);
    private ArrayList remoteResources = new ArrayList(3);
    private EnlistedXAResource lastResource;
    private boolean resourcesEnded = false;
    private long lastBranchId = 0L;
    private int status;
    private int heuristicCode = 0;
    private long start;
    private Timeout timeout;
    private long timeoutPeriod;
    private Thread locked = null;
    private int lockDepth = 0;
    private Work work;
    private boolean done = false;
    private TxPropagationContext dtmPropagationContext = null;
    private Object otsPropagationContext = null;
    private TxCompletionHandler completionHandler = null;
    private int xaResourcesToRetry = 0;
    private int remoteResourcesToRetry = 0;
    private Timeout preparedTimeout = null;
    private Timeout xaRetryTimeout = null;
    private List xaResourcesWithHeuristicDecisions = null;
    private List remoteResourcesWithHeuristicDecisions = null;
    private int committedResources = 0;
    private int rolledbackResources = 0;
    private boolean heuristicHazard = false;
    private static Logger log = Logger.getLogger(TransactionImpl.class);
    static XidFactoryBase xidFactory;
    static XAExceptionFormatter xaExceptionFormatter;
    static TimeoutFactory timeoutFactory;
    private static CoordinatorFactory dtmCoordinatorFactory;
    private static ResourceFactory dtmResourceFactory;
    private static ResourceFactory otsResourceFactory;
    private static OTSContextFactory otsContextFactory;
    private static boolean interpositionEnabled;
    private static StringRemoteRefConverter dtmStrRemoteRefConverter;
    private static StringRemoteRefConverter otsStrRemoteRefConverter;

    public static XidFactoryBase defaultXidFactory() {
        if (xidFactory == null) {
            XidFactoryImpl impl = new XidFactoryImpl();
            impl.start();
            xidFactory = impl;
        }
        return xidFactory;
    }

    static void setDTMCoordinatorFactory(CoordinatorFactory dtmCoordinatorFactory) {
        TransactionImpl.dtmCoordinatorFactory = dtmCoordinatorFactory;
    }

    static void setDTMResourceFactory(ResourceFactory dtmResourceFactory) {
        TransactionImpl.dtmResourceFactory = dtmResourceFactory;
    }

    static void setOTSResourceFactory(ResourceFactory otsResourceFactory) {
        TransactionImpl.otsResourceFactory = otsResourceFactory;
    }

    static void setOTSContextFactory(OTSContextFactory otsContextFactory) {
        TransactionImpl.otsContextFactory = otsContextFactory;
    }

    static void setInterpositionEnabled(boolean interpositionEnabled) {
        TransactionImpl.interpositionEnabled = interpositionEnabled;
    }

    static boolean getInterpositionEnabled() {
        return interpositionEnabled;
    }

    static void setDTMStrRemoteRefConverter(StringRemoteRefConverter dtmStrRemoteRefConverter) {
        TransactionImpl.dtmStrRemoteRefConverter = dtmStrRemoteRefConverter;
    }

    static void setOTSStrRemoteRefConverter(StringRemoteRefConverter otsStrRemoteRefConverter) {
        TransactionImpl.otsStrRemoteRefConverter = otsStrRemoteRefConverter;
    }

    static Resource stringToResource(String strResource) {
        if (strResource.startsWith("IOR:")) {
            if (otsStrRemoteRefConverter != null) {
                return otsStrRemoteRefConverter.stringToResource(strResource);
            }
            throw new IllegalArgumentException();
        }
        if (dtmStrRemoteRefConverter != null) {
            return dtmStrRemoteRefConverter.stringToResource(strResource);
        }
        throw new IllegalArgumentException();
    }

    static RecoveryCoordinator stringToRecoveryCoordinator(String strRecCoordinator) {
        if (strRecCoordinator.startsWith("IOR:")) {
            if (otsStrRemoteRefConverter != null) {
                return otsStrRemoteRefConverter.stringToRecoveryCoordinator(strRecCoordinator);
            }
            throw new IllegalArgumentException();
        }
        if (dtmStrRemoteRefConverter != null) {
            return dtmStrRemoteRefConverter.stringToRecoveryCoordinator(strRecCoordinator);
        }
        throw new IllegalArgumentException();
    }

    static String resourceToString(Resource res) {
        if (Proxy.isProxyClass(res.getClass())) {
            if (dtmStrRemoteRefConverter != null) {
                return dtmStrRemoteRefConverter.resourceToString(res);
            }
            throw new IllegalArgumentException();
        }
        if (otsStrRemoteRefConverter != null) {
            return otsStrRemoteRefConverter.resourceToString(res);
        }
        throw new IllegalArgumentException();
    }

    static String recoveryCoordinatorToString(RecoveryCoordinator recoveryCoord) {
        if (Proxy.isProxyClass(recoveryCoord.getClass())) {
            if (dtmStrRemoteRefConverter != null) {
                return dtmStrRemoteRefConverter.recoveryCoordinatorToString(recoveryCoord);
            }
            throw new IllegalArgumentException();
        }
        if (otsStrRemoteRefConverter != null) {
            return otsStrRemoteRefConverter.recoveryCoordinatorToString(recoveryCoord);
        }
        throw new IllegalArgumentException();
    }

    TransactionImpl(long timeout) {
        this.foreignTx = false;
        this.xid = xidFactory.newXid();
        this.status = 0;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout(this.start + timeout, this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace("Created new instance for tx=" + this.toString());
        }
    }

    TransactionImpl(GlobalId gid, Coordinator parentCoordinator, long timeout) {
        this.foreignTx = true;
        this.xid = xidFactory.newBranch(gid);
        this.parentCoordinator = parentCoordinator;
        this.status = 0;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout(this.start + timeout, this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace("Created new instance for tx=" + this.toString());
        }
    }

    TransactionImpl(GlobalId gid, byte[] inboundBranchQualifier, long timeout) {
        this.foreignTx = true;
        this.xid = xidFactory.newBranch(gid);
        this.inboundBranchQualifier = inboundBranchQualifier;
        this.status = 0;
        this.start = System.currentTimeMillis();
        this.timeout = TimeoutFactory.createTimeout(this.start + timeout, this);
        this.timeoutPeriod = timeout;
        if (this.trace) {
            log.trace("Created new instance for tx=" + this.toString());
        }
    }

    TransactionImpl(long localId, List preparedXAWorkList, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        this.foreignTx = false;
        this.xid = xidFactory.recreateXid(localId);
        this.status = 8;
        if (heurData != null) {
            this.heuristicCode = heurData.heuristicStatusCode;
            this.heuristicHazard = heurData.locallyDetectedHeuristicHazard;
        }
        this.completionHandler = completionHandler;
        Iterator it = preparedXAWorkList.iterator();
        while (it.hasNext()) {
            XAWork preparedXAWork = (XAWork)it.next();
            EnlistedXAResource r = new EnlistedXAResource(preparedXAWork);
            this.xaResources.add(r);
        }
        this.commitXAResourcesAfterTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionImpl(long localId, List preparedXAWorkList, String[] resources, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        this.foreignTx = false;
        this.xid = xidFactory.recreateXid(localId);
        this.status = 8;
        this.completionHandler = completionHandler;
        if (heurData != null) {
            this.heuristicCode = heurData.heuristicStatusCode;
            this.heuristicHazard = heurData.locallyDetectedHeuristicHazard;
        }
        Iterator it = preparedXAWorkList.iterator();
        while (it.hasNext()) {
            XAWork preparedXAWork = (XAWork)it.next();
            EnlistedXAResource r = new EnlistedXAResource(preparedXAWork);
            this.xaResources.add(r);
        }
        for (int i = 0; i < resources.length; ++i) {
            EnlistedRemoteResource r = new EnlistedRemoteResource(TransactionImpl.stringToResource(resources[i]), true);
            this.remoteResources.add(r);
        }
        this.lock();
        try {
            this.retryCommitRemoteResources();
        }
        finally {
            this.unlock();
        }
        if (preparedXAWorkList.size() > 0) {
            this.commitXAResourcesAfterTimeout();
        } else if (this.remoteResourcesToRetry == 0 && this.heuristicCode == 0) {
            this.lock();
            try {
                this.completeTransaction();
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TransactionImpl(long localId, int inboundFormatId, byte[] globalTransactionId, String recoveryCoord, List preparedXAWorkList, String[] resources, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        this.foreignTx = true;
        GlobalId globalId = new GlobalId(inboundFormatId, globalTransactionId);
        this.xid = xidFactory.recreateXid(localId, globalId);
        this.recoveryCoordinator = TransactionImpl.stringToRecoveryCoordinator(recoveryCoord);
        if (heurData == null) {
            this.status = 2;
        } else {
            this.status = heurData.transactionStatus;
            this.heuristicCode = heurData.heuristicStatusCode;
            this.heuristicHazard = heurData.locallyDetectedHeuristicHazard;
        }
        this.completionHandler = completionHandler;
        Iterator it = preparedXAWorkList.iterator();
        while (it.hasNext()) {
            XAWork preparedXAWork = (XAWork)it.next();
            EnlistedXAResource r = new EnlistedXAResource(preparedXAWork);
            this.xaResources.add(r);
        }
        for (int i = 0; i < resources.length; ++i) {
            EnlistedRemoteResource r = new EnlistedRemoteResource(TransactionImpl.stringToResource(resources[i]), true);
            this.remoteResources.add(r);
        }
        if (Proxy.isProxyClass(this.recoveryCoordinator.getClass())) {
            if (dtmResourceFactory != null) {
                this.registeredResource = dtmResourceFactory.createResource(localId);
            } else {
                log.warn("Error reconstructing TransactionImpl instance for tx=" + this.toString() + " -- DTM resource factory missing.");
            }
        } else if (otsResourceFactory != null) {
            this.registeredResource = otsResourceFactory.createResource(localId);
        } else {
            log.warn("Error reconstructing TransactionImpl instance for tx=" + this.toString() + " -- OTS resource factory missing.");
        }
        if (this.status == 2) {
            if (this.registeredResource != null) {
                this.createPreparedTimeout();
                if (this.trace) {
                    log.trace("Calling replayCompletion on the recovery coordinator, tx=" + this.toString());
                }
                try {
                    this.recoveryCoordinator.replayCompletion(this.registeredResource);
                    return;
                }
                catch (NoSuchObjectException noCoordinator) {
                    if (this.trace) {
                        log.trace("Exception in replayCompletion: no coordinator for tx=" + this.toString(), noCoordinator);
                        log.trace("Rolling back transaction branch, tx=" + this.toString());
                    }
                    try {
                        this.rollbackBranch();
                        return;
                    }
                    catch (Exception e) {
                        if (!this.trace) return;
                        log.trace("Exception in transaction branch rollback, tx=" + this.toString(), e);
                        return;
                    }
                }
                catch (Exception ignore) {
                    if (!this.trace) return;
                    log.trace("Ignoring exception in replayCompletion, tx=" + this.toString(), ignore);
                }
                return;
            }
            log.warn("Error reconstructing TransactionImpl instance for tx=" + this.toString() + " -- registeredResource not set.\n" + "The remote coordinator will NOT be contacted.");
            return;
        }
        if (this.status == 8) {
            this.lock();
            try {
                this.retryCommitRemoteResources();
                if (preparedXAWorkList.size() > 0) {
                    this.commitXAResourcesAfterTimeout();
                    return;
                }
                if (this.remoteResourcesToRetry != 0 || this.heuristicCode != 0) return;
                this.completeTransaction();
                return;
            }
            finally {
                this.unlock();
            }
        }
        if (this.status != 9) return;
        try {
            this.rollbackResourcesAndCompleteTransaction();
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TransactionImpl(long localId, int inboundFormatId, byte[] globalTransactionId, byte[] inboundBranchQualifier, List preparedXAWorkList, String[] resources, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        this.foreignTx = true;
        GlobalId globalId = new GlobalId(inboundFormatId, globalTransactionId);
        this.xid = xidFactory.recreateXid(localId, globalId);
        if (heurData == null) {
            this.status = 2;
        } else {
            this.status = heurData.transactionStatus;
            this.heuristicCode = heurData.heuristicStatusCode;
            this.heuristicHazard = heurData.locallyDetectedHeuristicHazard;
        }
        this.inboundBranchQualifier = inboundBranchQualifier;
        this.completionHandler = completionHandler;
        Iterator it = preparedXAWorkList.iterator();
        while (it.hasNext()) {
            XAWork preparedXAWork = (XAWork)it.next();
            EnlistedXAResource r = new EnlistedXAResource(preparedXAWork);
            this.xaResources.add(r);
        }
        for (int i = 0; i < resources.length; ++i) {
            EnlistedRemoteResource resource = new EnlistedRemoteResource(TransactionImpl.stringToResource(resources[i]), true);
            this.remoteResources.add(resource);
        }
        if (this.status == 8) {
            this.lock();
            try {
                this.retryCommitRemoteResources();
                if (this.xaResourcesToRetry > 0) {
                    this.commitXAResourcesAfterTimeout();
                    return;
                }
                if (this.remoteResourcesToRetry != 0 || this.heuristicCode != 0) return;
                this.completeTransaction();
                return;
            }
            finally {
                this.unlock();
            }
        }
        if (this.status != 9) return;
        try {
            this.rollbackResourcesAndCompleteTransaction();
            return;
        }
        finally {
            this.unlock();
        }
    }

    TransactionImpl(LogRecord.HeurData heurData, List xaResourcesWithHeuristics, TxCompletionHandler completionHandler) {
        EnlistedResource r;
        this.foreignTx = heurData.foreignTx;
        this.status = heurData.transactionStatus;
        if (this.status != 8 && this.status != 3 && this.status != 9 && this.status != 4) {
            throw new RuntimeException("Attempt to recreate heuristically completed transaction with status " + TxUtils.getStatusAsString(this.status) + ". " + "Must be STATUS_COMMITTING, " + "STATUS_COMMITTED, STATUS_ROLLING_BACK, " + "or STATUS_ROLLEDBACK.");
        }
        if (!this.foreignTx) {
            this.xid = xidFactory.recreateXid(heurData.localTransactionId);
        } else {
            GlobalId globalId = new GlobalId(heurData.formatId, heurData.globalTransactionId);
            this.xid = xidFactory.recreateXid(heurData.localTransactionId, globalId);
        }
        this.inboundBranchQualifier = heurData.inboundBranchQualifier;
        this.completionHandler = completionHandler;
        this.heuristicCode = heurData.heuristicStatusCode;
        if (!xaResourcesWithHeuristics.isEmpty()) {
            this.xaResourcesWithHeuristicDecisions = new ArrayList();
            Iterator it = xaResourcesWithHeuristics.iterator();
            while (it.hasNext()) {
                XAWork xaWork = (XAWork)it.next();
                xaWork.xaResourceAccess.release();
                r = new EnlistedXAResource(xaWork.res, xaWork.xid, heurData.transactionStatus == 3);
                this.xaResources.add(r);
                this.xaResourcesWithHeuristicDecisions.add(r);
            }
        }
        if (heurData.remoteResourceHeuristics != null && heurData.remoteResourceHeuristics.length > 0) {
            this.remoteResourcesWithHeuristicDecisions = new ArrayList();
            for (int i = 0; i < heurData.remoteResourceHeuristics.length; ++i) {
                HeuristicStatus heurStatus = heurData.remoteResourceHeuristics[i];
                r = new EnlistedRemoteResource(TransactionImpl.stringToResource(heurStatus.resourceRef), true, heurStatus.code);
                this.remoteResources.add(r);
                this.remoteResourcesWithHeuristicDecisions.add(r);
            }
        }
    }

    public boolean isImported() {
        return this.foreignTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timedOut(Timeout timeout) {
        this.lock();
        try {
            log.warn("Transaction " + this.toString() + " timed out." + " status=" + TxUtils.getStatusAsString(this.status));
            if (this.timeout == null) {
                return;
            }
            this.timeout = null;
            switch (this.status) {
                case 3: 
                case 4: 
                case 6: {
                    return;
                }
                case 9: {
                    return;
                }
                case 2: 
                case 8: {
                    return;
                }
                case 0: {
                    this.status = 1;
                }
                case 1: {
                    this.interruptThreads();
                    return;
                }
                case 7: {
                    this.status = 1;
                    return;
                }
            }
            log.warn("Unknown status at timeout, tx=" + this.toString());
            return;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace("Committing, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            this.beforePrepare();
            if (this.status == 0) {
                switch (this.getCommitStrategy()) {
                    case 0: {
                        if (this.trace) {
                            log.trace("Zero phase commit " + this.toString() + ": No resources.");
                        }
                        this.status = 3;
                        break;
                    }
                    case 1: {
                        if (this.trace) {
                            log.trace("One phase commit " + this.toString() + ": One resource.");
                        }
                        this.commitResources(true);
                        break;
                    }
                    default: {
                        if (this.trace) {
                            log.trace("Two phase commit " + this.toString() + ": Many resources.");
                        }
                        if (!this.prepareResources()) {
                            boolean commitDecision;
                            boolean bl = commitDecision = this.status == 2 && (this.heuristicCode == 0 || this.heuristicCode == 7);
                            if (!commitDecision) break;
                            try {
                                RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
                                if (logger != null) {
                                    this.completionHandler = logger.saveCommitDecision(this.xid.getLocalIdValue(), this.getStringfiedRemoteResourcesThatVotedCommit());
                                }
                            }
                            catch (Throwable e) {
                                if (e instanceof RecoveryTestingException) {
                                    throw (RecoveryTestingException)e;
                                }
                                log.warn("FAILED WHEN WRITING COMMIT RECORD. Rolling back now.", e);
                                this.status = 1;
                                this.cause = e;
                            }
                            this.cancelTimeout();
                            if (this.status != 2) break;
                            try {
                                this.commitResources(false);
                            }
                            catch (Throwable e) {
                                if (e instanceof RecoveryTestingException) {
                                    throw (RecoveryTestingException)e;
                                }
                                log.warn("Unexpected exception in commitResources:", e);
                            }
                            break;
                        }
                        this.status = 3;
                    }
                }
            }
            if (this.status == 8) {
                if (this.xaResourcesToRetry > 0) {
                    this.commitXAResourcesAfterTimeout();
                }
                this.checkHeuristicsButDoNotThrowHeuristicHazard();
            } else {
                if (this.status != 3) {
                    Throwable causedByThrowable = this.cause;
                    this.rollbackResourcesAndCompleteTransaction();
                    throw new JBossRollbackException("Unable to commit, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status), causedByThrowable);
                }
                this.cancelTimeout();
                this.doAfterCompletion();
                this.checkHeuristicsButDoNotThrowHeuristicHazard();
                this.instanceDone();
                if (this.trace) {
                    log.trace("Committed OK, tx=" + this.toString());
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace("rollback(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            this.checkWork();
            switch (this.status) {
                case 0: {
                    this.status = 1;
                }
                case 1: {
                    this.endResources();
                    this.rollbackResourcesAndCompleteTransaction();
                    this.heuristicCode = 0;
                    return;
                }
                case 7: {
                    this.status = 1;
                    return;
                }
            }
            throw new IllegalStateException("Cannot rollback(), tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
        }
        finally {
            Thread.interrupted();
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes tx=" + this.toString());
        }
        if (flag != 0x4000000 && flag != 0x2000000 && flag != 0x20000000) {
            throw new IllegalArgumentException("Bad flag: " + flag + " tx=" + this.toString());
        }
        this.lock();
        try {
            EnlistedXAResource resource;
            if (this.trace) {
                log.trace("delistResource(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            if ((resource = this.findResource(xaRes)) == null) {
                throw new IllegalArgumentException("xaRes not enlisted " + xaRes);
            }
            switch (this.status) {
                case 0: 
                case 1: {
                    break;
                }
                case 7: {
                    throw new IllegalStateException("Already started preparing, tx=" + this.toString());
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back, tx=" + this.toString());
                }
                case 2: {
                    throw new IllegalStateException("Already prepared, tx=" + this.toString());
                }
                case 8: {
                    throw new IllegalStateException("Already started committing, tx=" + this.toString());
                }
                case 3: {
                    throw new IllegalStateException("Already committed, tx=" + this.toString());
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back, tx=" + this.toString());
                }
                case 6: {
                    throw new IllegalStateException("No transaction, tx=" + this.toString());
                }
                case 5: {
                    throw new IllegalStateException("Unknown state, tx=" + this.toString());
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + TxUtils.getStatusAsString(this.status) + ", tx=" + this.toString());
                }
            }
            try {
                boolean bl = resource.delistResource(xaRes, flag);
                return bl;
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.status = 1;
                this.cause = xae;
                boolean bl = false;
                this.unlock();
                return bl;
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (xaRes == null) {
            throw new IllegalArgumentException("null xaRes, tx=" + this.toString());
        }
        this.lock();
        try {
            EnlistedXAResource resource;
            block17: {
                block18: {
                    if (this.trace) {
                        log.trace("enlistResource(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status) + ", xaRes=" + xaRes);
                    }
                    this.checkStatus();
                    if (this.resourcesEnded) {
                        throw new IllegalStateException("Too late to enlist resources, tx=" + this.toString());
                    }
                    try {
                        resource = this.findResource(xaRes);
                        if (resource == null) break block17;
                        if (!resource.isEnlisted()) break block18;
                        if (this.trace) {
                            log.trace("Already enlisted: tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status) + ", xaRes=" + xaRes);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    catch (XAException xae) {
                        this.logXAException(xae);
                        this.cause = xae;
                        boolean bl = false;
                        return bl;
                    }
                }
                if (resource.isDelisted(xaRes)) {
                    resource = null;
                } else {
                    boolean bl = resource.startResource();
                    return bl;
                }
            }
            if (this.parentCoordinator != null && this.recoveryCoordinator == null) {
                this.registerResourceWithParentCoordinator();
            }
            if ((resource = this.findResourceManager(xaRes)) != null) {
                resource = this.addResource(xaRes, resource.getXid(), resource);
                boolean bl = resource.startResource();
                return bl;
            }
            resource = this.addResource(xaRes, this.createXidBranch(), null);
            boolean bl = resource.startResource();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public int getStatus() {
        if (this.done) {
            return 6;
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization s) throws RollbackException, IllegalStateException, SystemException {
        if (s == null) {
            throw new IllegalArgumentException("Null synchronization, tx=" + this.toString());
        }
        this.lock();
        try {
            if (this.trace) {
                log.trace("registerSynchronization(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            this.checkStatus();
            if (this.syncCount == this.syncAllocSize) {
                this.syncAllocSize = 2 * this.syncAllocSize;
                Synchronization[] sy = new Synchronization[this.syncAllocSize];
                System.arraycopy(this.sync, 0, sy, 0, this.syncCount);
                this.sync = sy;
            }
            this.sync[this.syncCount++] = s;
            if (this.parentCoordinator != null && this.recoveryCoordinator == null) {
                this.registerResourceWithParentCoordinator();
            }
        }
        finally {
            this.unlock();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.lock();
        try {
            if (this.trace) {
                log.trace("setRollbackOnly(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            switch (this.status) {
                case 0: {
                    if (this.parentCoordinator != null && this.recoveryCoordinator == null) {
                        try {
                            this.registerResourceWithParentCoordinator();
                        }
                        catch (RollbackException e) {
                            log.warn("RollbackException in setRollbackOnly: " + e);
                        }
                    }
                }
                case 2: 
                case 7: {
                    this.status = 1;
                }
                case 1: 
                case 9: {
                    return;
                }
                case 8: {
                    throw new IllegalStateException("Already started committing, tx=" + this.toString());
                }
                case 3: {
                    throw new IllegalStateException("Already committed, tx=" + this.toString());
                }
                case 4: {
                    throw new IllegalStateException("Already rolled back, tx=" + this.toString());
                }
                case 6: {
                    throw new IllegalStateException("No transaction, tx=" + this.toString());
                }
                case 5: {
                    throw new IllegalStateException("Unknown state, tx=" + this.toString());
                }
            }
            throw new IllegalStateException("Illegal status: " + TxUtils.getStatusAsString(this.status) + ", tx=" + this.toString());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlistRemoteResource(Resource remoteRes) throws RollbackException, IllegalStateException {
        if (remoteRes == null) {
            throw new IllegalArgumentException("null remoteRes, tx=" + this.toString());
        }
        this.lock();
        try {
            if (this.trace) {
                log.trace("enlistRemoteResource(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            this.checkStatus();
            if (this.resourcesEnded) {
                throw new IllegalStateException("Too late to enlist resources, tx=" + this.toString());
            }
            if (this.parentCoordinator != null && this.recoveryCoordinator == null) {
                this.registerResourceWithParentCoordinator();
            }
            EnlistedRemoteResource resource = new EnlistedRemoteResource(remoteRes);
            this.remoteResources.add(resource);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid inboundXid) throws HeuristicHazardException, HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.lock();
        try {
            block27: {
                if (this.trace) {
                    log.trace("Preparing, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                this.checkWork();
                this.beforePrepare();
                if (this.status == 0) {
                    switch (this.getCommitStrategy()) {
                        case 0: {
                            if (this.trace) {
                                log.trace("Prepare foreign tx=" + this.toString() + ": No resources.");
                            }
                            if (this.syncCount == 0) {
                                this.status = 3;
                                this.completeTransaction();
                                int n = 3;
                                return n;
                            }
                            this.status = 2;
                            int n = 0;
                            return n;
                        }
                    }
                    if (this.trace) {
                        log.trace("Prepare foreign tx=" + this.toString() + ": one or more resources.");
                    }
                    if (!this.prepareResources()) {
                        boolean commitDecision;
                        boolean bl = commitDecision = this.status == 2 && (this.heuristicCode == 0 || this.heuristicCode == 7);
                        if (commitDecision) {
                            try {
                                RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
                                if (logger == null) break block27;
                                if (inboundXid == null) {
                                    this.completionHandler = logger.savePrepareDecision(this.xid.getLocalIdValue(), this.xid.getFormatId(), this.xid.getGlobalTransactionId(), TransactionImpl.recoveryCoordinatorToString(this.recoveryCoordinator), this.getStringfiedRemoteResourcesThatVotedCommit());
                                    break block27;
                                }
                                this.completionHandler = logger.savePrepareDecision(this.xid.getLocalIdValue(), inboundXid, this.getStringfiedRemoteResourcesThatVotedCommit());
                            }
                            catch (Throwable e) {
                                if (e instanceof RecoveryTestingException) {
                                    throw (RecoveryTestingException)e;
                                }
                                log.warn("FAILED WHEN WRITING PREPARE RECORD. Rolling back now.");
                            }
                        }
                    } else {
                        if (this.syncCount == 0) {
                            if (this.trace) {
                                log.trace("Prepared foreign tx=" + this.toString() + ": All readonly," + " no Synchronizations registered");
                            }
                            this.status = 3;
                            this.completeTransaction();
                            int commitDecision = 3;
                            return commitDecision;
                        }
                        if (this.trace) {
                            log.trace("Prepared foreign tx=" + this.toString() + ": All readonly, but there is at least" + " one Synchronization registered");
                        }
                        this.status = 2;
                        int commitDecision = 0;
                        return commitDecision;
                    }
                }
            }
            if (this.status != 2) {
                Throwable causedByThrowable = this.cause;
                this.rollbackResourcesAndCompleteTransaction();
                throw new JBossRollbackException("Unable to prepare, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status), causedByThrowable);
            }
            if (inboundXid == null) {
                this.createPreparedTimeout();
            }
            int n = 0;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(boolean onePhase) throws RollbackException, HeuristicHazardException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.checkWork();
        if (onePhase) {
            this.commit();
            return;
        }
        this.lock();
        try {
            if (this.trace) {
                log.trace("Committing two phase, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            this.cancelPreparedTimeout();
            switch (this.status) {
                case 7: {
                    throw new IllegalStateException("Still preparing, tx=" + this.toString());
                }
                case 9: {
                    throw new IllegalStateException("Already started rolling back, tx=" + this.toString());
                }
                case 4: {
                    this.instanceDone();
                    throw new IllegalStateException("Already rolled back, tx=" + this.toString());
                }
                case 8: {
                    if (this.trace) {
                        log.trace("Already committing, tx=" + this.toString());
                    }
                    return;
                }
                case 3: {
                    this.instanceDone();
                    if (this.trace) {
                        log.trace("Already committed, tx=" + this.toString());
                    }
                    return;
                }
                case 6: {
                    throw new IllegalStateException("No transaction, tx=" + this.toString());
                }
                case 5: {
                    throw new IllegalStateException("Unknown state, tx=" + this.toString());
                }
                case 1: {
                    this.endResources();
                    this.rollbackResourcesAndCompleteTransaction();
                    this.checkHeuristics();
                    throw new RollbackException("Already marked for rollback, tx=" + this.toString());
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal status: " + TxUtils.getStatusAsString(this.status) + ", tx=" + this.toString());
                }
            }
            this.commitResources(false);
            if (this.status == 8) {
                if (this.xaResourcesToRetry > 0) {
                    this.commitXAResourcesAfterTimeout();
                }
                this.checkHeuristics();
            } else {
                if (this.status != 3) {
                    Throwable causedByThrowable = this.cause;
                    throw new JBossRollbackException("Unable to commit, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status), causedByThrowable);
                }
                this.cancelTimeout();
                this.doAfterCompletion();
                this.checkHeuristics();
                this.instanceDone();
                if (this.trace) {
                    log.trace("Committed OK, tx=" + this.toString());
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollbackBranch() throws HeuristicCommitException, HeuristicMixedException, HeuristicHazardException, IllegalStateException {
        this.lock();
        try {
            if (this.trace) {
                log.trace("rollbackBranch(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
            }
            this.checkWork();
            this.cancelPreparedTimeout();
            switch (this.status) {
                case 0: 
                case 2: {
                    this.status = 1;
                }
                case 1: {
                    this.endResources();
                    this.rollbackResourcesAndCompleteTransaction();
                    switch (this.getFullHeuristicCode()) {
                        case 8: {
                            if (!this.trace) throw new HeuristicHazardException();
                            log.trace("Throwing HeuristicHazardException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                            throw new HeuristicHazardException();
                        }
                        case 5: {
                            if (!this.trace) throw new HeuristicMixedException();
                            log.trace("Throwing HeuristicMixedException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                            throw new HeuristicMixedException();
                        }
                        case 6: {
                            if (!this.trace) return;
                            log.trace("Not throwing HeuristicRollbackException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                            return;
                        }
                        case 7: {
                            if (!this.trace) throw new HeuristicCommitException();
                            log.trace("Throwing HeuristicCommitException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                            throw new HeuristicCommitException();
                        }
                    }
                    return;
                }
                case 7: {
                    this.status = 1;
                    return;
                }
                case 4: {
                    if (!this.trace) return;
                    log.trace("Already rolledback, tx=" + this.toString());
                    return;
                }
            }
            throw new IllegalStateException("Cannot rollback(), tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
        }
        finally {
            Thread.interrupted();
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget() {
        this.lock();
        try {
            if (this.heuristicCode == 0 && !this.heuristicHazard) {
                return;
            }
            if (!(this.status == 3 || this.status == 4 || this.status == 8 && this.heuristicHazard || this.status == 9 && this.heuristicHazard)) {
                return;
            }
            if (this.forgetResources()) {
                RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
                if (logger != null) {
                    logger.clearHeuristicStatus(this.xid.getLocalIdValue());
                    if (this.status == 3 && this.completionHandler != null) {
                        this.completionHandler.handleTxCompletion(this.xid.getLocalIdValue());
                    }
                }
                this.instanceDone();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int replayCompletion(final Resource r) {
        this.lock();
        try {
            if (this.status != 1 && this.status != 9 && this.status != 4) {
                final boolean pendingCommits = this.status == 8 && this.remoteResourcesToRetry > 0;
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block11: {
                            try {
                                if (TransactionImpl.this.trace) {
                                    log.trace("Replay completion thread:  committing remote resource " + r);
                                }
                                r.commit();
                                if (TransactionImpl.this.trace) {
                                    log.trace("Replay completion thread:  committed remote resource " + r);
                                }
                            }
                            catch (Throwable ignored) {
                                if (!TransactionImpl.this.trace) break block11;
                                log.trace("Replay completion thread: ignored exception when committing remote resource " + r, ignored);
                            }
                        }
                        if (pendingCommits) {
                            TransactionImpl.this.lock();
                            try {
                                if (TransactionImpl.this.trace) {
                                    log.trace("Replay completion thread: calling retryCommitRemoteResources");
                                }
                                TransactionImpl.this.retryCommitRemoteResources();
                                if (TransactionImpl.this.xaResourcesToRetry == 0 && TransactionImpl.this.remoteResourcesToRetry == 0 && TransactionImpl.this.heuristicCode == 0) {
                                    TransactionImpl.this.completeTransaction();
                                }
                            }
                            finally {
                                TransactionImpl.this.unlock();
                            }
                        }
                        if (TransactionImpl.this.trace) {
                            log.trace("Replay completion thread: exiting");
                        }
                    }
                };
                Thread t = new Thread(runnable, "replayCompletionThread");
                t.start();
            }
            int n = this.status;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public long getTimeLeftBeforeTimeout(boolean errorRollback) throws RollbackException {
        if (errorRollback && this.status != 0) {
            throw new RollbackException("Transaction is not active: " + TxUtils.getStatusAsString(this.status));
        }
        return this.start + this.timeoutPeriod - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAssociatedThreadCount() {
        this.lock();
        try {
            int n = this.threads.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAssociatedThreads() {
        this.lock();
        try {
            Set set = Collections.unmodifiableSet(this.threads);
            return set;
        }
        finally {
            this.unlock();
        }
    }

    public int hashCode() {
        return this.xid.hashCode();
    }

    public String toString() {
        return "TransactionImpl:" + xidFactory.toString(this.xid);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof TransactionImpl) {
            return this.getLocalIdValue() == ((TransactionImpl)obj).getLocalIdValue();
        }
        return false;
    }

    public long getLocalIdValue() {
        return this.xid.getLocalIdValue();
    }

    public LocalId getLocalId() {
        return this.xid.getLocalId();
    }

    public GlobalId getGlobalId() {
        return this.xid.getTrulyGlobalId();
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public TxPropagationContext getPropagationContext() {
        if (this.dtmPropagationContext == null) {
            Coordinator coordinatorToPropagate = this.parentCoordinator == null || interpositionEnabled || !Proxy.isProxyClass(this.parentCoordinator.getClass()) ? dtmCoordinatorFactory.createCoordinator(this.getLocalIdValue()) : this.parentCoordinator;
            this.dtmPropagationContext = new TxPropagationContext(this.xid.getFormatId(), this.xid.getGlobalTransactionId(), 0, coordinatorToPropagate, null);
        }
        try {
            this.dtmPropagationContext.timeout = TMUtil.divideAndRoundUp(this.getTimeLeftBeforeTimeout(true), 1000L);
        }
        catch (RollbackException transactionNotActive) {
            if (this.status == 1) {
                this.dtmPropagationContext.timeout = 0;
            }
            this.dtmPropagationContext = null;
        }
        return this.dtmPropagationContext;
    }

    public Object getOTSPropagationContext() {
        if (this.otsPropagationContext == null) {
            this.otsPropagationContext = this.parentCoordinator == null || interpositionEnabled || Proxy.isProxyClass(this.parentCoordinator.getClass()) ? otsContextFactory.createOTSContext(this.xid.getFormatId(), this.xid.getGlobalTransactionId(), this.getLocalIdValue()) : otsContextFactory.createOTSContext(this.xid.getFormatId(), this.xid.getGlobalTransactionId(), this.parentCoordinator);
        }
        try {
            otsContextFactory.setTimeout(this.otsPropagationContext, TMUtil.divideAndRoundUp(this.getTimeLeftBeforeTimeout(true), 1000L));
        }
        catch (RollbackException transactionNotActive) {
            if (this.status == 1) {
                otsContextFactory.setTimeout(this.otsPropagationContext, 0);
            }
            this.otsPropagationContext = null;
        }
        return this.otsPropagationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeuristicStatus(LogRecord.HeurData heurData) {
        this.lock();
        try {
            if (this.status != heurData.transactionStatus) {
                if (this.status == 2) {
                    this.cancelPreparedTimeout();
                }
                this.status = heurData.transactionStatus;
                if (this.status == 8) {
                    this.retryCommitRemoteResources();
                    if (this.xaResourcesToRetry > 0) {
                        this.commitXAResourcesAfterTimeout();
                    } else if (this.remoteResourcesToRetry == 0 && this.heuristicCode == 0) {
                        this.completeTransaction();
                    }
                } else if (this.status == 9) {
                    this.rollbackResourcesAndCompleteTransaction();
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    boolean isPreparedOrHeuristicallyCompletedJCAInboundTx() {
        return this.inboundBranchQualifier != null && (this.status == 2 || this.getFullHeuristicCode() != 0 && (this.status == 3 || this.status == 4));
    }

    Xid getInboundXid() {
        return new Xid(){

            public int getFormatId() {
                return TransactionImpl.this.xid.getFormatId();
            }

            public byte[] getGlobalTransactionId() {
                return TransactionImpl.this.xid.getGlobalTransactionId();
            }

            public byte[] getBranchQualifier() {
                return (byte[])TransactionImpl.this.inboundBranchQualifier.clone();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associateCurrentThread() {
        Thread.interrupted();
        this.lock();
        try {
            this.threads.add(Thread.currentThread());
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disassociateCurrentThread() {
        if (this.done) {
            this.threads.remove(Thread.currentThread());
        } else {
            this.lock();
            try {
                this.threads.remove(Thread.currentThread());
            }
            finally {
                this.unlock();
            }
        }
        Thread.interrupted();
    }

    synchronized void lock() {
        if (this.done) {
            throw new IllegalStateException("Transaction has terminated, tx=" + this.toString());
        }
        Thread currentThread = Thread.currentThread();
        if (this.locked != null && this.locked != currentThread) {
            log.debug("Lock contention, tx=" + this.toString() + " otherThread=" + this.locked);
            while (this.locked != null && this.locked != currentThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.done) continue;
                throw new IllegalStateException("Transaction has now terminated, tx=" + this.toString());
            }
        }
        this.locked = currentThread;
        ++this.lockDepth;
    }

    synchronized void unlock() {
        Thread currentThread = Thread.currentThread();
        if (this.locked == null || this.locked != currentThread) {
            log.warn("Unlocking, but not locked, tx=" + this.toString() + " otherThread=" + this.locked, new Throwable("[Stack trace]"));
        } else if (--this.lockDepth == 0) {
            this.locked = null;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deactivate() {
        this.lock();
        try {
            this.cancelTimeout();
            this.cancelPreparedTimeout();
            this.cancelXARetryTimeout();
            this.parentCoordinator = null;
            this.sync = null;
            this.xaResources = null;
            this.remoteResources = null;
            this.transactionLocalMap.clear();
            this.threads.clear();
            this.status = 6;
            this.notifyAll();
            this.done = true;
        }
        finally {
            this.unlock();
        }
    }

    Work getWork() {
        return this.work;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWork(Work work) throws WorkCompletedException {
        this.lock();
        try {
            if (work == null) {
                this.work = null;
                return;
            }
            if (this.status == 6 || this.status == 5) {
                throw new WorkCompletedException("The transaction is not active " + this.toString() + ": " + TxUtils.getStatusAsString(this.status), "3");
            }
            if (this.status != 0) {
                throw new WorkCompletedException("Too late to start work " + this.toString() + ": " + TxUtils.getStatusAsString(this.status), "2");
            }
            if (this.work != null) {
                throw new WorkCompletedException("Already have work " + this.toString() + ": " + this.work, "2");
            }
            this.work = work;
        }
        finally {
            this.unlock();
        }
    }

    boolean isDone() {
        return this.done || this.heuristicCode != 0 && (this.status == 8 || this.status == 3 || this.status == 9 || this.status == 4);
    }

    Object getTransactionLocalValue(TransactionLocal tlocal) {
        return this.transactionLocalMap.get(tlocal);
    }

    void putTransactionLocalValue(TransactionLocal tlocal, Object value) {
        this.transactionLocalMap.put(tlocal, value);
    }

    boolean containsTransactionLocal(TransactionLocal tlocal) {
        return this.transactionLocalMap.containsKey(tlocal);
    }

    private void beforePrepare() throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.checkIntegrity();
        this.doBeforeCompletion();
        if (this.trace) {
            log.trace("Before completion done, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
        }
        this.endResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIntegrity() throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        this.checkBeforeStatus();
        TransactionIntegrity integrity = TxManager.getInstance().getTransactionIntegrity();
        if (integrity != null) {
            this.unlock();
            try {
                integrity.checkTransactionIntegrity(this);
            }
            finally {
                this.lock();
            }
            this.checkBeforeStatus();
        }
    }

    private void checkBeforeStatus() throws HeuristicMixedException, HeuristicRollbackException, RollbackException {
        switch (this.status) {
            case 7: {
                throw new IllegalStateException("Already started preparing, tx=" + this.toString());
            }
            case 2: {
                throw new IllegalStateException("Already prepared, tx=" + this.toString());
            }
            case 9: {
                throw new IllegalStateException("Already started rolling back, tx=" + this.toString());
            }
            case 4: {
                this.instanceDone();
                throw new IllegalStateException("Already rolled back, tx=" + this.toString());
            }
            case 8: {
                throw new IllegalStateException("Already started committing, tx=" + this.toString());
            }
            case 3: {
                this.instanceDone();
                throw new IllegalStateException("Already committed, tx=" + this.toString());
            }
            case 6: {
                throw new IllegalStateException("No transaction, tx=" + this.toString());
            }
            case 5: {
                throw new IllegalStateException("Unknown state, tx=" + this.toString());
            }
            case 1: {
                this.endResources();
                this.rollbackResourcesAndCompleteTransaction();
                this.checkHeuristicsButDoNotThrowHeuristicHazard();
                throw new RollbackException("Already marked for rollback, tx=" + this.toString());
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException("Illegal status: " + TxUtils.getStatusAsString(this.status) + ", tx=" + this.toString());
            }
        }
    }

    private void completeTransaction() {
        this.cancelTimeout();
        this.doAfterCompletion();
        this.instanceDone();
    }

    private void checkStatus() throws RollbackException {
        switch (this.status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Already prepared, tx=" + this.toString());
            }
            case 8: {
                throw new IllegalStateException("Already started committing, tx=" + this.toString());
            }
            case 3: {
                throw new IllegalStateException("Already committed, tx=" + this.toString());
            }
            case 1: {
                throw new RollbackException("Already marked for rollback, tx=" + this.toString());
            }
            case 9: {
                throw new RollbackException("Already started rolling back, tx=" + this.toString());
            }
            case 4: {
                throw new RollbackException("Already rolled back, tx=" + this.toString());
            }
            case 6: {
                throw new IllegalStateException("No transaction, tx=" + this.toString());
            }
            case 5: {
                throw new IllegalStateException("Unknown state, tx=" + this.toString());
            }
            default: {
                throw new IllegalStateException("Illegal status: " + TxUtils.getStatusAsString(this.status) + ", tx=" + this.toString());
            }
        }
    }

    private void interruptThreads() {
        TxManager manager = TxManager.getInstance();
        if (manager.isInterruptThreads()) {
            HashSet clone = (HashSet)this.threads.clone();
            this.threads.clear();
            Iterator i = clone.iterator();
            while (i.hasNext()) {
                Thread thread = (Thread)i.next();
                try {
                    thread.interrupt();
                }
                catch (Throwable ignored) {
                    if (!this.trace) continue;
                    log.trace("Ignored error interrupting thread: " + thread, ignored);
                }
            }
        }
    }

    private void logXAException(XAException xae) {
        log.warn("XAException: tx=" + this.toString() + " errorCode=" + TxUtils.getXAErrorCodeAsString(xae.errorCode), xae);
        if (xaExceptionFormatter != null) {
            xaExceptionFormatter.formatXAException(xae, log);
        }
    }

    private synchronized void instanceDone() {
        TxManager manager = TxManager.getInstance();
        if (this.status == 3) {
            manager.incCommitCount();
        } else {
            manager.incRollbackCount();
        }
        this.parentCoordinator = null;
        this.sync = null;
        this.xaResources = null;
        this.remoteResources = null;
        this.transactionLocalMap.clear();
        this.threads.clear();
        manager.releaseTransactionImpl(this);
        this.status = 6;
        this.notifyAll();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTimeout() {
        if (this.timeout != null) {
            this.unlock();
            try {
                this.timeout.cancel();
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace("failed to cancel timeout, tx=" + this.toString(), e);
                }
            }
            finally {
                this.lock();
            }
            this.timeout = null;
        }
    }

    private void createPreparedTimeout() {
        this.preparedTimeout = TimeoutFactory.createTimeout(System.currentTimeMillis() + (long)TxManager.getInstance().getPreparedTimeoutMillis(), new TimeoutTarget(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timedOut(Timeout timeout) {
                block13: {
                    if (TransactionImpl.this.trace) {
                        log.trace("Prepared timeout expired for tx=" + TransactionImpl.this.toString() + ", calling replayCompletion " + "on the recovery coordinator");
                    }
                    try {
                        TransactionImpl.this.recoveryCoordinator.replayCompletion(TransactionImpl.this.registeredResource);
                    }
                    catch (NoSuchObjectException noCoordinator) {
                        if (TransactionImpl.this.trace) {
                            log.trace("Exception in replayCompletion: no coordinator for tx=" + this.toString(), noCoordinator);
                            log.trace("Rolling back transaction branch, tx=" + TransactionImpl.this.toString());
                        }
                        try {
                            TransactionImpl.this.rollbackBranch();
                        }
                        catch (Exception e) {
                            if (TransactionImpl.this.trace) {
                                log.trace("Exception in transaction branch rollback, tx=" + TransactionImpl.this.toString(), e);
                            }
                        }
                    }
                    catch (Exception ignore) {
                        if (!TransactionImpl.this.trace) break block13;
                        log.trace("Ignoring exception in replayCompletion, tx=" + TransactionImpl.this.toString(), ignore);
                    }
                }
                if (!TransactionImpl.this.done) {
                    TransactionImpl.this.lock();
                    try {
                        if (TransactionImpl.this.preparedTimeout != null) {
                            TransactionImpl.this.preparedTimeout = TimeoutFactory.createTimeout(System.currentTimeMillis() + (long)TxManager.getInstance().getPreparedTimeoutMillis(), this);
                        }
                    }
                    finally {
                        TransactionImpl.this.unlock();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPreparedTimeout() {
        if (this.preparedTimeout != null) {
            Timeout pt = this.preparedTimeout;
            this.preparedTimeout = null;
            this.unlock();
            try {
                pt.cancel();
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace("failed to cancel prepared timeout, tx=" + this.toString(), e);
                }
            }
            finally {
                this.lock();
            }
        }
    }

    private EnlistedXAResource findResource(XAResource xaRes) {
        for (int idx = this.xaResources.size() - 1; idx >= 0; --idx) {
            EnlistedXAResource resource = (EnlistedXAResource)this.xaResources.get(idx);
            if (xaRes != resource.getXAResource()) continue;
            return resource;
        }
        return null;
    }

    private EnlistedXAResource findResourceManager(XAResource xaRes) throws XAException {
        for (int i = 0; i < this.xaResources.size(); ++i) {
            EnlistedXAResource resource = (EnlistedXAResource)this.xaResources.get(i);
            if (!resource.isResourceManager(xaRes)) continue;
            return resource;
        }
        return null;
    }

    private EnlistedXAResource addResource(XAResource xaRes, Xid branchXid, EnlistedXAResource sameRMResource) {
        EnlistedXAResource resource = new EnlistedXAResource(xaRes, branchXid, sameRMResource);
        this.xaResources.add(resource);
        if (this.lastResource == null && xaRes instanceof LastResource) {
            this.lastResource = resource;
        }
        return resource;
    }

    private void endResources() {
        for (int idx = 0; idx < this.xaResources.size(); ++idx) {
            EnlistedXAResource resource = (EnlistedXAResource)this.xaResources.get(idx);
            try {
                resource.endResource();
                continue;
            }
            catch (XAException xae) {
                this.logXAException(xae);
                this.status = 1;
                this.cause = xae;
            }
        }
        this.resourcesEnded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBeforeCompletion() {
        this.unlock();
        try {
            for (int i = 0; i < this.syncCount; ++i) {
                try {
                    if (this.trace) {
                        log.trace("calling sync " + i + ", " + this.sync[i] + " tx=" + this.toString());
                    }
                    this.sync[i].beforeCompletion();
                    continue;
                }
                catch (Throwable t) {
                    if (this.trace) {
                        log.trace("failed before completion " + this.sync[i], t);
                    }
                    this.status = 1;
                    this.cause = t;
                    break;
                }
            }
        }
        finally {
            this.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAfterCompletion() {
        this.unlock();
        try {
            for (int i = 0; i < this.syncCount; ++i) {
                try {
                    this.sync[i].afterCompletion(this.status);
                    continue;
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    log.trace("failed after completion " + this.sync[i], t);
                }
            }
        }
        finally {
            this.lock();
        }
    }

    private static int groupHeuristics(int code1, int code2) {
        switch (code2) {
            case 5: {
                code1 = 5;
                break;
            }
            case 6: {
                if (code1 == 0) {
                    code1 = 6;
                    break;
                }
                if (code1 != 7 && code1 != 8) break;
                code1 = 5;
                break;
            }
            case 7: {
                if (code1 == 0) {
                    code1 = 7;
                    break;
                }
                if (code1 != 6 && code1 != 8) break;
                code1 = 5;
                break;
            }
            case 8: {
                if (code1 == 0) {
                    code1 = 8;
                    break;
                }
                if (code1 != 7 && code1 != 6) break;
                code1 = 5;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return code1;
    }

    private void gotHeuristic(EnlistedResource resource, int code) {
        this.heuristicCode = TransactionImpl.groupHeuristics(this.heuristicCode, code);
        if (resource != null) {
            resource.remember(code);
        }
    }

    private int consolidateHeuristics() {
        if (this.committedResources > 0 && this.rolledbackResources > 0) {
            this.heuristicCode = 5;
        }
        return this.heuristicCode;
    }

    private int getFullHeuristicCode() {
        return this.heuristicHazard ? TransactionImpl.groupHeuristics(this.heuristicCode, 8) : this.heuristicCode;
    }

    private void checkHeuristics() throws HeuristicHazardException, HeuristicMixedException, HeuristicRollbackException {
        if (this.committedResources > 0 && this.rolledbackResources > 0) {
            this.heuristicCode = 5;
        }
        switch (this.getFullHeuristicCode()) {
            case 8: {
                if (this.trace) {
                    log.trace("Throwing HeuristicHazardException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                throw new HeuristicHazardException();
            }
            case 5: {
                if (this.trace) {
                    log.trace("Throwing HeuristicMixedException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                throw new HeuristicMixedException();
            }
            case 6: {
                if (this.trace) {
                    log.trace("Throwing HeuristicRollbackException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                throw new HeuristicRollbackException();
            }
            case 7: {
                if (this.trace) {
                    log.trace("NOT Throwing HeuristicCommitException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                return;
            }
        }
    }

    private void checkHeuristicsButDoNotThrowHeuristicHazard() throws HeuristicMixedException, HeuristicRollbackException {
        if (this.committedResources > 0 && this.rolledbackResources > 0) {
            this.heuristicCode = 5;
        }
        switch (this.getFullHeuristicCode()) {
            case 8: {
                if (TxManager.getInstance().isReportHeuristicHazardAsHeuristicMixed()) {
                    if (this.trace) {
                        log.trace("Throwing HeuristicMixedException instead of HeuristicHazardException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                    }
                    throw new HeuristicMixedException();
                }
                if (this.trace) {
                    log.trace("NOT throwing HeuristicHazardException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                return;
            }
            case 5: {
                if (this.trace) {
                    log.trace("Throwing HeuristicMixedException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                throw new HeuristicMixedException();
            }
            case 6: {
                if (this.trace) {
                    log.trace("Throwing HeuristicRollbackException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                throw new HeuristicRollbackException();
            }
            case 7: {
                if (this.trace) {
                    log.trace("NOT Throwing HeuristicCommitException, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerResourceWithParentCoordinator() throws RollbackException {
        if (this.trace) {
            log.trace("registerResourceWithParentCoordinator(): Entered, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status));
        }
        Resource r = null;
        if (Proxy.isProxyClass(this.parentCoordinator.getClass())) {
            if (dtmResourceFactory == null) {
                log.warn("Missing DTM resource factory, tx=" + this.toString());
                this.status = 1;
                throw new RollbackException("Missing DTM resource factory");
            }
            r = dtmResourceFactory.createResource(this.getLocalIdValue());
        } else {
            if (otsResourceFactory == null) {
                log.warn("Missing OTS resource factory, tx=" + this.toString());
                this.status = 1;
                throw new RollbackException("Missing OTS resource factory");
            }
            r = otsResourceFactory.createResource(this.getLocalIdValue());
        }
        try {
            this.unlock();
            try {
                this.recoveryCoordinator = this.parentCoordinator.registerResource(r);
                this.registeredResource = r;
                return;
            }
            finally {
                this.lock();
            }
        }
        catch (TransactionInactiveException e) {
            this.status = 1;
            if (!this.trace) throw new RollbackException(e.toString());
            log.trace("Got TransactionInactiveException, throwing RollbackException");
            throw new RollbackException(e.toString());
        }
        catch (TransactionRolledbackException e) {
            this.status = 1;
            if (!this.trace) throw new RollbackException(e.toString());
            log.trace("Got TransactionRolledbackException, throwing RollbackException");
            throw new RollbackException(e.toString());
        }
        catch (RemoteException e) {
            this.status = 1;
            if (!this.trace) throw new RollbackException(e.toString());
            log.trace("Got RemoteException, throwing RollbackException");
            throw new RollbackException(e.toString());
        }
    }

    private boolean prepareResources() {
        String strVote;
        EnlistedResource resource;
        int i;
        boolean readOnly = true;
        this.status = 7;
        if (this.trace) {
            log.trace("Preparing " + this.xaResources.size() + " XA resource(s)");
        }
        for (i = 0; i < this.xaResources.size(); ++i) {
            if (this.status != 7) {
                return false;
            }
            resource = (EnlistedXAResource)this.xaResources.get(i);
            if (!((EnlistedXAResource)resource).isResourceManager() || resource == this.lastResource) continue;
            try {
                int vote = ((EnlistedXAResource)resource).prepare();
                if (this.trace) {
                    strVote = vote == 5 ? "OK" : (vote == 4 ? "READONLY" : "ROLLBACK");
                    log.trace("XA resource voted " + strVote);
                }
                if (vote == 5) {
                    readOnly = false;
                    continue;
                }
                if (vote == 4) continue;
                if (this.trace) {
                    log.trace("prepareResources got a rollback vote from an XA resource, tx=" + this.toString() + " resource=" + resource, new Exception());
                }
                this.status = 1;
                return false;
            }
            catch (XAException e) {
                readOnly = false;
                this.logXAException(e);
                switch (e.errorCode) {
                    case 7: {
                        this.gotHeuristic(resource, e.errorCode);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        this.gotHeuristic(resource, e.errorCode);
                    }
                    default: {
                        this.cause = e;
                        this.status = 1;
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (t instanceof RecoveryTestingException) {
                    throw (RecoveryTestingException)t;
                }
                if (this.trace) {
                    log.trace("unhandled throwable in prepareResources " + this.toString(), t);
                }
                this.status = 1;
                this.cause = t;
                return false;
            }
        }
        if (this.trace) {
            log.trace("Preparing " + this.remoteResources.size() + " remote resource(s)");
        }
        for (i = 0; i < this.remoteResources.size(); ++i) {
            if (this.status != 7) {
                return false;
            }
            resource = (EnlistedRemoteResource)this.remoteResources.get(i);
            try {
                int vote = ((EnlistedRemoteResource)resource).prepare();
                if (this.trace) {
                    strVote = vote == 5 ? "OK" : (vote == 4 ? "READONLY" : "ROLLBACK");
                    log.trace("Remote resource voted " + strVote);
                }
                if (vote == 5) {
                    readOnly = false;
                    continue;
                }
                if (vote == 4) continue;
                if (this.trace) {
                    log.trace("prepareResources got a rollback vote from a remote resource, tx=" + this.toString() + ", resource=" + resource, new Exception());
                }
                this.status = 1;
                return false;
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace("Exception in prepareResources, tx=" + this.toString(), e);
                }
                if (e instanceof HeuristicMixedException) {
                    this.gotHeuristic(resource, 5);
                } else if (e instanceof HeuristicHazardException) {
                    this.gotHeuristic(resource, 8);
                }
                this.cause = e;
                this.status = 1;
            }
        }
        if (this.status != 7) {
            return false;
        }
        if (this.lastResource != null) {
            try {
                this.lastResource.prepareLastResource();
                this.lastResource.commit(false);
            }
            catch (XAException e) {
                if (this.trace) {
                    log.trace("prepareResources got XAException when committing last resource, tx=" + this.toString(), e);
                }
                this.logXAException(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 8: {
                        this.gotHeuristic(this.lastResource, e.errorCode);
                    }
                }
                this.status = 1;
                this.cause = e;
                return false;
            }
            catch (Throwable t) {
                if (this.trace) {
                    log.trace("unhandled throwable in prepareResources, tx=" + this.toString(), t);
                }
                this.status = 1;
                this.cause = t;
                return false;
            }
        }
        if (this.status != 7) {
            return false;
        }
        this.status = 2;
        return readOnly;
    }

    private void commitResources(boolean onePhase) {
        this.status = 8;
        this.doCommitResources(onePhase);
        if (this.xaResourcesToRetry > 0 || this.remoteResourcesToRetry > 0) {
            int retryLimit = TxManager.getInstance().getCompletionRetryLimit();
            for (int n = 0; n < retryLimit && (this.xaResourcesToRetry > 0 || this.remoteResourcesToRetry > 0); ++n) {
                this.sleep(TxManager.getInstance().getCompletionRetryTimeoutMillis());
                this.doCommitResources(onePhase);
            }
        }
        this.checkCommitCompletion();
    }

    private void doCommitResources(boolean onePhase) {
        EnlistedResource resource;
        int i;
        this.xaResourcesToRetry = 0;
        this.remoteResourcesToRetry = 0;
        block16: for (i = 0; i < this.xaResources.size(); ++i) {
            if (this.status != 8) {
                return;
            }
            resource = (EnlistedXAResource)this.xaResources.get(i);
            if (!onePhase && this.lastResource == resource) continue;
            try {
                ((EnlistedXAResource)resource).commit(onePhase);
                continue;
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 8: {
                        this.gotHeuristic(resource, e.errorCode);
                        if (!onePhase) continue block16;
                        this.status = 1;
                        break;
                    }
                    case -3: {
                        this.gotHeuristic(null, 6);
                        if (!onePhase) continue block16;
                        this.status = 1;
                        break;
                    }
                    case -7: 
                    case 4: {
                        if (onePhase) {
                            this.status = 1;
                            break;
                        }
                        ++this.xaResourcesToRetry;
                        break;
                    }
                    default: {
                        this.cause = e;
                        if (onePhase) {
                            this.status = 1;
                            break;
                        }
                        log.warn("Could not recover from unexpected XAException: tx=" + this.toString() + " errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (t instanceof RecoveryTestingException) {
                    throw (RecoveryTestingException)t;
                }
                if (!this.trace) continue;
                log.trace("Unhandled throwable in doCommitResources " + this.toString(), t);
            }
        }
        for (i = 0; i < this.remoteResources.size(); ++i) {
            if (this.status != 8) {
                return;
            }
            resource = (EnlistedRemoteResource)this.remoteResources.get(i);
            try {
                ((EnlistedRemoteResource)resource).commit(onePhase);
                continue;
            }
            catch (TransactionRolledbackException e) {
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                if (onePhase) {
                    this.status = 1;
                    continue;
                }
                this.gotHeuristic(null, 6);
                continue;
            }
            catch (HeuristicRollbackException e) {
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                this.gotHeuristic(resource, 6);
                if (!onePhase) continue;
                this.status = 1;
                continue;
            }
            catch (HeuristicMixedException e) {
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                this.gotHeuristic(resource, 5);
                if (!onePhase) continue;
                this.status = 1;
                continue;
            }
            catch (HeuristicHazardException e) {
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                this.gotHeuristic(resource, 8);
                if (!onePhase) continue;
                this.status = 1;
                continue;
            }
            catch (TransactionNotPreparedException e) {
                this.cause = e;
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                if (onePhase) {
                    this.status = 1;
                    continue;
                }
                log.warn("Could not recover from unexpected exception in doCommitResources: tx=" + this.toString() + " exception=" + e);
                continue;
            }
            catch (NoSuchObjectException e) {
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                if (onePhase) {
                    this.status = 1;
                    continue;
                }
                log.warn("Ignoring NoSuchObjectException in doCommitResources:  tx=" + this.toString() + " exception=" + e);
                continue;
            }
            catch (RemoteException e) {
                if (this.trace) {
                    log.trace("Exception in doCommitResources, tx=" + this.toString(), e);
                }
                if (onePhase) {
                    this.status = 1;
                    continue;
                }
                ++this.remoteResourcesToRetry;
            }
        }
    }

    private void commitXAResourcesAfterTimeout() {
        this.xaRetryTimeout = TimeoutFactory.createTimeout(System.currentTimeMillis() + (long)TxManager.getInstance().getXARetryTimeoutMillis(), new TimeoutTarget(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timedOut(Timeout timeout) {
                if (TransactionImpl.this.trace) {
                    log.trace("XA retry timeout expired for tx=" + TransactionImpl.this.toString() + ", retrying commit on XAResources");
                }
                TransactionImpl.this.lock();
                try {
                    TransactionImpl.this.retryCommitXAResources();
                    if (TransactionImpl.this.xaResourcesToRetry > 0) {
                        TransactionImpl.this.xaRetryTimeout = TimeoutFactory.createTimeout(System.currentTimeMillis() + (long)TxManager.getInstance().getXARetryTimeoutMillis(), this);
                    } else if (TransactionImpl.this.remoteResourcesToRetry == 0 && TransactionImpl.this.heuristicCode == 0) {
                        TransactionImpl.this.completeTransaction();
                    }
                }
                finally {
                    TransactionImpl.this.unlock();
                }
            }
        });
    }

    private void retryCommitXAResources() {
        if (this.trace) {
            log.trace("Retrying commit XA resources, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status) + ", xaResourcesToRetry=" + this.xaResourcesToRetry);
        }
        this.xaResourcesToRetry = 0;
        for (int i = 0; i < this.xaResources.size(); ++i) {
            EnlistedXAResource resource = (EnlistedXAResource)this.xaResources.get(i);
            if (this.lastResource == resource) continue;
            try {
                resource.commit(false);
                continue;
            }
            catch (XAException e) {
                this.logXAException(e);
                switch (e.errorCode) {
                    case 5: 
                    case 6: 
                    case 8: {
                        this.gotHeuristic(resource, e.errorCode);
                        break;
                    }
                    case -3: {
                        this.gotHeuristic(null, 6);
                        break;
                    }
                    case -7: 
                    case 4: {
                        ++this.xaResourcesToRetry;
                        break;
                    }
                    default: {
                        log.warn("Could not recover from unexpected XAException: tx=" + this.toString() + " errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                        break;
                    }
                }
                continue;
            }
            catch (Throwable t) {
                if (t instanceof RecoveryTestingException) {
                    throw (RecoveryTestingException)t;
                }
                if (!this.trace) continue;
                log.trace("unhandled throwable in retryCommitXAResources " + this, t);
            }
        }
        if (this.trace) {
            log.trace("Finished retrying commit XA resources, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status) + ", xaResourcesToRetry=" + this.xaResourcesToRetry);
        }
        this.checkCommitCompletion();
    }

    private void retryCommitRemoteResources() {
        if (this.trace) {
            log.trace("Retrying commit remote resources, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status) + ", " + this.remoteResources.size() + " remote resources");
        }
        this.remoteResourcesToRetry = 0;
        for (int i = 0; i < this.remoteResources.size(); ++i) {
            EnlistedRemoteResource resource = (EnlistedRemoteResource)this.remoteResources.get(i);
            try {
                resource.commit(false);
                continue;
            }
            catch (HeuristicRollbackException e) {
                if (this.trace) {
                    log.trace("Exception in retryCommitRemoteResources, tx=" + this.toString(), e);
                }
                this.gotHeuristic(resource, 6);
                continue;
            }
            catch (HeuristicMixedException e) {
                if (this.trace) {
                    log.trace("Exception in retryCommitRemoteResources, tx=" + this.toString(), e);
                }
                this.gotHeuristic(resource, 5);
                continue;
            }
            catch (HeuristicHazardException e) {
                if (this.trace) {
                    log.trace("Exception in retryCommitRemoteResources, tx=" + this.toString(), e);
                }
                this.gotHeuristic(resource, 8);
                continue;
            }
            catch (TransactionNotPreparedException e) {
                this.cause = e;
                if (this.trace) {
                    log.trace("Exception in retryCommitRemoteResources, tx=" + this.toString(), e);
                }
                log.warn("Could not recover from unexpected exception in retryCommitRemoteResources: tx=" + this.toString() + " exception=" + e);
                continue;
            }
            catch (NoSuchObjectException e) {
                if (this.trace) {
                    log.trace("Exception in retryCommitRemoteResources, tx=" + this.toString(), e);
                }
                log.warn("Ignoring NoSuchObjectException in retryCommitRemoteResources: tx=" + this.toString() + " exception=" + e);
                continue;
            }
            catch (RemoteException e) {
                if (this.trace) {
                    log.trace("Exception in retryCommitRemoteResources, tx=" + this.toString(), e);
                }
                ++this.remoteResourcesToRetry;
            }
        }
        if (this.trace) {
            log.trace("Finished retrying commit remote resources, tx=" + this.toString() + ", status=" + TxUtils.getStatusAsString(this.status) + ", remoteResourcesToRetry=" + this.remoteResourcesToRetry + " of " + this.remoteResources.size() + " remote resources");
        }
        this.checkCommitCompletion();
    }

    private void checkCommitCompletion() {
        if (this.status != 8) {
            return;
        }
        this.consolidateHeuristics();
        if (this.xaResourcesToRetry == 0 && this.remoteResourcesToRetry == 0) {
            this.status = 3;
            if (this.heuristicHazard || this.heuristicCode != 0) {
                this.heuristicHazard = false;
                RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
                if (logger != null) {
                    logger.saveHeuristicStatus(this.xid.getLocalIdValue(), this.foreignTx, this.xid.getFormatId(), this.xid.getGlobalTransactionId(), this.inboundBranchQualifier, this.status, this.heuristicCode, this.heuristicHazard, this.getXAResourceHeuristics(), this.getRemoteResourceHeuristics());
                }
                if (!this.foreignTx && !TxManager.getInstance().isRootBranchRemembersHeuristicDecisions() && this.forgetResources() && logger != null) {
                    long localId = this.xid.getLocalIdValue();
                    logger.clearHeuristicStatus(localId);
                    if (this.completionHandler != null) {
                        this.completionHandler.handleTxCompletion(localId);
                    }
                }
            } else if (this.completionHandler != null) {
                this.completionHandler.handleTxCompletion(this.xid.getLocalIdValue());
            }
        } else if (!this.heuristicHazard) {
            this.heuristicHazard = true;
            RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
            if (logger != null) {
                logger.saveHeuristicStatus(this.xid.getLocalIdValue(), this.foreignTx, this.xid.getFormatId(), this.xid.getGlobalTransactionId(), this.inboundBranchQualifier, this.status, this.heuristicCode, this.heuristicHazard, this.getXAResourceHeuristics(), this.getRemoteResourceHeuristics());
            }
            if (!this.foreignTx && !TxManager.getInstance().isRootBranchRemembersHeuristicDecisions()) {
                this.forgetResources();
            }
        }
    }

    private void rollbackResourcesAndCompleteTransaction() {
        this.status = 9;
        this.doRollbackResources();
        if (this.xaResourcesToRetry > 0 || this.remoteResourcesToRetry > 0) {
            int retryLimit = TxManager.getInstance().getCompletionRetryLimit();
            for (int n = 0; n < retryLimit && (this.xaResourcesToRetry > 0 || this.remoteResourcesToRetry > 0); ++n) {
                this.sleep(TxManager.getInstance().getCompletionRetryTimeoutMillis());
                this.doRollbackResources();
            }
        }
        if (this.xaResourcesToRetry == 0 && this.remoteResourcesToRetry == 0) {
            this.status = 4;
            if (this.consolidateHeuristics() != 0 || this.heuristicHazard) {
                this.heuristicHazard = false;
                RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
                if (logger != null) {
                    logger.saveHeuristicStatus(this.xid.getLocalIdValue(), this.foreignTx, this.xid.getFormatId(), this.xid.getGlobalTransactionId(), this.inboundBranchQualifier, this.status, this.heuristicCode, this.heuristicHazard, this.getXAResourceHeuristics(), this.getRemoteResourceHeuristics());
                }
                if (!this.foreignTx && !TxManager.getInstance().isRootBranchRemembersHeuristicDecisions() && this.forgetResources() && logger != null) {
                    long localId = this.xid.getLocalIdValue();
                    logger.clearHeuristicStatus(localId);
                }
            } else {
                this.completeTransaction();
            }
        } else {
            if (!this.heuristicHazard) {
                this.heuristicHazard = true;
                this.consolidateHeuristics();
                RecoveryLogger logger = TxManager.getInstance().getRecoveryLogger();
                if (logger != null) {
                    logger.saveHeuristicStatus(this.xid.getLocalIdValue(), this.foreignTx, this.xid.getFormatId(), this.xid.getGlobalTransactionId(), this.inboundBranchQualifier, this.status, this.heuristicCode, this.heuristicHazard, this.getXAResourceHeuristics(), this.getRemoteResourceHeuristics());
                }
            }
            if (this.xaResourcesToRetry > 0) {
                this.rollbackXAResourcesAfterTimeout();
            }
        }
    }

    private void doRollbackResources() {
        EnlistedResource resource;
        int i;
        this.xaResourcesToRetry = 0;
        this.remoteResourcesToRetry = 0;
        block11: for (i = 0; i < this.xaResources.size(); ++i) {
            block14: {
                resource = (EnlistedXAResource)this.xaResources.get(i);
                try {
                    ((EnlistedXAResource)resource).rollback();
                }
                catch (XAException e) {
                    this.logXAException(e);
                    switch (e.errorCode) {
                        case 5: 
                        case 7: 
                        case 8: {
                            this.gotHeuristic(resource, e.errorCode);
                            continue block11;
                        }
                        default: {
                            this.cause = e;
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    if (t instanceof RecoveryTestingException) {
                        throw (RecoveryTestingException)t;
                    }
                    if (!this.trace) break block14;
                    log.trace("unhandled throwable in doRollbackResources " + this, t);
                }
            }
            if (((EnlistedXAResource)resource).getState() != 5) continue;
            ++this.xaResourcesToRetry;
        }
        for (i = 0; i < this.remoteResources.size(); ++i) {
            resource = (EnlistedRemoteResource)this.remoteResources.get(i);
            try {
                ((EnlistedRemoteResource)resource).rollback();
                continue;
            }
            catch (HeuristicCommitException e) {
                this.gotHeuristic(resource, 7);
                continue;
            }
            catch (HeuristicMixedException e) {
                this.gotHeuristic(resource, 5);
                continue;
            }
            catch (HeuristicHazardException e) {
                this.gotHeuristic(resource, 8);
                continue;
            }
            catch (RemoteException e) {
                ++this.remoteResourcesToRetry;
                if (!this.trace) continue;
                log.trace("Ignoring exception in remote resource rollback, tx=" + this.toString(), e);
            }
        }
    }

    private void rollbackXAResourcesAfterTimeout() {
        this.xaRetryTimeout = TimeoutFactory.createTimeout(System.currentTimeMillis() + (long)TxManager.getInstance().getXARetryTimeoutMillis(), new TimeoutTarget(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void timedOut(Timeout timeout) {
                if (TransactionImpl.this.trace) {
                    log.trace("XA retry timeout expired for tx=" + TransactionImpl.this.toString() + ", retrying rollback on XAResources");
                }
                TransactionImpl.this.lock();
                try {
                    TransactionImpl.this.retryRollbackXAResources();
                    if (TransactionImpl.this.xaResourcesToRetry > 0) {
                        TransactionImpl.this.xaRetryTimeout = TimeoutFactory.createTimeout(System.currentTimeMillis() + (long)TxManager.getInstance().getXARetryTimeoutMillis(), this);
                    } else if (TransactionImpl.this.remoteResourcesToRetry == 0 && TransactionImpl.this.heuristicCode == 0) {
                        TransactionImpl.this.completeTransaction();
                    }
                }
                finally {
                    TransactionImpl.this.unlock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelXARetryTimeout() {
        if (this.xaRetryTimeout != null) {
            Timeout rt = this.xaRetryTimeout;
            this.xaRetryTimeout = null;
            this.unlock();
            try {
                rt.cancel();
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace("failed to cancel XA retry timeout, tx=" + this.toString(), e);
                }
            }
            finally {
                this.lock();
            }
        }
    }

    private int[] getXAResourceHeuristics() {
        if (this.xaResourcesWithHeuristicDecisions == null) {
            return null;
        }
        int[] heurCodes = new int[this.xaResourcesWithHeuristicDecisions.size()];
        for (int i = 0; i < this.xaResourcesWithHeuristicDecisions.size(); ++i) {
            EnlistedResource resource = (EnlistedResource)this.xaResourcesWithHeuristicDecisions.get(i);
            heurCodes[i] = resource.getHeuristicCode();
        }
        return heurCodes;
    }

    private HeuristicStatus[] getRemoteResourceHeuristics() {
        if (this.remoteResourcesWithHeuristicDecisions == null) {
            return null;
        }
        HeuristicStatus[] s = new HeuristicStatus[this.remoteResourcesWithHeuristicDecisions.size()];
        for (int i = 0; i < this.remoteResourcesWithHeuristicDecisions.size(); ++i) {
            EnlistedRemoteResource resource = (EnlistedRemoteResource)this.remoteResourcesWithHeuristicDecisions.get(i);
            s[i] = new HeuristicStatus(resource.getHeuristicCode(), TransactionImpl.resourceToString(resource.getRemoteResource()));
        }
        return s;
    }

    private void retryRollbackXAResources() {
        this.xaResourcesToRetry = 0;
        block6: for (int i = 0; i < this.xaResources.size(); ++i) {
            EnlistedXAResource resource;
            block9: {
                resource = (EnlistedXAResource)this.xaResources.get(i);
                try {
                    resource.rollback();
                }
                catch (XAException e) {
                    this.logXAException(e);
                    switch (e.errorCode) {
                        case 5: 
                        case 7: 
                        case 8: {
                            this.gotHeuristic(resource, e.errorCode);
                            continue block6;
                        }
                        default: {
                            this.cause = e;
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    if (t instanceof RecoveryTestingException) {
                        throw (RecoveryTestingException)t;
                    }
                    if (!this.trace) break block9;
                    log.trace("unhandled throwable in retryRollbackXAResources " + this, t);
                }
            }
            if (resource.getState() != 5) continue;
            ++this.xaResourcesToRetry;
        }
        if (this.xaResourcesToRetry == 0 && this.remoteResourcesToRetry == 0) {
            this.status = 4;
        }
    }

    private boolean forgetResources() {
        EnlistedResource resource;
        int i;
        boolean success = true;
        if (this.xaResourcesWithHeuristicDecisions != null) {
            for (i = 0; i < this.xaResourcesWithHeuristicDecisions.size(); ++i) {
                resource = (EnlistedResource)this.xaResourcesWithHeuristicDecisions.get(i);
                resource.forget();
                if (resource.getState() == 6) continue;
                success = false;
            }
        }
        if (this.remoteResourcesWithHeuristicDecisions != null) {
            for (i = 0; i < this.remoteResourcesWithHeuristicDecisions.size(); ++i) {
                resource = (EnlistedResource)this.remoteResourcesWithHeuristicDecisions.get(i);
                resource.forget();
                if (resource.getState() == 6) continue;
                success = false;
            }
        }
        return success;
    }

    private Xid createXidBranch() {
        long branchId = ++this.lastBranchId;
        return xidFactory.newBranch(this.xid, branchId);
    }

    private int getCommitStrategy() {
        int remoteResourceCount;
        int xaResourceCount = this.xaResources.size();
        int resourceCount = xaResourceCount + (remoteResourceCount = this.remoteResources.size());
        if (resourceCount == 0) {
            return 0;
        }
        if (resourceCount == 1) {
            return 1;
        }
        if (remoteResourceCount > 0) {
            return 2;
        }
        for (int i = 1; i < xaResourceCount; ++i) {
            EnlistedXAResource resource = (EnlistedXAResource)this.xaResources.get(i);
            if (!resource.isResourceManager()) continue;
            return 2;
        }
        return 1;
    }

    private String[] getStringfiedRemoteResourcesThatVotedCommit() {
        ArrayList<String> resourcesThatVotedCommit = new ArrayList<String>(this.remoteResources.size());
        for (int i = 0; i < this.remoteResources.size(); ++i) {
            EnlistedRemoteResource enlistedRemoteResource = (EnlistedRemoteResource)this.remoteResources.get(i);
            if (enlistedRemoteResource.getState() != 5) continue;
            Resource r = enlistedRemoteResource.getRemoteResource();
            resourcesThatVotedCommit.add(TransactionImpl.resourceToString(r));
        }
        return resourcesThatVotedCommit.toArray(new String[resourcesThatVotedCommit.size()]);
    }

    private void checkWork() {
        if (this.work != null) {
            throw new IllegalStateException("Work still outstanding: " + this.work + ", tx=" + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long millis) {
        try {
            this.unlock();
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.lock();
        }
    }

    static {
        timeoutFactory = TimeoutFactory.getSingleton();
        dtmCoordinatorFactory = null;
        dtmResourceFactory = null;
        otsResourceFactory = null;
        otsContextFactory = null;
        interpositionEnabled = false;
        dtmStrRemoteRefConverter = null;
        otsStrRemoteRefConverter = null;
    }

    private class EnlistedRemoteResource
    implements EnlistedResource {
        private Resource remoteResource;
        private int resourceState;
        private int heurCode;

        public EnlistedRemoteResource(Resource remoteResource) {
            this.remoteResource = remoteResource;
            this.resourceState = 0;
            this.heurCode = 0;
        }

        public EnlistedRemoteResource(Resource remoteResource, boolean prepared) {
            this.remoteResource = remoteResource;
            this.resourceState = prepared ? 5 : 0;
            this.heurCode = 0;
        }

        public EnlistedRemoteResource(Resource remoteResource, boolean committed, int heurCode) {
            this.remoteResource = remoteResource;
            this.resourceState = committed ? 7 : 8;
            this.heurCode = heurCode;
        }

        public Resource getRemoteResource() {
            return this.remoteResource;
        }

        public int getState() {
            return this.resourceState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int prepare() throws RemoteException, TransactionAlreadyPreparedException, HeuristicMixedException, HeuristicHazardException {
            Vote vote = null;
            TransactionImpl.this.unlock();
            try {
                vote = this.remoteResource.prepare();
            }
            finally {
                TransactionImpl.this.lock();
            }
            this.resourceState = vote == Vote.COMMIT ? 5 : (vote == Vote.READONLY ? 4 : 8);
            return this.resourceState;
        }

        public void commit(boolean onePhase) throws RemoteException, TransactionNotPreparedException, HeuristicRollbackException, HeuristicMixedException, HeuristicHazardException {
            if (TransactionImpl.this.trace) {
                log.trace("Committing resource " + this.remoteResource + " state=" + this.resourceState);
            }
            if (!onePhase && this.resourceState != 5) {
                return;
            }
            TransactionImpl.this.unlock();
            try {
                if (onePhase) {
                    this.remoteResource.commitOnePhase();
                } else {
                    this.remoteResource.commit();
                }
                TransactionImpl.this.committedResources++;
                this.resourceState = 7;
            }
            catch (TransactionRolledbackException e) {
                TransactionImpl.this.rolledbackResources++;
                this.resourceState = 8;
                throw e;
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (TransactionNotPreparedException e) {
                this.resourceState = 9;
                throw e;
            }
            catch (HeuristicRollbackException e) {
                TransactionImpl.this.rolledbackResources++;
                this.resourceState = 8;
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.resourceState = 8;
                throw e;
            }
            catch (HeuristicHazardException e) {
                this.resourceState = 8;
                throw e;
            }
            finally {
                TransactionImpl.this.lock();
            }
        }

        public void rollback() throws RemoteException, HeuristicCommitException, HeuristicMixedException, HeuristicHazardException {
            if (this.resourceState == 4 || this.resourceState == 8 || this.resourceState == 6) {
                return;
            }
            TransactionImpl.this.unlock();
            try {
                this.remoteResource.rollback();
                TransactionImpl.this.rolledbackResources++;
                this.resourceState = 8;
            }
            catch (TransactionRolledbackException e) {
                TransactionImpl.this.rolledbackResources++;
                this.resourceState = 8;
                throw e;
            }
            catch (RemoteException e) {
                throw e;
            }
            catch (HeuristicCommitException e) {
                TransactionImpl.this.committedResources++;
                this.resourceState = 8;
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.resourceState = 8;
                throw e;
            }
            catch (HeuristicHazardException e) {
                this.resourceState = 8;
                throw e;
            }
            finally {
                TransactionImpl.this.lock();
            }
        }

        public void remember(int heuristicCode) {
            this.heurCode = heuristicCode;
            if (TransactionImpl.this.remoteResourcesWithHeuristicDecisions == null) {
                TransactionImpl.this.remoteResourcesWithHeuristicDecisions = new ArrayList();
            }
            TransactionImpl.this.remoteResourcesWithHeuristicDecisions.add(this);
        }

        public int getHeuristicCode() {
            return this.heurCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forget() {
            TransactionImpl.this.unlock();
            if (TransactionImpl.this.trace) {
                log.trace("Forget: " + this.remoteResource);
            }
            try {
                this.remoteResource.forget();
                this.resourceState = 6;
            }
            catch (NoSuchObjectException e) {
                if (TransactionImpl.this.trace) {
                    log.trace("NoSuchObjectException in forget: remoteResource=" + this.remoteResource + "\nAssuming that the resource has " + "been previously forgotten.", e);
                }
            }
            catch (RemoteException e) {
                if (TransactionImpl.this.trace) {
                    log.trace("RemoteException in forget: remoteResource=" + this.remoteResource + "\nThe resource still needs to be " + "forgotten.", e);
                }
            }
            finally {
                TransactionImpl.this.lock();
            }
            this.resourceState = 6;
        }
    }

    private class EnlistedXAResource
    implements EnlistedResource {
        private XAResource xaResource;
        private int resourceState;
        private EnlistedXAResource resourceSameRM;
        private Xid resourceXid;
        private int heurCode;
        private XAResourceAccess xaResourceAccess = null;

        public EnlistedXAResource(XAResource xaResource, Xid resourceXid, EnlistedXAResource resourceSameRM) {
            this.xaResource = xaResource;
            this.resourceXid = resourceXid;
            this.resourceSameRM = resourceSameRM;
            this.resourceState = 0;
            this.heurCode = 0;
        }

        public EnlistedXAResource(XAWork xaWork) {
            this.xaResource = xaWork.res;
            this.resourceXid = xaWork.xid;
            this.xaResourceAccess = xaWork.xaResourceAccess;
            this.resourceSameRM = null;
            this.resourceState = 5;
            this.heurCode = 0;
        }

        public EnlistedXAResource(XAResource xaResource, Xid resourceXid, boolean committed) {
            this.xaResource = xaResource;
            this.resourceXid = resourceXid;
            this.resourceSameRM = null;
            this.resourceState = committed ? 7 : 8;
            this.heurCode = 4;
        }

        public XAResource getXAResource() {
            return this.xaResource;
        }

        public Xid getXid() {
            return this.resourceXid;
        }

        public int getState() {
            return this.resourceState;
        }

        public boolean isEnlisted() {
            return this.resourceState == 1;
        }

        public boolean isResourceManager() {
            return this.resourceSameRM == null;
        }

        public boolean isResourceManager(XAResource xaRes) throws XAException {
            return this.resourceSameRM == null && xaRes.isSameRM(this.xaResource);
        }

        public boolean isDelisted(XAResource xaRes) throws XAException {
            return this.resourceState == 3 && !this.xaResource.isSameRM(xaRes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean startResource() throws XAException {
            int flags = 0x200000;
            if (this.resourceSameRM == null) {
                switch (this.resourceState) {
                    case 0: {
                        flags = 0;
                        break;
                    }
                    case 2: {
                        flags = 0x8000000;
                        break;
                    }
                    default: {
                        if (!TransactionImpl.this.trace) break;
                        log.trace("Unhandled resource state: " + this.resourceState + " (not RS_NEW or RS_SUSPENDED, using TMJOIN flags)");
                    }
                }
            }
            if (TransactionImpl.this.trace) {
                log.trace("startResource(" + xidFactory.toString(this.resourceXid) + ") entered: " + this.xaResource.toString() + " flags=" + flags);
            }
            TransactionImpl.this.unlock();
            try {
                try {
                    this.xaResource.start(this.resourceXid, flags);
                }
                catch (XAException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (TransactionImpl.this.trace) {
                        log.trace("unhandled throwable error in startResource", t);
                    }
                    TransactionImpl.this.status = 1;
                    boolean bl = false;
                    TransactionImpl.this.lock();
                    if (TransactionImpl.this.trace) {
                        log.trace("startResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flags=" + flags);
                    }
                    return bl;
                }
                this.resourceState = 1;
            }
            finally {
                TransactionImpl.this.lock();
                if (TransactionImpl.this.trace) {
                    log.trace("startResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flags=" + flags);
                }
            }
            return true;
        }

        public boolean delistResource(XAResource xaRes, int flag) throws XAException {
            if (this.isDelisted(xaRes)) {
                log.warn("Resource already delisted.  tx=" + TransactionImpl.this.toString());
                return false;
            }
            this.endResource(flag);
            return true;
        }

        public void endResource() throws XAException {
            if (this.resourceState == 1 || this.resourceState == 2) {
                if (TransactionImpl.this.trace) {
                    log.trace("endresources(" + this.xaResource + "): state=" + this.resourceState);
                }
                this.endResource(0x4000000);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endResource(int flag) throws XAException {
            if (TransactionImpl.this.trace) {
                log.trace("endResource(" + xidFactory.toString(this.resourceXid) + ") entered: " + this.xaResource.toString() + " flag=" + flag);
            }
            TransactionImpl.this.unlock();
            try {
                try {
                    this.xaResource.end(this.resourceXid, flag);
                }
                catch (XAException e) {
                    throw e;
                }
                catch (Throwable t) {
                    if (TransactionImpl.this.trace) {
                        log.trace("unhandled throwable error in endResource", t);
                    }
                    TransactionImpl.this.status = 1;
                    this.resourceState = 3;
                    TransactionImpl.this.lock();
                    if (TransactionImpl.this.trace) {
                        log.trace("endResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flag=" + flag);
                    }
                    return;
                }
                if (flag == 0x2000000) {
                    this.resourceState = 2;
                } else {
                    if (flag == 0x20000000) {
                        TransactionImpl.this.status = 1;
                    }
                    this.resourceState = 3;
                }
            }
            finally {
                TransactionImpl.this.lock();
                if (TransactionImpl.this.trace) {
                    log.trace("endResource(" + xidFactory.toString(this.resourceXid) + ") leaving: " + this.xaResource.toString() + " flag=" + flag);
                }
            }
        }

        public void remember(int heuristicCode) {
            this.heurCode = heuristicCode;
            if (TransactionImpl.this.xaResourcesWithHeuristicDecisions == null) {
                TransactionImpl.this.xaResourcesWithHeuristicDecisions = new ArrayList();
            }
            TransactionImpl.this.xaResourcesWithHeuristicDecisions.add(this);
        }

        public int getHeuristicCode() {
            return this.heurCode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forget() {
            TransactionImpl.this.unlock();
            if (TransactionImpl.this.trace) {
                log.trace("Forget: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid));
            }
            try {
                this.xaResource.forget(this.resourceXid);
                this.resourceState = 6;
            }
            catch (XAException xae) {
                TransactionImpl.this.logXAException(xae);
                TransactionImpl.this.cause = xae;
                if (xae.errorCode == -4) {
                    if (TransactionImpl.this.trace) {
                        log.trace("XAER_NOTA in forget: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid) + "\nAssuming that the xid has been previously " + "forgotten.", xae);
                    }
                    this.resourceState = 6;
                }
            }
            finally {
                TransactionImpl.this.lock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int prepare() throws XAException {
            block11: {
                TransactionImpl.this.unlock();
                if (TransactionImpl.this.trace) {
                    log.trace("Prepare: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid));
                }
                try {
                    int vote = this.xaResource.prepare(this.resourceXid);
                    if (vote == 0) {
                        this.resourceState = 5;
                    } else if (vote == 3) {
                        this.resourceState = 4;
                    }
                }
                catch (XAException e) {
                    if (e.errorCode >= 100 && e.errorCode <= 107) {
                        if (TransactionImpl.this.trace) {
                            log.trace("Got rollback vote from XAResource " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid) + ", tx=" + TransactionImpl.this.toString() + ", errorCode=" + TxUtils.getXAErrorCodeAsString(e.errorCode), e);
                        }
                        this.resourceState = 8;
                        break block11;
                    }
                    throw e;
                }
                finally {
                    TransactionImpl.this.lock();
                }
            }
            return this.resourceState;
        }

        public void prepareLastResource() throws XAException {
            this.resourceState = 5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void commit(boolean onePhase) throws XAException {
            if (!onePhase && this.resourceState != 5) {
                return;
            }
            if (this.resourceSameRM != null) {
                return;
            }
            TransactionImpl.this.unlock();
            if (TransactionImpl.this.trace) {
                log.trace("Commit: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid) + " onePhase=" + onePhase);
            }
            try {
                this.xaResource.commit(this.resourceXid, onePhase);
                TransactionImpl.this.committedResources++;
                this.resourceState = 7;
                return;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case 7: {
                        TransactionImpl.this.logXAException(e);
                        if (TransactionImpl.this.trace) {
                            log.trace("Ignoring XAException.XA_HEURCOM in XAResource.commit: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid) + " onePhase=" + onePhase);
                        }
                        this.forget();
                        TransactionImpl.this.committedResources++;
                        this.resourceState = 7;
                        return;
                    }
                    case -3: 
                    case 6: {
                        TransactionImpl.this.rolledbackResources++;
                    }
                    case 5: 
                    case 8: {
                        this.resourceState = 8;
                        throw e;
                    }
                    case -7: 
                    case 4: {
                        throw e;
                    }
                    default: {
                        this.resourceState = 9;
                        throw e;
                    }
                }
            }
            finally {
                if (this.xaResourceAccess != null && this.resourceState != 5) {
                    this.xaResourceAccess.release();
                }
                TransactionImpl.this.lock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void rollback() throws XAException {
            if (this.resourceState == 4 || this.resourceState == 8 || this.resourceState == 6) {
                return;
            }
            if (this.resourceSameRM != null) {
                return;
            }
            TransactionImpl.this.unlock();
            if (TransactionImpl.this.trace) {
                log.trace("Rollback: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid));
            }
            try {
                this.xaResource.rollback(this.resourceXid);
                TransactionImpl.this.rolledbackResources++;
                this.resourceState = 8;
                return;
            }
            catch (XAException e) {
                switch (e.errorCode) {
                    case -3: {
                        if (TransactionImpl.this.trace) {
                            log.trace("Ignoring XAException.XAER_RMERR in XAResource.rollback: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid));
                        }
                        TransactionImpl.this.rolledbackResources++;
                        this.resourceState = 8;
                        return;
                    }
                    case 6: {
                        if (TransactionImpl.this.trace) {
                            log.trace("Ignoring XAException.XA_HEURRB in XAResource.rollback: " + this.xaResource + " xid=" + xidFactory.toString(this.resourceXid));
                        }
                        this.forget();
                        TransactionImpl.this.rolledbackResources++;
                        this.resourceState = 8;
                        return;
                    }
                    case 7: {
                        TransactionImpl.this.committedResources++;
                    }
                    case 5: 
                    case 8: {
                        this.resourceState = 8;
                        throw e;
                    }
                    case -7: 
                    case 4: {
                        throw e;
                    }
                    default: {
                        this.resourceState = 9;
                        throw e;
                    }
                }
            }
            finally {
                if (this.xaResourceAccess != null && this.resourceState != 5) {
                    this.xaResourceAccess.release();
                }
                TransactionImpl.this.lock();
            }
        }
    }

    private static interface EnlistedResource {
        public int getState();

        public void remember(int var1);

        public int getHeuristicCode();

        public void forget();
    }
}

