/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.deployers.spi.Deployment;
import org.jboss.deployers.spi.MainDeployer;
import org.jboss.deployment.IncompleteDeploymentException;
import org.jboss.deployment.scanner.VFSDeploymentScanner;
import org.jboss.net.protocol.URLLister;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.util.JBossObject;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.vfs.VFSFactory;
import org.jboss.vfs.spi.ReadOnlyVFS;
import org.jboss.vfs.spi.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentScannerImpl
extends JBossObject
implements VFSDeploymentScanner {
    private MainDeployer mainDeployer;
    private VFSFactory factory;
    private ProfileService ps;
    private Profile serverProfile;
    private ProfileKey profileKey;
    private URI serverHomeURI;
    private List<URI> uriList = Collections.synchronizedList(new ArrayList());
    private List<VirtualFile> vdfList = Collections.synchronizedList(new ArrayList());
    private URLLister.URLFilter filter;
    private boolean doRecursiveSearch = true;
    private int scanCount;
    private Set deployedSet = Collections.synchronizedSet(new HashSet());
    private IncompleteDeploymentException lastIncompleteDeploymentException;

    public void setMainDeployer(MainDeployer deployer) {
        this.mainDeployer = deployer;
        this.factory = this.mainDeployer.getVFSFactory();
    }

    @Override
    public VFSFactory getVFSFactory() {
        return this.factory;
    }

    @Override
    public void setVFSFactory(VFSFactory factory) {
        this.factory = factory;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public ProfileKey getProfileKey() {
        return this.profileKey;
    }

    public void setProfileKey(ProfileKey key) {
        this.profileKey = key;
    }

    @Override
    public long getScanPeriod() {
        return 0L;
    }

    @Override
    public boolean isScanEnabled() {
        return false;
    }

    @Override
    public void setScanEnabled(boolean flag) {
    }

    @Override
    public void setScanPeriod(long period) {
    }

    @Override
    public synchronized int getScanCount() {
        return this.scanCount;
    }

    @Override
    public synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    public void setURIs(String listspec) throws URISyntaxException, IOException {
        if (listspec == null) {
            throw new NullPointerException("listspec argument cannot be null");
        }
        LinkedList<URI> list = new LinkedList<URI>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urispec = stok.nextToken().trim();
            this.log.debug("Adding URI from spec: " + urispec);
            URI uri = this.makeURI(urispec);
            this.log.debug("URI: " + uri);
            list.add(uri);
        }
        this.setURIList(list);
    }

    public void setURIList(List<URI> list) throws IOException {
        if (list == null) {
            throw new NullPointerException("list argument cannot be null");
        }
        this.uriList.clear();
        for (int n = 0; n < list.size(); ++n) {
            URI uri = list.get(n);
            if (uri == null) {
                throw new IllegalArgumentException("list element[" + n + "] is null");
            }
            this.addURI(uri);
        }
        this.log.debug("URI list: " + this.uriList);
    }

    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void setFilter(String classname) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> filterClass = Thread.currentThread().getContextClassLoader().loadClass(classname);
        this.filter = (URLLister.URLFilter)filterClass.newInstance();
    }

    public String getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.getClass().getName();
    }

    public void setFilterInstance(URLLister.URLFilter filter) {
        this.filter = filter;
    }

    public URLLister.URLFilter getFilterInstance() {
        return this.filter;
    }

    public void addURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.uriList.add(uri)) {
            this.log.debug("Added URI: " + uri);
            if (this.factory != null) {
                URL rootURL = uri.toURL();
                ReadOnlyVFS vfs = this.factory.getVFS(rootURL);
                VirtualFile vf = vfs.resolveFile("");
                this.vdfList.add(vf);
            }
        }
    }

    public void removeURI(URI uri) throws IOException {
        boolean success;
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.factory != null) {
            VirtualFile vf = this.getVFforURI(uri);
            this.vdfList.remove(vf);
        }
        if (success = this.uriList.remove(uri)) {
            this.log.debug("Removed URI: " + uri);
        }
    }

    public boolean hasURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        return this.uriList.contains(uri);
    }

    public void start() throws Exception {
        if (this.factory != null) {
            this.vdfList.clear();
            for (URI uri : this.uriList) {
                VirtualFile vf = this.getVFforURI(uri);
                this.vdfList.add(vf);
            }
        }
        if (this.profileKey == null) {
            this.profileKey = new ProfileKey("default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void scan() throws Exception {
        VirtualFile vf;
        int i;
        if (this.vdfList == null) {
            throw new IllegalStateException("not initialized");
        }
        boolean trace = this.log.isTraceEnabled();
        this.lastIncompleteDeploymentException = null;
        if (trace) {
            this.log.trace("Scanning for new deployments");
        }
        LinkedList<VirtualFile> toDeployList = new LinkedList<VirtualFile>();
        List<VirtualFile> list = this.vdfList;
        synchronized (list) {
            for (VirtualFile virtualFile : this.vdfList) {
                if (virtualFile.isFile()) {
                    toDeployList.add(virtualFile);
                    continue;
                }
                if (!virtualFile.isDirectory()) continue;
                this.addDeployments(toDeployList, virtualFile);
            }
        }
        if (trace) {
            this.log.trace("toDeployList");
            Iterator i2 = toDeployList.iterator();
            while (i2.hasNext()) {
                this.log.trace(i2.next());
            }
        }
        LinkedList<VirtualFile> toRemoveList = new LinkedList<VirtualFile>();
        LinkedList<VirtualFile> toCheckForUpdateList = new LinkedList<VirtualFile>();
        Set set = this.deployedSet;
        synchronized (set) {
            for (VirtualFile deployedComponent : this.deployedSet) {
                if (toDeployList.contains(deployedComponent)) {
                    toCheckForUpdateList.add(deployedComponent);
                    continue;
                }
                toRemoveList.add(deployedComponent);
            }
        }
        for (VirtualFile deployedComponent : toRemoveList) {
            this.undeploy(deployedComponent);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(toCheckForUpdateList.size());
        for (VirtualFile deployedComponent : toCheckForUpdateList) {
            if (!this.isModified(deployedComponent)) continue;
            if (trace) {
                this.log.trace("Re-deploying " + deployedComponent);
            }
            arrayList.add(deployedComponent);
        }
        for (i = arrayList.size() - 1; i >= 0; --i) {
            vf = (VirtualFile)arrayList.get(i);
            this.undeploy(vf);
        }
        for (i = 0; i < arrayList.size(); ++i) {
            vf = (VirtualFile)arrayList.get(i);
            this.deploy(vf);
        }
        Iterator i3 = toDeployList.iterator();
        while (i3.hasNext()) {
            VirtualFile component3 = (VirtualFile)i3.next();
            if (!this.deployedSet.contains(component3)) {
                this.deploy(component3);
            }
            i3.remove();
        }
    }

    private URI makeURI(String urispec) throws URISyntaxException {
        urispec = StringPropertyReplacer.replaceProperties(urispec);
        return this.serverHomeURI.resolve(urispec);
    }

    private void addDeployments(List<VirtualFile> list, VirtualFile root) throws IOException {
        VirtualFile[] components = root.getChildren();
        for (int i = 0; i < components.length; ++i) {
            VirtualFile component = components[i];
            if (component.isFile()) {
                if (this.filter != null && !this.filter.accept(null, component.getName())) continue;
                list.add(component);
                continue;
            }
            if (!component.isDirectory()) continue;
            if (component.getName().indexOf(46) == -1 && this.doRecursiveSearch) {
                this.addDeployments(list, component);
                continue;
            }
            list.add(component);
        }
    }

    private void deploy(VirtualFile component) {
        if (this.ps == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Deploying: " + component);
        }
        Deployment deployment = null;
        try {
            URL componentUrl = component.toURL();
            Profile profile = this.ps.getProfile(this.profileKey);
            deployment = this.mainDeployer.parse(componentUrl);
            if (profile.getDeployment(deployment.getName()) == null) {
                profile.addDeployment(deployment);
            }
        }
        catch (MalformedURLException e) {
            this.log.warn("Cannot convert to URL", e);
            return;
        }
        catch (Exception e) {
            this.log.debug("Failed to deploy: " + component, e);
        }
        String watchPath = this.getWatchURL(deployment);
        VirtualFile watchComponent = null;
        long deployedLastModified = -1L;
        try {
            if (watchPath != null) {
                watchComponent = component.findChild(watchPath);
                deployedLastModified = watchComponent.getLastModified();
            } else {
                deployedLastModified = component.getLastModified();
            }
        }
        catch (IOException e) {
            this.log.warn(e);
        }
        if (!this.deployedSet.contains(component)) {
            this.deployedSet.add(component);
        }
    }

    private void undeploy(VirtualFile component) {
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Undeploying: " + component);
            }
            this.deployedSet.remove(component);
            URL componentUrl = component.toURL();
            Profile profile = this.ps.getProfile(this.profileKey);
            Deployment deployment = this.mainDeployer.parse(componentUrl);
            profile.removeDeployment(deployment.getName());
        }
        catch (Exception e) {
            this.log.error("Failed to undeploy: " + component, e);
        }
    }

    private String getWatchURL(Deployment deployment) {
        String watchPath = (String)((Object)deployment.getRootContext().getContextData().get(""));
        return watchPath;
    }

    public boolean isModified(VirtualFile component) {
        Object cc = null;
        long deployedLastModified = cc.deployedLastModified;
        long lastModified = cc.watchComponent != null ? cc.watchComponent.getLastModified() : component.getLastModified();
        return deployedLastModified != lastModified;
    }

    private VirtualFile getVFforURI(URI uri) throws IOException {
        VirtualFile vf = null;
        if (this.factory != null) {
            URL rootURL = uri.toURL();
            ReadOnlyVFS vfs = this.factory.getVFS(rootURL);
            vf = vfs.resolveFile("");
        }
        return vf;
    }

    private static class ComponentContext {
        public VirtualFile watchComponent;
        public long deployedLastModified;

        public ComponentContext(VirtualFile watchComponent, long deployedLastModified) {
            this.watchComponent = watchComponent;
            this.deployedLastModified = deployedLastModified;
        }
    }
}

