/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployment.DeploymentException;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.system.metadata.AbstractMetaDataVisitorNode;
import org.jboss.system.metadata.ServiceMetaDataVisitor;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.system.metadata.ServiceValueMetaData;
import org.jboss.system.microcontainer.LifecycleDependencyItem;
import org.jboss.system.microcontainer.ServiceControllerContext;

public class ServiceDependencyValueMetaData
extends AbstractMetaDataVisitorNode
implements ServiceValueMetaData {
    private String dependency;
    private ObjectName objectName;
    private String proxyType;

    public ServiceDependencyValueMetaData() {
    }

    public ServiceDependencyValueMetaData(String dependency) {
        this.setDependency(dependency);
    }

    public ServiceDependencyValueMetaData(String dependency, String proxyType) {
        this.setDependency(dependency);
        this.setProxyType(proxyType);
    }

    public String getDependency() {
        if (this.dependency == null) {
            return this.objectName.getCanonicalName();
        }
        return this.dependency;
    }

    public void setDependency(String dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException("Null dependency");
        }
        this.dependency = dependency;
        this.objectName = null;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this.objectName == null) {
            if (this.dependency.trim().length() == 0) {
                throw new MalformedObjectNameException("Missing object name in depends");
            }
            ObjectName name = new ObjectName(this.dependency);
            if (name.isPattern()) {
                throw new MalformedObjectNameException("ObjectName patterns are not allowed in depends: " + this.objectName);
            }
            this.objectName = new ObjectName(this.dependency);
            this.dependency = null;
        }
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("Null objectName");
        }
        this.objectName = objectName;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public Object getValue(ServiceValueContext valueContext) throws Exception {
        MBeanAttributeInfo attributeInfo = valueContext.getAttributeInfo();
        ClassLoader cl = valueContext.getClassloader();
        MBeanServer server = valueContext.getServer();
        ObjectName objectName = this.getObjectName();
        if (this.proxyType != null) {
            if (this.proxyType.equals("attribute")) {
                this.proxyType = attributeInfo.getType();
                if (this.proxyType == null) {
                    throw new DeploymentException("AttributeInfo for " + attributeInfo.getName() + " has no type");
                }
            }
            Class<?> proxyClass = cl.loadClass(this.proxyType);
            return MBeanProxyExt.create(proxyClass, objectName, server, true);
        }
        return objectName;
    }

    public void visit(ServiceMetaDataVisitor visitor) {
        ServiceControllerContext context = visitor.getControllerContext();
        Object name = context.getName();
        String other = this.dependency;
        try {
            other = this.getObjectName().getCanonicalName();
        }
        catch (MalformedObjectNameException ignored) {
            // empty catch block
        }
        visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.CREATE));
        visitor.addDependency(new LifecycleDependencyItem(name, other, ControllerState.START));
        visitor.visit(this);
    }
}

