/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.providers;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.security.mapping.MappingProvider;

public class OptionsRoleMappingProvider
implements MappingProvider {
    private static final Logger log = Logger.getLogger(OptionsRoleMappingProvider.class);
    private static final String REPLACE_ROLES_STRING = "replaceRoles";
    private static final String ROLES_MAP = "rolesMap";
    private Map options = null;
    private Properties roleMapProperties = null;
    private boolean REPLACE_ROLES = false;

    public void init(Map opt) {
        this.options = opt;
        if (this.options != null) {
            if (this.options.containsKey(REPLACE_ROLES_STRING)) {
                this.REPLACE_ROLES = "true".equalsIgnoreCase((String)this.options.get(REPLACE_ROLES_STRING));
            }
            if (this.options.containsKey(ROLES_MAP)) {
                this.roleMapProperties = (Properties)this.options.get(ROLES_MAP);
            }
        }
    }

    public Object performMapping(Map contextMap) {
        Group roles = (Group)contextMap.get("Roles");
        if (roles == null) {
            throw new IllegalArgumentException("Group called Roles not found");
        }
        Enumeration enumer = roles.members();
        while (enumer.hasMoreElements()) {
            Principal p = (Principal)enumer.nextElement();
            String name = p.getName();
            String commaSeparatedRoles = this.roleMapProperties.getProperty(name);
            if (commaSeparatedRoles == null) continue;
            String[] tokens = this.getRolesFromCommaSeparatedString(commaSeparatedRoles);
            int len = tokens != null ? tokens.length : 0;
            for (int i = 0; i < len; ++i) {
                if (this.REPLACE_ROLES) {
                    roles.removeMember(p);
                }
                roles.addMember(this.instantiatePrincipal(p.getClass(), tokens[i]));
            }
        }
        return roles;
    }

    private String[] getRolesFromCommaSeparatedString(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        int numTokens = st != null ? st.countTokens() : 0;
        String[] tokens = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            tokens[i] = st.nextToken();
        }
        return tokens;
    }

    private Principal instantiatePrincipal(Class cls, String role) {
        Principal p;
        block2: {
            p = null;
            try {
                Constructor ctr = cls.getConstructor(String.class);
                p = (Principal)ctr.newInstance(role);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Encountered exception in role mapping:", e);
            }
        }
        return p;
    }
}

