/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SimpleGroup;
import org.jboss.security.Util;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.config.MappingModuleEntry;

public class SecurityContext {
    private static final Logger log = Logger.getLogger(SecurityContext.class);
    private boolean trace = log.isTraceEnabled();
    private ConcurrentHashMap rolesMap = new ConcurrentHashMap();

    public AuthorizationManager getAuthorizationManager(String securityDomain) {
        return Util.getAuthorizationManager(securityDomain);
    }

    public Group getRoles(String securityDomain) {
        return (Group)this.rolesMap.get((Object)securityDomain);
    }

    public void setRoles(Group roles, String securityDomain) {
        MappingInfo rmi;
        Group grp = (Group)this.rolesMap.get((Object)securityDomain);
        if (grp == null) {
            grp = new SimpleGroup("Roles");
        }
        Enumeration principals = roles.members();
        while (principals.hasMoreElements()) {
            grp.addMember((Principal)principals.nextElement());
        }
        this.rolesMap.put((Object)securityDomain, (Object)grp);
        ApplicationPolicy aPolicy = Util.getApplicationPolicy(securityDomain);
        if (aPolicy == null) {
            String defaultDomain = "other";
            if (this.trace) {
                log.trace("Application Policy not found for domain=" + securityDomain + ".Mapping framework will use the default domain:" + defaultDomain);
            }
            aPolicy = Util.getApplicationPolicy(defaultDomain);
        }
        if ((rmi = aPolicy.getRoleMappingInfo()) != null) {
            MappingModuleEntry[] mpe = rmi.getMappingModuleEntry();
            ArrayList<MappingProvider> al = new ArrayList<MappingProvider>();
            for (int i = 0; i < mpe.length; ++i) {
                MappingProvider mp = this.getMappingProvider(mpe[i]);
                if (mp == null) continue;
                al.add(mp);
            }
            MappingContext mc = new MappingContext(al);
            HashMap<String, Group> contextMap = new HashMap<String, Group>();
            contextMap.put("Roles", roles);
            if (this.trace) {
                log.trace("Roles before mapping:" + roles);
            }
            roles = (Group)mc.performMapping(contextMap);
            if (this.trace) {
                log.trace("Roles after mapping:" + roles);
            }
            this.rolesMap.put((Object)securityDomain, (Object)roles);
        }
    }

    private MappingProvider getMappingProvider(MappingModuleEntry mme) {
        MappingProvider mp;
        block2: {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            mp = null;
            try {
                Class<?> cl = tcl.loadClass(mme.getMappingModuleName());
                mp = (MappingProvider)cl.newInstance();
                mp.init(mme.getOptions());
            }
            catch (Exception e) {
                if (!this.trace) break block2;
                log.trace("Error in getting Mapping Provider", e);
            }
        }
        return mp;
    }
}

