/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.logging.util.LoggerPluginWriter;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.connectionmanager.BaseConnectionManager2MBean;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.ConnectionCacheListener;
import org.jboss.resource.connectionmanager.ConnectionListener;
import org.jboss.resource.connectionmanager.ConnectionListenerFactory;
import org.jboss.resource.connectionmanager.ConnectionRecord;
import org.jboss.resource.connectionmanager.ManagedConnectionPool;
import org.jboss.resource.connectionmanager.PreFillPoolSupport;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.NotImplementedException;

public abstract class BaseConnectionManager2
extends ServiceMBeanSupport
implements BaseConnectionManager2MBean,
ConnectionCacheListener,
ConnectionListenerFactory,
TransactionTimeoutConfiguration {
    private static final String SECURITY_MGR_PATH = "java:/jaas/";
    public static final String STOPPING_NOTIFICATION = "jboss.jca.connectionmanagerstopping";
    protected ObjectName managedConnectionPoolName;
    protected ManagedConnectionPool poolingStrategy;
    protected String jndiName;
    protected String securityDomainJndiName;
    protected SubjectSecurityManager securityDomain;
    protected ObjectName jaasSecurityManagerService;
    protected ObjectName ccmName;
    protected CachedConnectionManager ccm;
    protected boolean trace;

    protected static void rethrowAsResourceException(String message, Throwable t) throws ResourceException {
        JBossResourceException.rethrowAsResourceException(message, t);
    }

    public BaseConnectionManager2() {
        this.trace = this.log.isTraceEnabled();
    }

    public BaseConnectionManager2(CachedConnectionManager ccm, ManagedConnectionPool poolingStrategy) {
        this.ccm = ccm;
        this.poolingStrategy = poolingStrategy;
        this.trace = this.log.isTraceEnabled();
    }

    public ManagedConnectionPool getPoolingStrategy() {
        return this.poolingStrategy;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public ObjectName getManagedConnectionPool() {
        return this.managedConnectionPoolName;
    }

    public void setManagedConnectionPool(ObjectName newManagedConnectionPool) {
        this.managedConnectionPoolName = newManagedConnectionPool;
    }

    public void setCachedConnectionManager(ObjectName ccmName) {
        this.ccmName = ccmName;
    }

    public ObjectName getCachedConnectionManager() {
        return this.ccmName;
    }

    public void setSecurityDomainJndiName(String securityDomainJndiName) {
        if (securityDomainJndiName != null && securityDomainJndiName.startsWith(SECURITY_MGR_PATH)) {
            securityDomainJndiName = securityDomainJndiName.substring(SECURITY_MGR_PATH.length());
            this.log.warn("WARNING: UPDATE YOUR SecurityDomainJndiName! REMOVE java:/jaas/");
        }
        this.securityDomainJndiName = securityDomainJndiName;
    }

    public String getSecurityDomainJndiName() {
        return this.securityDomainJndiName;
    }

    public ObjectName getJaasSecurityManagerService() {
        return this.jaasSecurityManagerService;
    }

    public void setJaasSecurityManagerService(ObjectName jaasSecurityManagerService) {
        this.jaasSecurityManagerService = jaasSecurityManagerService;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.poolingStrategy.getManagedConnectionFactory();
    }

    public BaseConnectionManager2 getInstance() {
        return this;
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        return -1L;
    }

    public int getTransactionTimeout() throws SystemException {
        throw new NotImplementedException("NYI: getTransactionTimeout()");
    }

    protected void startService() throws Exception {
        PreFillPoolSupport prefill;
        try {
            this.ccm = (CachedConnectionManager)this.server.getAttribute(this.ccmName, "Instance");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow(e);
        }
        if (this.ccm == null) {
            throw new DeploymentException("cached ConnectionManager not found: " + this.ccmName);
        }
        if (this.securityDomainJndiName != null && this.jaasSecurityManagerService == null) {
            throw new DeploymentException("You must supply both securityDomainJndiName and jaasSecurityManagerService to use container managed security");
        }
        if (this.securityDomainJndiName != null) {
            this.securityDomain = (SubjectSecurityManager)new InitialContext().lookup(SECURITY_MGR_PATH + this.securityDomainJndiName);
        }
        if (this.managedConnectionPoolName == null) {
            throw new DeploymentException("managedConnectionPool not set!");
        }
        try {
            this.poolingStrategy = (ManagedConnectionPool)this.server.getAttribute(this.managedConnectionPoolName, "ManagedConnectionPool");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow(e);
        }
        this.poolingStrategy.setConnectionListenerFactory(this);
        String categoryName = this.poolingStrategy.getManagedConnectionFactory().getClass().getName() + "." + this.jndiName;
        Logger log = Logger.getLogger(categoryName);
        LoggerPluginWriter logWriter = new LoggerPluginWriter(log.getLoggerPlugin());
        try {
            this.poolingStrategy.getManagedConnectionFactory().setLogWriter(logWriter);
        }
        catch (ResourceException re) {
            log.warn("Unable to set log writer '" + logWriter + "' on " + "managed connection factory", re);
            log.warn("Linked exception:", re.getLinkedException());
        }
        if (this.poolingStrategy instanceof PreFillPoolSupport && (prefill = (PreFillPoolSupport)((Object)this.poolingStrategy)).shouldPreFill()) {
            prefill.prefill();
        }
    }

    protected void stopService() throws Exception {
        this.sendNotification(new Notification(STOPPING_NOTIFICATION, this.getServiceName(), this.getNextNotificationSequenceNumber()));
        if (this.jaasSecurityManagerService != null && this.securityDomainJndiName != null) {
            this.server.invoke(this.jaasSecurityManagerService, "flushAuthenticationCache", new Object[]{this.securityDomainJndiName}, new String[]{String.class.getName()});
        }
        this.poolingStrategy.setConnectionListenerFactory(null);
        this.poolingStrategy = null;
        this.securityDomain = null;
        this.ccm = null;
    }

    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        return this.getManagedConnection(null, subject, cri);
    }

    protected ConnectionListener getManagedConnection(Transaction transaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        return this.poolingStrategy.getConnection(transaction, subject, cri);
    }

    public void returnManagedConnection(ConnectionListener cl, boolean kill) {
        ManagedConnectionPool localStrategy = cl.getManagedConnectionPool();
        if (localStrategy != this.poolingStrategy) {
            kill = true;
        }
        try {
            if (!kill && cl.getState() == 0) {
                cl.tidyup();
            }
        }
        catch (Throwable t) {
            this.log.warn("Error during tidyup " + cl, t);
            kill = true;
        }
        try {
            localStrategy.returnConnection(cl, kill);
        }
        catch (ResourceException re) {
            if (kill) {
                this.log.debug("resourceException killing connection (error retrieving from pool?)", re);
            }
            this.log.warn("resourceException returning connection: " + cl.getManagedConnection(), re);
        }
    }

    public int getConnectionCount() {
        return this.poolingStrategy.getConnectionCount();
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.poolingStrategy == null) {
            throw new ResourceException("You are trying to use a connection factory that has been shut down: ManagedConnectionFactory is null.");
        }
        if (!((Object)this.poolingStrategy.getManagedConnectionFactory()).equals(mcf)) {
            throw new ResourceException("Wrong ManagedConnectionFactory sent to allocateConnection!");
        }
        Subject subject = this.getSubject();
        ConnectionListener cl = this.getManagedConnection(subject, cri);
        this.reconnectManagedConnection(cl);
        Object connection = null;
        try {
            connection = cl.getManagedConnection().getConnection(subject, cri);
        }
        catch (Throwable t) {
            this.managedConnectionDisconnected(cl);
            JBossResourceException.rethrowAsResourceException("Unchecked throwable in ManagedConnection.getConnection() cl=" + cl, t);
        }
        this.registerAssociation(cl, connection);
        if (this.ccm != null) {
            this.ccm.registerConnection(this, cl, connection, cri);
        }
        return connection;
    }

    public void transactionStarted(Collection conns) throws SystemException {
    }

    public void reconnect(Collection conns, Set unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            this.log.trace("reconnect for unshareable connection: nothing to do");
            return;
        }
        HashMap<ConnectionRequestInfo, ConnectionListener> criToCLMap = new HashMap<ConnectionRequestInfo, ConnectionListener>();
        Iterator i = conns.iterator();
        while (i.hasNext()) {
            ConnectionListener cl;
            ConnectionRecord cr = (ConnectionRecord)i.next();
            if (cr.cl != null) {
                this.log.warn("reconnecting a connection handle that still has a managedConnection! " + cr.cl.getManagedConnection() + " " + cr.connection);
            }
            if ((cl = (ConnectionListener)criToCLMap.get(cr.cri)) == null) {
                cl = this.getManagedConnection(this.getSubject(), cr.cri);
                criToCLMap.put(cr.cri, cl);
                this.reconnectManagedConnection(cl);
            }
            cl.getManagedConnection().associateConnection(cr.connection);
            this.registerAssociation(cl, cr.connection);
            cr.setConnectionListener(cl);
        }
        criToCLMap.clear();
    }

    public void disconnect(Collection crs, Set unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            this.log.trace("disconnect for unshareable connection: nothing to do");
            return;
        }
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>();
        Iterator i = crs.iterator();
        while (i.hasNext()) {
            ConnectionRecord cr = (ConnectionRecord)i.next();
            ConnectionListener cl = cr.cl;
            cr.setConnectionListener(null);
            this.unregisterAssociation(cl, cr.connection);
            if (cls.contains(cl)) continue;
            cls.add(cl);
        }
        i = cls.iterator();
        while (i.hasNext()) {
            this.disconnectManagedConnection((ConnectionListener)i.next());
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return super.getNotificationInfo();
    }

    protected void unregisterAssociation(ConnectionListener cl, Object c) throws ResourceException {
        cl.unregisterConnection(c);
    }

    protected void reconnectManagedConnection(ConnectionListener cl) throws ResourceException {
        try {
            this.managedConnectionReconnected(cl);
        }
        catch (Throwable t) {
            this.disconnectManagedConnection(cl);
            JBossResourceException.rethrowAsResourceException("Unchecked throwable in managedConnectionReconnected() cl=" + cl, t);
        }
    }

    protected void disconnectManagedConnection(ConnectionListener cl) {
        try {
            this.managedConnectionDisconnected(cl);
        }
        catch (Throwable t) {
            this.log.warn("Unchecked throwable in managedConnectionDisconnected() cl=" + cl, t);
        }
    }

    protected final CachedConnectionManager getCcm() {
        return this.ccm;
    }

    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
    }

    private void registerAssociation(ConnectionListener cl, Object c) throws ResourceException {
        cl.registerConnection(c);
    }

    private Subject getSubject() {
        Object credential;
        Principal principal;
        Subject subject = null;
        if (this.securityDomain != null && !this.securityDomain.isValid(principal = GetPrincipalAction.getPrincipal(), credential = GetCredentialAction.getCredential(), subject = new Subject())) {
            throw new SecurityException("Invalid authentication attempt, principal=" + principal);
        }
        if (this.trace) {
            this.log.trace("subject: " + subject);
        }
        return subject;
    }

    public boolean isTransactional() {
        return false;
    }

    public TransactionManager getTransactionManagerInstance() {
        return null;
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetCredentialAction();

        private GetCredentialAction() {
        }

        public Object run() {
            Object credential = SecurityAssociation.getCredential();
            return credential;
        }

        static Object getCredential() {
            Object credential = AccessController.doPrivileged(ACTION);
            return credential;
        }
    }

    private static class GetPrincipalAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetPrincipalAction();

        private GetPrincipalAction() {
        }

        public Object run() {
            Principal principal = SecurityAssociation.getPrincipal();
            return principal;
        }

        static Principal getPrincipal() {
            Principal principal = (Principal)AccessController.doPrivileged(ACTION);
            return principal;
        }
    }

    public static class ConnectionManagerProxy
    implements ConnectionManager,
    Serializable,
    TransactionTimeoutConfiguration {
        static final long serialVersionUID = -528322728929261214L;
        private transient BaseConnectionManager2 realCm;
        private final ObjectName cmName;

        ConnectionManagerProxy(BaseConnectionManager2 realCm, ObjectName cmName) {
            this.realCm = realCm;
            this.cmName = cmName;
        }

        public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
            return this.getCM().allocateConnection(mcf, cri);
        }

        public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
            try {
                return this.getCM().getTimeLeftBeforeTransactionTimeout(errorRollback);
            }
            catch (ResourceException e) {
                throw new NestedRuntimeException("Unable to retrieve connection manager", e);
            }
        }

        public int getTransactionTimeout() throws SystemException {
            try {
                return this.getCM().getTransactionTimeout();
            }
            catch (ResourceException e) {
                throw new NestedRuntimeException("Unable to retrieve connection manager", e);
            }
        }

        private BaseConnectionManager2 getCM() throws ResourceException {
            if (this.realCm == null) {
                try {
                    MBeanServer server = MBeanServerLocator.locateJBoss();
                    this.realCm = (BaseConnectionManager2)server.getAttribute(this.cmName, "Instance");
                }
                catch (Throwable t) {
                    Throwable t2 = JMXExceptionDecoder.decode(t);
                    JBossResourceException.rethrowAsResourceException("Problem locating real ConnectionManager: " + this.cmName, t2);
                }
            }
            return this.realCm;
        }
    }

    protected abstract class BaseConnectionEventListener
    implements ConnectionListener {
        private final ManagedConnection mc;
        private final ManagedConnectionPool mcp;
        private final Object context;
        private int state = 0;
        private final List handles = new LinkedList();
        private long lastUse;
        private boolean trackByTx = false;
        private boolean permit = false;
        protected Logger log;
        protected boolean trace;
        protected long lastValidated;

        protected BaseConnectionEventListener(ManagedConnection mc, ManagedConnectionPool mcp, Object context, Logger log) {
            this.mc = mc;
            this.mcp = mcp;
            this.context = context;
            this.log = log;
            this.trace = log.isTraceEnabled();
            this.lastUse = System.currentTimeMillis();
        }

        public ManagedConnection getManagedConnection() {
            return this.mc;
        }

        public ManagedConnectionPool getManagedConnectionPool() {
            return this.mcp;
        }

        public Object getContext() {
            return this.context;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int newState) {
            this.state = newState;
        }

        public boolean isTimedOut(long timeout) {
            return this.lastUse < timeout;
        }

        public void used() {
            this.lastUse = System.currentTimeMillis();
        }

        public boolean isTrackByTx() {
            return this.trackByTx;
        }

        public void setTrackByTx(boolean trackByTx) {
            this.trackByTx = trackByTx;
        }

        public void tidyup() throws ResourceException {
        }

        public synchronized void registerConnection(Object handle) {
            this.handles.add(handle);
        }

        public synchronized void unregisterConnection(Object handle) {
            if (!this.handles.remove(handle)) {
                this.log.info("Unregistered handle that was not registered! " + handle + " for managedConnection: " + this.mc);
            }
            if (this.trace) {
                this.log.trace("unregisterConnection: " + this.handles.size() + " handles left");
            }
        }

        public synchronized boolean isManagedConnectionFree() {
            return this.handles.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void unregisterConnections() {
            try {
                Iterator i = this.handles.iterator();
                while (i.hasNext()) {
                    BaseConnectionManager2.this.getCcm().unregisterConnection(BaseConnectionManager2.this, i.next());
                }
            }
            finally {
                this.handles.clear();
            }
        }

        public void connectionErrorOccurred(ConnectionEvent ce) {
            if (this.state == 0) {
                if (ce != null) {
                    Exception t = ce.getException();
                    if (t == null) {
                        t = new Exception("No exception was reported");
                    }
                    this.log.warn("Connection error occured: " + this, t);
                } else {
                    Exception t = new Exception("No exception was reported");
                    this.log.warn("Unknown Connection error occured: " + this, t);
                }
            }
            try {
                this.unregisterConnections();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (ce != null && ce.getSource() != this.getManagedConnection()) {
                this.log.warn("Notified of error on a different managed connection?");
            }
            BaseConnectionManager2.this.returnManagedConnection(this, true);
        }

        public void enlist() throws SystemException {
        }

        public void delist() throws ResourceException {
        }

        public boolean hasPermit() {
            return this.permit;
        }

        public void grantPermit(boolean value) {
            this.permit = value;
        }

        public long getLastValidatedTime() {
            return this.lastValidated;
        }

        public void setLastValidatedTime(long lastValidated) {
            this.lastValidated = lastValidated;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
            buffer.append("[state=");
            if (this.state == 0) {
                buffer.append("NORMAL");
            } else if (this.state == 1) {
                buffer.append("DESTROY");
            } else if (this.state == 2) {
                buffer.append("DESTROYED");
            } else {
                buffer.append("UNKNOWN?");
            }
            buffer.append(" mc=").append(this.mc);
            buffer.append(" handles=").append(this.handles.size());
            buffer.append(" lastUse=").append(this.lastUse);
            buffer.append(" permit=").append(this.permit);
            buffer.append(" trackByTx=").append(this.trackByTx);
            buffer.append(" mcp=").append(this.mcp);
            buffer.append(" context=").append(this.context);
            this.toString(buffer);
            buffer.append(']');
            return buffer.toString();
        }

        protected void toString(StringBuffer buffer) {
        }
    }
}

