/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex.utility;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.remoting.transport.multiplex.utility.GrowablePipedInputStream;

public class GrowablePipedOutputStream
extends OutputStream {
    private GrowablePipedInputStream sink;
    private boolean connected;

    public GrowablePipedOutputStream() {
    }

    public GrowablePipedOutputStream(GrowablePipedInputStream sink) throws IOException {
        this.sink = sink;
        sink.connect(this);
        this.connected = true;
    }

    public void write(int b) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        this.sink.receive(b);
    }

    public void write(byte[] bytes) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        this.sink.receive(bytes);
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || offset > bytes.length || length < 0 || offset + length > bytes.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this.sink.receive(bytes, offset, length);
    }

    protected void connect(GrowablePipedInputStream sink) throws IOException {
        if (sink == null) {
            throw new NullPointerException();
        }
        if (sink.isConnected()) {
            throw new IOException("Already connected");
        }
        this.sink = sink;
        this.connected = true;
    }

    protected boolean isConnected() {
        return this.connected;
    }
}

