/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.InputMultiplexor;
import org.jboss.remoting.transport.multiplex.MultiplexingDataInputStream;
import org.jboss.remoting.transport.multiplex.MultiplexingInputStream;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.PendingAction;
import org.jboss.remoting.transport.multiplex.Protocol;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;
import org.jboss.remoting.transport.multiplex.utility.GrowablePipedOutputStream;
import org.jboss.remoting.transport.multiplex.utility.StoppableThread;

public class MultiplexingManager {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$MultiplexingManager == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingManager = MultiplexingManager.class$("org.jboss.remoting.transport.multiplex.MultiplexingManager")) : class$org$jboss$remoting$transport$multiplex$MultiplexingManager);
    private static Object shareableMapLock = new Object();
    private static Map shareableManagers = new HashMap();
    private static Object localAddressMapLock = new Object();
    private static Map managersByLocalAddress = new HashMap();
    private static Object remoteAddressMapLock = new Object();
    private static Map managersByRemoteAddress = new HashMap();
    private OutputMultiplexor outputMultiplexor;
    private Map socketMap = Collections.synchronizedMap(new HashMap());
    private Set registeredSockets = Collections.synchronizedSet(new HashSet());
    private Map outputStreamMap = Collections.synchronizedMap(new HashMap());
    private Map inputStreamMap = Collections.synchronizedMap(new HashMap());
    private Set threadsWaitingForRemoteServerSocket = new HashSet();
    private Protocol protocol;
    private Socket socket;
    private boolean bound = false;
    private boolean connected = false;
    private InetSocketAddress remoteSocketAddress;
    private InetSocketAddress localSocketAddress;
    private InetSocketAddress localWildCardAddress;
    private ServerSocket serverSocket;
    private boolean remoteServerSocketRegistered = false;
    private InputMultiplexor.InputThread inputThread;
    private OutputMultiplexor.OutputThread outputThread;
    private Protocol.BackChannelThread backChannelThread;
    private OutputStream deadLetterOutputStream = new ByteArrayOutputStream();
    private ShutdownManager shutdownManager = new ShutdownManager();
    private boolean shutdown = false;
    private List pendingActions = new ArrayList();
    private PendingActionThread pendingActionThread;
    private boolean tracing;
    private long id;
    private SocketFactory socketFactory;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexingManager;

    protected MultiplexingManager(SocketFactory socketFactory) throws IOException {
        this.id = new Date().getTime();
        if (socketFactory != null) {
            this.socketFactory = socketFactory;
            this.socket = socketFactory.createSocket();
        } else {
            this.socket = new Socket();
        }
        try {
            this.socket.setReuseAddress(true);
        }
        catch (SocketException ignored) {
            log.error(ignored);
        }
        log.debug("new MultiplexingManager: " + this.socket.toString());
    }

    protected MultiplexingManager(Socket socket) throws IOException {
        this.socket = socket;
        this.id = new Date().getTime();
        this.setup();
        log.debug("new MultiplexingManager: " + socket.toString());
    }

    protected MultiplexingManager(InetSocketAddress address, int timeout, SocketFactory socketFactory) throws IOException {
        if (socketFactory != null) {
            this.socketFactory = socketFactory;
            this.socket = socketFactory.createSocket();
        } else {
            this.socket = new Socket();
        }
        try {
            this.socket.setReuseAddress(true);
        }
        catch (SocketException ignored) {
            log.error(ignored);
        }
        this.socket.connect(address, timeout);
        this.setup();
        log.debug("new MultiplexingManager: " + this.socket.toString());
    }

    protected synchronized void setup() throws IOException {
        this.outputStreamMap.put(SocketId.DEADLETTER_SOCKET_ID, this.deadLetterOutputStream);
        this.registeredSockets.add(SocketId.PROTOCOL_SOCKET_ID);
        this.registeredSockets.add(SocketId.SERVER_SOCKET_ID);
        this.registeredSockets.add(SocketId.SERVER_SOCKET_CONNECT_ID);
        this.registeredSockets.add(SocketId.SERVER_SOCKET_VERIFY_ID);
        this.registeredSockets.add(SocketId.BACKCHANNEL_SOCKET_ID);
        this.getAnInputStream(SocketId.PROTOCOL_SOCKET_ID, null);
        this.getAnInputStream(SocketId.SERVER_SOCKET_ID, null);
        this.getAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID, null);
        this.getAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID, null);
        this.getAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID, null);
        this.outputMultiplexor = new OutputMultiplexor(this, this.socket);
        this.outputThread = this.outputMultiplexor.getAnOutputThread();
        this.outputThread.setName(this.outputThread.getName() + ":output(" + this.socket.toString() + ")");
        this.outputThread.start();
        this.inputThread = InputMultiplexor.getAnInputThread(this, this.socket, this.deadLetterOutputStream);
        this.inputThread.setName(this.inputThread.getName() + ":input(" + this.socket.toString() + ")");
        this.inputThread.start();
        this.protocol = new Protocol(this);
        this.backChannelThread = this.protocol.getBackChannelThread();
        this.backChannelThread.setName(this.backChannelThread.getName() + ":backchannel(" + this.socket.toString() + ")");
        this.backChannelThread.start();
        this.pendingActionThread = new PendingActionThread();
        this.pendingActionThread.setName(this.pendingActionThread.getName() + ":background(" + this.socket.toString() + ")");
        this.pendingActionThread.start();
        this.registerByLocalAddress(new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort()));
        this.registerByRemoteAddress(new InetSocketAddress(this.socket.getInetAddress(), this.socket.getPort()));
        this.bound = true;
        this.connected = true;
        this.tracing = log.isTraceEnabled();
    }

    public static MultiplexingManager getaManager(Socket socket) throws IOException {
        log.debug("entering getaManager(Socket socket)");
        return new MultiplexingManager(socket);
    }

    public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address) throws IOException {
        return MultiplexingManager.getaManagerByLocalAddress(address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaManagerByLocalAddress(InetSocketAddress address, SocketFactory socketFactory) throws IOException {
        log.debug("entering getaManagerByLocalAddress(InetSocketAddress address)");
        MultiplexingManager m = null;
        Object object = localAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByLocalAddress.get(address);
            if (managers != null) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (IOException e) {
                    }
                }
            }
        }
        log.debug("There is no joinable MultiplexingManager. Creating new one.");
        m = new MultiplexingManager(socketFactory);
        m.bind(address);
        return m;
    }

    public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address, int timeout) throws IOException {
        return MultiplexingManager.getaManagerByRemoteAddress(address, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaManagerByRemoteAddress(InetSocketAddress address, int timeout, SocketFactory socketFactory) throws IOException {
        log.debug("entering getaManagerByRemoteAddress(InetSocketAddress address)");
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByRemoteAddress.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug("manager shutting down: " + m);
                    }
                }
            }
        }
        return new MultiplexingManager(address, timeout, socketFactory);
    }

    public static synchronized MultiplexingManager getaManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout) throws IOException {
        return MultiplexingManager.getaManagerByAddressPair(remoteAddress, localAddress, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, SocketFactory socketFactory) throws IOException {
        MultiplexingManager m;
        log.debug("entering getaManagerByRemoteAddress(InetSocketAddress address)");
        log.debug(localAddress);
        log.debug(remoteAddress);
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByRemoteAddress.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory() || !m.getSocket().getLocalAddress().equals(localAddress.getAddress()) || m.getSocket().getLocalPort() != localAddress.getPort()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug("manager shutting down: " + m);
                    }
                }
            }
        }
        log.debug("There is no joinable MultiplexingManager. Creating new one.");
        m = new MultiplexingManager(socketFactory);
        m.bind(localAddress);
        return m;
    }

    public static synchronized MultiplexingManager getaShareableManager(InetSocketAddress address, int timeout) throws IOException {
        return MultiplexingManager.getaShareableManager(address, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaShareableManager(InetSocketAddress address, int timeout, SocketFactory socketFactory) throws IOException {
        log.debug("entering getaShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug("manager shutting down: " + m);
                    }
                }
            }
        }
        return new MultiplexingManager(address, timeout, socketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiplexingManager getAnExistingShareableManager(InetSocketAddress address, SocketFactory socketFactory) throws IOException {
        log.debug("entering getAnExistingShareableManager()");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug("manager shutting down: " + m);
                    }
                }
            }
        }
        return null;
    }

    public static synchronized MultiplexingManager getaShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout) throws IOException {
        return MultiplexingManager.getaShareableManagerByAddressPair(remoteAddress, localAddress, timeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized MultiplexingManager getaShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, int timeout, SocketFactory socketFactory) throws IOException {
        MultiplexingManager m;
        log.debug("entering getaShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory() || !m.getSocket().getLocalAddress().equals(localAddress.getAddress()) || m.getSocket().getLocalPort() != localAddress.getPort()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug("manager shutting down: " + m);
                    }
                }
            }
        }
        log.debug("There is no joinable MultiplexingManager. Creating new one.");
        m = new MultiplexingManager(socketFactory);
        m.bind(localAddress);
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiplexingManager getAnExistingShareableManagerByAddressPair(InetSocketAddress remoteAddress, InetSocketAddress localAddress, SocketFactory socketFactory) throws IOException {
        log.debug("entering getaShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory() || !m.getSocket().getLocalAddress().equals(localAddress.getAddress()) || m.getSocket().getLocalPort() != localAddress.getPort()) continue;
                    try {
                        m.shutdownManager.incrementReferences();
                        return m;
                    }
                    catch (Exception e) {
                        log.debug("manager shutting down: " + m);
                    }
                }
            }
        }
        return null;
    }

    public static boolean checkForShareableManager(InetSocketAddress address) throws IOException {
        return MultiplexingManager.checkForShareableManager(address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForShareableManager(InetSocketAddress address, SocketFactory socketFactory) throws IOException {
        log.debug("entering checkForShareableManager(InetSocketAddress address)");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(address);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static boolean checkForManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        return MultiplexingManager.checkForManagerByAddressPair(localAddress, remoteAddress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress, SocketFactory socketFactory) {
        log.debug("entering checkForManagerByAddressPair()");
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)managersByRemoteAddress.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory() || !m.localSocketAddress.equals(localAddress)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean checkForShareableManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress) {
        return MultiplexingManager.checkForShareableManagerByAddressPair(localAddress, remoteAddress, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForShareableManagerByAddressPair(InetSocketAddress localAddress, InetSocketAddress remoteAddress, SocketFactory socketFactory) {
        log.debug("entering checkForShareableManagerByAddressPair()");
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet managers = (HashSet)shareableManagers.get(remoteAddress);
            if (managers != null && !managers.isEmpty()) {
                Iterator it = managers.iterator();
                while (it.hasNext()) {
                    MultiplexingManager m = (MultiplexingManager)it.next();
                    if (socketFactory != m.getSocketFactory() || !m.localSocketAddress.equals(localAddress)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public synchronized void bind(InetSocketAddress address) throws IOException {
        if (this.bound) {
            throw new IOException("socket is already bound");
        }
        this.socket.bind(address);
        this.bound = true;
    }

    public synchronized void connect(InetSocketAddress address, int timeout) throws IOException {
        if (this.connected) {
            if (this.socket.getRemoteSocketAddress().equals(address)) {
                return;
            }
            throw new IOException("socket is already connected");
        }
        if (this.socket == null) {
            this.socket = new Socket();
        }
        log.debug("connecting to: " + address);
        this.socket.connect(address, timeout);
        this.connected = true;
        this.setup();
    }

    public synchronized MultiplexingDataInputStream registerServerSocket(ServerSocket serverSocket) throws IOException {
        if (this.serverSocket != null && this.serverSocket != serverSocket) {
            log.error("[" + this.id + "]: " + "attempt to register a second server socket");
            log.error("current server socket: " + this.serverSocket.toString());
            log.error("new server socket:     " + serverSocket.toString());
            throw new IOException("attempt to register a second server socket");
        }
        log.debug(serverSocket.toString());
        this.serverSocket = serverSocket;
        return new MultiplexingDataInputStream(this.getAnInputStream(SocketId.SERVER_SOCKET_ID, null));
    }

    public synchronized void unRegisterServerSocket(ServerSocket serverSocket) throws IOException {
        if (this.serverSocket != serverSocket) {
            log.error("server socket attempting unregister but is not registered");
            throw new IOException("server socket is not registered");
        }
        log.debug("server socket unregistering");
        this.removeAnInputStream(SocketId.SERVER_SOCKET_ID);
        this.serverSocket = null;
        this.shutdownManager.decrementReferences();
    }

    public synchronized MultiplexingInputStream registerSocket(VirtualSocket socket) throws IOException {
        SocketId localSocketId = socket.getLocalSocketId();
        VirtualSocket currentSocket = this.socketMap.put(localSocketId, socket);
        if (currentSocket != null) {
            String errorMessage = "attempting to register socket on currently used port:" + currentSocket.getLocalVirtualPort();
            log.error(errorMessage);
            throw new IOException(errorMessage);
        }
        log.debug("registering virtual socket on port: " + localSocketId.getPort());
        this.registeredSockets.add(socket.getLocalSocketId());
        return this.getAnInputStream(localSocketId, socket);
    }

    public synchronized void unRegisterSocket(VirtualSocket socket) throws IOException {
        log.debug("entering unRegisterSocket()");
        SocketId localSocketId = socket.getLocalSocketId();
        if (localSocketId == null) {
            return;
        }
        VirtualSocket currentSocket = (VirtualSocket)this.socketMap.remove(localSocketId);
        if (currentSocket == null) {
            String errorMessage = "attempting to unregister unrecognized socket: " + socket.getLocalSocketId().getPort();
            log.error(errorMessage);
            throw new IOException(errorMessage);
        }
        log.debug("unregistering virtual socket on port: " + localSocketId.getPort());
        this.registeredSockets.remove(socket.getLocalSocketId());
        this.removeAnInputStream(localSocketId);
        this.shutdownManager.decrementReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerRemoteServerSocket() throws IOException {
        if (this.remoteServerSocketRegistered) {
            log.error("duplicate remote server socket registration");
            throw new IOException("duplicate remote server socket registration");
        }
        this.remoteServerSocketRegistered = true;
        this.registerShareable(this.remoteSocketAddress);
        Set set = this.threadsWaitingForRemoteServerSocket;
        synchronized (set) {
            this.threadsWaitingForRemoteServerSocket.notifyAll();
        }
    }

    public synchronized void unRegisterRemoteServerSocket() {
        if (!this.remoteServerSocketRegistered) {
            log.error("no remote server socket is registered");
        } else {
            this.remoteServerSocketRegistered = false;
            this.unregisterShareable();
        }
    }

    public synchronized boolean isRemoteServerSocketRegistered() {
        return this.remoteServerSocketRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRemoteServerSocketRegistered() {
        if (this.remoteServerSocketRegistered) {
            return true;
        }
        Set set = this.threadsWaitingForRemoteServerSocket;
        synchronized (set) {
            this.threadsWaitingForRemoteServerSocket.add(Thread.currentThread());
            while (!this.remoteServerSocketRegistered) {
                try {
                    this.threadsWaitingForRemoteServerSocket.wait();
                }
                catch (InterruptedException e) {
                    log.info("interrupted waiting for registration of remote server socket");
                    if (!this.shutdown) continue;
                    this.threadsWaitingForRemoteServerSocket.remove(Thread.currentThread());
                    return false;
                }
            }
        }
        this.threadsWaitingForRemoteServerSocket.remove(Thread.currentThread());
        return true;
    }

    public void incrementReferences() throws IOException {
        this.shutdownManager.incrementReferences();
    }

    public void decrementReferences() throws IOException {
        this.shutdownManager.decrementReferences();
    }

    public Collection getAllOutputStreams() {
        return this.outputStreamMap.values();
    }

    public MultiplexingInputStream getAnInputStream(SocketId socketId, VirtualSocket socket) throws IOException {
        log.debug("getAnInputStream(): " + socketId.getPort());
        MultiplexingInputStream mis = (MultiplexingInputStream)this.inputStreamMap.get(socketId);
        if (mis != null) {
            return mis;
        }
        GrowablePipedOutputStream pos = new GrowablePipedOutputStream();
        mis = new MultiplexingInputStream(pos, this, socket);
        this.outputStreamMap.put(socketId, pos);
        this.inputStreamMap.put(socketId, mis);
        return mis;
    }

    public OutputMultiplexor getOutputMultiplexor() {
        return this.outputMultiplexor;
    }

    public OutputStream getOutputStreamByLocalSocket(SocketId socketId) {
        return (OutputStream)this.outputStreamMap.get(socketId);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public VirtualSocket getSocketByLocalPort(SocketId socketId) {
        return (VirtualSocket)this.socketMap.get(socketId);
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public boolean isBound() {
        return this.bound;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized boolean isServerSocketRegistered() {
        return this.serverSocket != null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized boolean isSocketRegistered(SocketId socketId) {
        return this.registeredSockets.contains(socketId);
    }

    public boolean respondToShutdownRequest() {
        return this.shutdownManager.respondToShutdownRequest();
    }

    public void setSocketFactory(SocketFactory socketFactory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerByLocalAddress(InetSocketAddress address) {
        Object object = localAddressMapLock;
        synchronized (object) {
            this.localSocketAddress = address;
            HashSet<MultiplexingManager> managers = (HashSet<MultiplexingManager>)managersByLocalAddress.get(address);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managersByLocalAddress.put(address, managers);
            }
            managers.add(this);
            this.localWildCardAddress = new InetSocketAddress(address.getPort());
            managers = (HashSet<MultiplexingManager>)managersByLocalAddress.get(this.localWildCardAddress);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managersByLocalAddress.put(this.localWildCardAddress, managers);
            }
            managers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterByLocalAddress() {
        Object object = localAddressMapLock;
        synchronized (object) {
            HashSet managers = null;
            if (this.localSocketAddress != null && (managers = (HashSet)managersByLocalAddress.get(this.localSocketAddress)) != null) {
                managers.remove(this);
                if (managers.isEmpty()) {
                    managersByLocalAddress.remove(this.localSocketAddress);
                }
            }
            if (this.localWildCardAddress != null && (managers = (HashSet)managersByLocalAddress.get(this.localWildCardAddress)) != null) {
                managers.remove(this);
                if (managers.isEmpty()) {
                    managersByLocalAddress.remove(this.localWildCardAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerByRemoteAddress(InetSocketAddress address) {
        this.remoteSocketAddress = address;
        Object object = remoteAddressMapLock;
        synchronized (object) {
            HashSet<MultiplexingManager> managers = (HashSet<MultiplexingManager>)managersByRemoteAddress.get(address);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managers.add(this);
                managersByRemoteAddress.put(address, managers);
            } else {
                managers.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterByRemoteAddress() {
        if (this.remoteSocketAddress != null) {
            Object object = remoteAddressMapLock;
            synchronized (object) {
                HashSet managers = (HashSet)managersByRemoteAddress.get(this.remoteSocketAddress);
                if (managers != null) {
                    managers.remove(this);
                    if (managers.isEmpty()) {
                        managersByRemoteAddress.remove(this.remoteSocketAddress);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerShareable(InetSocketAddress address) {
        Object object = shareableMapLock;
        synchronized (object) {
            HashSet<MultiplexingManager> managers = (HashSet<MultiplexingManager>)shareableManagers.get(address);
            if (managers == null) {
                managers = new HashSet<MultiplexingManager>();
                managers.add(this);
                shareableManagers.put(address, managers);
            } else {
                managers.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterShareable() {
        if (this.remoteSocketAddress != null) {
            Object object = shareableMapLock;
            synchronized (object) {
                HashSet managers = (HashSet)shareableManagers.get(this.remoteSocketAddress);
                if (managers != null) {
                    managers.remove(this);
                    if (managers.isEmpty()) {
                        shareableManagers.remove(this.remoteSocketAddress);
                    }
                }
            }
        }
    }

    protected void removeAnInputStream(SocketId socketId) {
        log.debug("entering removeAnInputStream(): " + socketId.getPort());
        InputStream is = (InputStream)this.inputStreamMap.remove(socketId);
        OutputStream os = (OutputStream)this.outputStreamMap.remove(socketId);
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception ignored) {
                log.error("error closing PipedInputStream (" + this.socket.getPort() + ")", ignored);
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception ignored) {
                log.error("error closing PipedOutputStream (" + this.socket.getPort() + ")", ignored);
            }
        }
    }

    protected synchronized void shutdown() {
        log.debug("entering shutdown()");
        ShutdownThread shutdownThread = new ShutdownThread();
        shutdownThread.setName(shutdownThread.getName() + ":shutdown");
        shutdownThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToPendingActions(PendingAction pendingAction) {
        List list = this.pendingActions;
        synchronized (list) {
            this.pendingActions.add(pendingAction);
            this.pendingActions.notifyAll();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class PendingActionThread
    extends StoppableThread {
        private List pendingActionsTemp = new ArrayList();

        protected PendingActionThread() {
        }

        protected void doInit() {
            log.debug("PendingActionThread starting");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun() {
            List list = MultiplexingManager.this.pendingActions;
            synchronized (list) {
                while (MultiplexingManager.this.pendingActions.isEmpty()) {
                    try {
                        MultiplexingManager.this.pendingActions.wait();
                    }
                    catch (InterruptedException ignored) {
                        if (this.isRunning()) continue;
                        return;
                    }
                }
                this.pendingActionsTemp.addAll(MultiplexingManager.this.pendingActions);
                MultiplexingManager.this.pendingActions.clear();
            }
            Iterator it = this.pendingActionsTemp.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof PendingAction) {
                    ((PendingAction)o).doAction();
                    continue;
                }
                log.error("object in closePendingSockets has invalid type: " + o.getClass());
            }
            this.pendingActionsTemp.clear();
        }

        public void shutdown() {
            log.debug("entering close thread shutdown()");
            super.shutdown();
            this.interrupt();
        }

        protected void doShutDown() {
            log.debug("PendingActionThread shutting down");
        }
    }

    protected class ShutdownThread
    extends Thread {
        protected ShutdownThread() {
        }

        public void run() {
            log.debug(MultiplexingManager.this.socket.toString() + ": manager shutting down");
            MultiplexingManager.this.unregisterByLocalAddress();
            MultiplexingManager.this.unregisterByRemoteAddress();
            MultiplexingManager.this.unregisterShareable();
            if (MultiplexingManager.this.outputThread != null) {
                MultiplexingManager.this.outputThread.shutdown();
                try {
                    MultiplexingManager.this.outputThread.join();
                    log.debug("manager: joined output thread");
                }
                catch (InterruptedException ignored) {
                    log.debug("interrupt exception waiting for write thread");
                }
            }
            if (MultiplexingManager.this.socket != null) {
                try {
                    MultiplexingManager.this.socket.close();
                    log.debug("manager: closed socket");
                }
                catch (IOException e) {
                    log.error("manager: unable to close socket");
                }
            }
            if (MultiplexingManager.this.backChannelThread != null) {
                MultiplexingManager.this.backChannelThread.shutdown();
                try {
                    MultiplexingManager.this.backChannelThread.join();
                    log.debug("manager: joined back channel thread");
                }
                catch (InterruptedException ignored) {
                    log.debug("manager: interrupted exception waiting for back channel thread");
                }
            }
            if (MultiplexingManager.this.inputThread != null) {
                MultiplexingManager.this.inputThread.shutdown();
                try {
                    MultiplexingManager.this.inputThread.join();
                    log.debug("manager: joined input thread");
                }
                catch (InterruptedException ignored) {
                    log.debug("manager: interrupted exception waiting for read thread");
                }
            }
            MultiplexingManager.this.removeAnInputStream(SocketId.PROTOCOL_SOCKET_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_CONNECT_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.SERVER_SOCKET_VERIFY_ID);
            MultiplexingManager.this.removeAnInputStream(SocketId.BACKCHANNEL_SOCKET_ID);
            if (MultiplexingManager.this.pendingActionThread != null) {
                MultiplexingManager.this.pendingActionThread.shutdown();
                try {
                    MultiplexingManager.this.pendingActionThread.join();
                    log.debug("manager: joined socketAndStreamClose thread");
                }
                catch (InterruptedException e) {
                    log.debug("manager: interrupted exception waiting for socket close thread to shut down");
                }
            }
            MultiplexingManager.this.shutdown = true;
            log.debug("manager shut down");
        }
    }

    protected class ShutdownManager {
        private int referenceCount = 1;
        private boolean reserved = false;
        private boolean shutdownRequestInProgress = false;
        private boolean readyToShutdown = false;
        ShutdownMonitorThread shutdownMonitorThread;
        private boolean shutdown = false;
        private boolean remoteShutdown = false;

        protected ShutdownManager() {
        }

        public synchronized void reserveManager() throws IOException {
            log.debug(MultiplexingManager.this.socket.toString() + this.referenceCount);
            while (this.shutdownRequestInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.error("interruption in ShutdownRequestThread");
                }
            }
            if (this.shutdown || this.remoteShutdown) {
                throw new IOException("manager shutting down");
            }
            this.readyToShutdown = false;
            this.reserved = true;
            if (this.shutdownMonitorThread != null) {
                this.shutdownMonitorThread.terminate();
            }
            this.notifyAll();
        }

        public synchronized void unreserveManager() {
            log.debug(MultiplexingManager.this.socket.toString() + this.referenceCount);
            if (!this.reserved) {
                log.error("attempting to unreserve a MultiplexingManager that was not reserved: " + MultiplexingManager.this.socket.toString());
                return;
            }
            this.reserved = false;
            if (this.referenceCount == 0) {
                ++this.referenceCount;
                this.decrementReferences();
            }
        }

        public synchronized void incrementReferences() throws IOException {
            log.debug(MultiplexingManager.this.socket.toString() + this.referenceCount);
            while (this.shutdownRequestInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    log.error("interruption in ShutdownRequestThread");
                }
            }
            if (this.shutdown || this.remoteShutdown) {
                throw new IOException("not accepting new clients");
            }
            this.readyToShutdown = false;
            this.reserved = false;
            ++this.referenceCount;
            log.debug(MultiplexingManager.this.socket.toString() + this.referenceCount);
            if (this.shutdownMonitorThread != null) {
                this.shutdownMonitorThread.terminate();
            }
            this.notifyAll();
        }

        public synchronized void decrementReferences() {
            --this.referenceCount;
            log.debug(MultiplexingManager.this.socket.toString() + this.referenceCount);
            if (this.reserved) {
                log.debug(MultiplexingManager.this.socket.toString() + ": reserved == true");
                return;
            }
            if (this.referenceCount == 0) {
                this.readyToShutdown = true;
                if (MultiplexingManager.this.isConnected()) {
                    ShutdownRequestThread shutdownRequestThread = new ShutdownRequestThread();
                    shutdownRequestThread.setName(shutdownRequestThread.getName() + ":shutdownRequest");
                    shutdownRequestThread.setDaemon(true);
                    log.debug("starting ShutdownRequestThread: " + shutdownRequestThread.toString());
                    shutdownRequestThread.start();
                    try {
                        this.wait(5000L);
                    }
                    catch (InterruptedException e) {
                        log.error("interrupt in ShutdownRequestThread");
                    }
                    log.debug(MultiplexingManager.this.socket.toString() + this.shutdown);
                    log.debug(MultiplexingManager.this.socket.toString() + shutdownRequestThread.isAlive());
                    if (this.shutdownRequestInProgress) {
                        this.shutdown = true;
                        this.shutdownRequestInProgress = false;
                    }
                } else {
                    this.shutdown = true;
                }
                if (this.shutdown) {
                    MultiplexingManager.this.shutdown();
                    this.notifyAll();
                } else {
                    this.shutdownMonitorThread = new ShutdownMonitorThread();
                    this.shutdownMonitorThread.setName(this.shutdownMonitorThread.getName() + ":shutdownMonitor");
                    this.shutdownMonitorThread.start();
                }
            }
        }

        protected synchronized boolean respondToShutdownRequest() {
            log.debug(MultiplexingManager.this.socket.toString() + this.readyToShutdown);
            log.debug(MultiplexingManager.this.socket.toString() + this.shutdown);
            if (this.readyToShutdown) {
                this.remoteShutdown = true;
                log.debug(MultiplexingManager.this.socket.toString() + ": respondToShutdownRequest(): set remoteShutdown to true");
            }
            return this.readyToShutdown;
        }

        protected boolean isShutdown() {
            return this.shutdown;
        }

        private class ShutdownMonitorThread
        extends Thread {
            boolean running = true;

            private ShutdownMonitorThread() {
            }

            public void terminate() {
                this.running = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                log.debug(MultiplexingManager.this.socket.toString() + ": entering ShutdownMonitorThread");
                while (this.running) {
                    try {
                        ShutdownMonitorThread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ShutdownManager shutdownManager = ShutdownManager.this;
                    synchronized (shutdownManager) {
                        if (ShutdownManager.this.readyToShutdown && ShutdownManager.this.remoteShutdown && !ShutdownManager.this.shutdown) {
                            log.debug("ShutdownMonitorThread: found remoteShutdown == true");
                            ShutdownManager.this.shutdown = true;
                            MultiplexingManager.this.shutdown();
                            ShutdownManager.this.notifyAll();
                            return;
                        }
                    }
                }
            }
        }

        private class ShutdownRequestThread
        extends Thread {
            public ShutdownRequestThread() {
                ShutdownManager.this.shutdownRequestInProgress = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ShutdownManager.this.shutdown = MultiplexingManager.this.protocol.requestManagerShutdown();
                }
                catch (SocketTimeoutException e) {
                    log.debug("socket timeout exception in manager shutdown request");
                }
                catch (Exception e) {
                    log.debug("i/o exception in manager shutdown request", e);
                }
                log.debug("ShutdownRequestThread.run(): done");
                ShutdownManager.this.shutdownRequestInProgress = false;
                ShutdownManager shutdownManager = ShutdownManager.this;
                synchronized (shutdownManager) {
                    ShutdownManager.this.notifyAll();
                }
            }
        }
    }
}

