/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.serializable;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jboss.remoting.marshal.SerialUnMarshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class SerializableUnMarshaller
implements SerialUnMarshaller {
    static final long serialVersionUID = -1554017376768780738L;
    public static final String DATATYPE = "serializable";
    protected ClassLoader customClassLoader = null;
    protected String serializationType;

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        return SerializationStreamFactory.getManagerInstance(this.getSerializationType()).receiveObject(inputStream, this.customClassLoader);
    }

    public void setClassLoader(ClassLoader classloader) {
        this.customClassLoader = classloader;
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        SerializableUnMarshaller unmarshaller = new SerializableUnMarshaller();
        unmarshaller.setClassLoader(this.customClassLoader);
        return unmarshaller;
    }

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public String getSerializationType() {
        if (this.serializationType == null) {
            return "java";
        }
        return this.serializationType;
    }
}

