/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.serializable;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.SerialMarshaller;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class SerializableMarshaller
implements SerialMarshaller {
    static final long serialVersionUID = -5553685435323600244L;
    public static final String DATATYPE = "serializable";
    String serializationType;

    public void setSerializationType(String serializationType) {
        this.serializationType = serializationType;
    }

    public String getSerializationType() {
        if (this.serializationType == null) {
            return "java";
        }
        return this.serializationType;
    }

    public void write(Object dataObject, OutputStream output) throws IOException {
        ObjectOutputStream oos = null;
        oos = output instanceof ObjectOutputStream ? (ObjectOutputStream)output : SerializationStreamFactory.getManagerInstance(this.getSerializationType()).createOutput(output);
        SerializationStreamFactory.getManagerInstance(this.getSerializationType()).sendObject(oos, dataObject);
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new SerializableMarshaller();
    }
}

