/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.WeakHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.NamingServer;

public class ENCFactory
implements ObjectFactory {
    private static WeakHashMap encs = new WeakHashMap();
    private static ClassLoader topLoader;

    public static void setTopClassLoader(ClassLoader topLoader) {
        ENCFactory.topLoader = topLoader;
    }

    public static ClassLoader getTopClassLoader() {
        return topLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        ClassLoader ctxClassLoader = GetTCLAction.getContextClassLoader();
        WeakHashMap weakHashMap = encs;
        synchronized (weakHashMap) {
            Context compCtx = (Context)encs.get(ctxClassLoader);
            if (compCtx == null) {
                ClassLoader loader = ctxClassLoader;
                GetParentAction action = new GetParentAction(ctxClassLoader);
                while (loader != null && loader != topLoader && compCtx == null) {
                    compCtx = (Context)encs.get(loader);
                    loader = action.getParent();
                }
                if (compCtx == null) {
                    NamingServer srv = new NamingServer();
                    compCtx = new NamingContext(environment, null, srv);
                    encs.put(ctxClassLoader, compCtx);
                }
            }
            return compCtx;
        }
    }

    private static class GetParentAction
    implements PrivilegedAction {
        ClassLoader loader;

        GetParentAction(ClassLoader loader) {
            this.loader = loader;
        }

        public Object run() {
            ClassLoader parent = null;
            if (this.loader != null) {
                this.loader = parent = this.loader.getParent();
            }
            return parent;
        }

        ClassLoader getParent() {
            ClassLoader parent = (ClassLoader)AccessController.doPrivileged(this);
            return parent;
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader;
        }

        static ClassLoader getContextClassLoader() {
            ClassLoader loader = (ClassLoader)AccessController.doPrivileged(ACTION);
            return loader;
        }
    }
}

