/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import javax.jms.JMSException;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.server.JMSServerInterceptorSupport;

public class NonPersistentInterceptor
extends JMSServerInterceptorSupport {
    public void addMessage(ConnectionToken dc, SpyMessage message) throws JMSException {
        this.makeNonPersistent(message);
        super.addMessage(dc, message);
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException {
        if (t.messages != null) {
            for (int i = 0; i < t.messages.length; ++i) {
                this.makeNonPersistent(t.messages[i]);
            }
        }
        super.transact(dc, t);
    }

    protected void makeNonPersistent(SpyMessage message) throws JMSException {
        message.setJMSDeliveryMode(1);
    }
}

