/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.mq.il.http.HTTPILRequest;

public class HTTPClientILStorageQueue {
    private static Logger log = Logger.getLogger(HTTPClientILStorageQueue.class);
    private static HTTPClientILStorageQueue instance = null;
    private Map map = new HashMap();
    private Object queueLock = new Object();
    private static long id = 100L;
    private static Object idLock = new Object();

    private HTTPClientILStorageQueue() {
        if (log.isTraceEnabled()) {
            log.trace("created");
        }
    }

    public static synchronized HTTPClientILStorageQueue getInstance() {
        if (log.isTraceEnabled()) {
            log.trace("getInstance()");
        }
        if (instance == null) {
            instance = new HTTPClientILStorageQueue();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(HTTPILRequest request, String clientIlId) throws InterruptedException {
        if (log.isTraceEnabled()) {
            log.trace("put(HTTPILRequest " + request.toString() + ", String " + clientIlId + ")");
        }
        if (clientIlId == null) {
            log.warn("A request was put in a storage queue for a null ClientIl.");
            return;
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (this.map.containsKey(clientIlId)) {
                if (log.isDebugEnabled()) {
                    log.debug("ClientIL #" + clientIlId + " has existing storage queue, adding request to it.");
                }
                LinkedQueue queue = (LinkedQueue)this.map.get(clientIlId);
                queue.put((Object)request);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("ClientIL #" + clientIlId + " doesn't have a storage queue.  Creating one and adding the request.");
                }
                LinkedQueue queue = new LinkedQueue();
                queue.put((Object)request);
                this.map.put(clientIlId, queue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPILRequest[] get(String clientIlId, long timeout) {
        LinkedQueue queue;
        if (log.isTraceEnabled()) {
            log.trace("get(String " + clientIlId + ")");
        }
        if (clientIlId == null) {
            log.warn("A get was issued with a null clientIL Id.");
        }
        Object object = this.queueLock;
        synchronized (object) {
            queue = (LinkedQueue)this.map.get(clientIlId);
            if (queue == null) {
                if (log.isDebugEnabled()) {
                    log.debug("ClientIL #" + clientIlId + " doesn't have a storage queue.  Creating new one.");
                }
                queue = new LinkedQueue();
                this.map.put(clientIlId, queue);
            }
        }
        ArrayList<Object> messageList = new ArrayList<Object>();
        try {
            Object object2;
            if (log.isDebugEnabled()) {
                log.debug("Polling the queue for " + String.valueOf(timeout) + " milliseconds on behalf of clientIL #" + clientIlId + ".");
            }
            if ((object2 = queue.poll(timeout)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Poll returned a HTTPILRequest, adding it to our list of requests to deliver to clientIL #" + clientIlId + ".");
                }
                messageList.add(object2);
                while ((object2 = queue.poll(0L)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("We had a request, so we're are going to see if there are any more for us, but we're not going to block this time.");
                    }
                    messageList.add(object2);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Added request.");
                }
            }
        }
        catch (InterruptedException exception) {
            log.debug("An interruptedException was triggered.  We'll just deliver what we have to the client and try again next time.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Returning " + String.valueOf(messageList.size()) + " requests to clientIL #" + clientIlId + ".");
        }
        return this.createArrayFromList(messageList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeEntry(String clientIlId) {
        Object entry;
        if (log.isTraceEnabled()) {
            log.trace("purgeEntry(String " + clientIlId + ")");
        }
        Object object = this.queueLock;
        synchronized (object) {
            entry = this.map.remove(clientIlId);
        }
        if (entry != null && log.isDebugEnabled()) {
            log.debug("Purged storage queue entry for ClientIL #" + clientIlId + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getID() {
        if (log.isTraceEnabled()) {
            log.trace("getID()");
        }
        Object object = idLock;
        synchronized (object) {
            return String.valueOf(++id);
        }
    }

    private HTTPILRequest[] createArrayFromList(ArrayList list) {
        if (log.isTraceEnabled()) {
            log.trace("createArrayFromList(ArrayList length=" + String.valueOf(list.size()) + ")");
        }
        HTTPILRequest[] requests = new HTTPILRequest[list.size()];
        Iterator itemList = list.iterator();
        int i = 0;
        while (itemList.hasNext()) {
            requests[i] = (HTTPILRequest)itemList.next();
            ++i;
        }
        return requests;
    }
}

