/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.RelationshipRoleMetaData;
import org.w3c.dom.Element;

public class RelationMetaData
extends MetaData {
    private String relationName;
    private RelationshipRoleMetaData left;
    private RelationshipRoleMetaData right;

    public String getRelationName() {
        return this.relationName;
    }

    public RelationshipRoleMetaData getLeftRelationshipRole() {
        return this.left;
    }

    public RelationshipRoleMetaData getRightRelationshipRole() {
        return this.right;
    }

    public RelationshipRoleMetaData getOtherRelationshipRole(RelationshipRoleMetaData role) {
        if (this.left == role) {
            return this.right;
        }
        if (this.right == role) {
            return this.left;
        }
        throw new IllegalArgumentException("Specified role is not the left or right role. role=" + role);
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Iterator iter;
        this.relationName = RelationMetaData.getOptionalChildContent(element, "ejb-relation-name");
        if ("".equals(this.relationName)) {
            this.relationName = null;
        }
        if (!(iter = RelationMetaData.getChildrenByTagName(element, "ejb-relationship-role")).hasNext()) {
            throw new DeploymentException("Expected 2 ejb-relationship-role roles but found none");
        }
        this.left = new RelationshipRoleMetaData(this);
        this.left.importEjbJarXml((Element)iter.next());
        if (!iter.hasNext()) {
            throw new DeploymentException("Expected 2 ejb-relationship-role but only found one");
        }
        this.right = new RelationshipRoleMetaData(this);
        this.right.importEjbJarXml((Element)iter.next());
        if (iter.hasNext()) {
            throw new DeploymentException("Expected only 2 ejb-relationship-role but found more then 2");
        }
        if (this.relationName == null) {
            this.relationName = this.left.getEntityName() + (this.left.getCMRFieldName() == null ? "" : "_" + this.left.getCMRFieldName()) + "-" + this.right.getEntityName() + (this.right.getCMRFieldName() == null ? "" : "_" + this.right.getCMRFieldName());
        }
        String leftName = this.left.getRelationshipRoleName();
        String rightName = this.right.getRelationshipRoleName();
        if (leftName != null && leftName.equals(rightName)) {
            throw new DeploymentException("ejb-relationship-role-name must be unique in ejb-relation: ejb-relationship-role-name is " + leftName);
        }
        if (this.left.isCascadeDelete() && this.right.isMultiplicityMany()) {
            throw new DeploymentException("cascade-delete is only allowed in ejb-relationship-role where the other role has a multiplicity One");
        }
        if (this.right.isCascadeDelete() && this.left.isMultiplicityMany()) {
            throw new DeploymentException("cascade-delete is only allowed in ejb-relationship-role where the other role has a multiplicity One");
        }
    }
}

