/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.BasicKernelDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.collection.CollectionsFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class BasicXMLDeployer
extends BasicKernelDeployer {
    private static final Logger log = Logger.getLogger(BasicXMLDeployer.class);
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
    private Map<String, KernelDeployment> deploymentsByName = CollectionsFactory.createConcurrentReaderMap();

    public BasicXMLDeployer(Kernel kernel) throws Throwable {
        super(kernel);
    }

    public Collection getDeploymentNames() {
        return this.deploymentsByName.keySet();
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        super.deploy(deployment);
        this.deploymentsByName.put(deployment.getName(), deployment);
    }

    public void undeploy(KernelDeployment deployment) {
        this.deploymentsByName.remove(deployment.getName());
        super.undeploy(deployment);
    }

    public void undeploy(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        this.undeploy(url.toString());
    }

    public void undeploy(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        KernelDeployment deployment = this.deploymentsByName.remove(name);
        if (deployment == null) {
            throw new IllegalStateException("Unknown deployment " + name);
        }
        this.undeploy(deployment);
    }

    public KernelDeployment deploy(URL url) throws Throwable {
        long now;
        boolean trace = log.isTraceEnabled();
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (trace) {
            log.trace("Parsing " + url);
        }
        long start = System.currentTimeMillis();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
        if (deployment == null) {
            throw new RuntimeException("The xml " + url + " is not well formed!");
        }
        deployment.setName(url.toString());
        if (trace) {
            now = System.currentTimeMillis();
            log.trace("Parsing " + url + " took " + (now - start) + " milliseconds");
        }
        this.deploy(deployment);
        if (trace) {
            now = System.currentTimeMillis();
            log.trace("Deploying " + url + " took " + (now - start) + " milliseconds");
        }
        return deployment;
    }

    public KernelDeployment deploy(String deploymentName, InputStream stream) throws Throwable {
        Unmarshaller unmarshaller;
        KernelDeployment deployment;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Parsing " + deploymentName);
        }
        if ((deployment = (KernelDeployment)(unmarshaller = factory.newUnmarshaller()).unmarshal(stream, resolver)) == null) {
            throw new RuntimeException("The deployment " + deploymentName + " is not well formed!");
        }
        deployment.setName(deploymentName);
        this.deploy(deployment);
        return deployment;
    }
}

