/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LifecycleAction
extends KernelControllerContextAction {
    public abstract String getInstallMethod(KernelControllerContext var1);

    public abstract List<ParameterMetaData> getInstallParameters(KernelControllerContext var1);

    public abstract String getUninstallMethod(KernelControllerContext var1);

    public abstract List<ParameterMetaData> getUninstallParameters(KernelControllerContext var1);

    @Override
    public void installAction(KernelControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object target = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        String method = this.getInstallMethod(context);
        List<ParameterMetaData> parameters = this.getInstallParameters(context);
        MethodJoinpoint joinpoint = null;
        try {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
        }
        catch (JoinpointException ignored) {
            if (trace) {
                if (parameters == null) {
                    this.log.trace("No " + method + " method for " + context);
                } else {
                    this.log.trace("No " + method + parameters + " method for " + context);
                }
            }
            return;
        }
        joinpoint.setTarget(target);
        LifecycleAction.dispatchJoinPoint(context, joinpoint);
    }

    @Override
    public void uninstallAction(KernelControllerContext context) {
        boolean trace = this.log.isTraceEnabled();
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object target = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        String method = this.getUninstallMethod(context);
        List<ParameterMetaData> parameters = this.getUninstallParameters(context);
        MethodJoinpoint joinpoint = null;
        try {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            joinpoint.setTarget(target);
            LifecycleAction.dispatchJoinPoint(context, joinpoint);
        }
        catch (JoinpointException ignored) {
            if (trace) {
                if (parameters == null) {
                    this.log.trace("No " + method + " method for " + context);
                } else {
                    this.log.trace("No " + method + parameters + " method for " + context);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.log.warn("Error during " + method, throwable);
        }
    }
}

