/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.config.xml;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class JavaBeanSchemaInitializer
implements SchemaBindingInitializer {
    private static final KernelConfig config;
    protected static final TypeInfoFactory typeInfoFactory;
    private static final String JAVABEAN_NS = "urn:jboss:javabean:1.0";
    private static final QName javabeanTypeQName;
    private static final QName propertyTypeQName;
    private static final QName propertyQName;

    public SchemaBinding init(SchemaBinding schema) {
        TypeBinding beanType = schema.getType(javabeanTypeQName);
        beanType.setHandler(new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new Holder();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                Holder holder = (Holder)o;
                String className = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if (!"class".equals(localName)) continue;
                    className = attrs.getValue(i);
                }
                if (className == null) {
                    throw new IllegalArgumentException("No class attribute for " + elementName);
                }
                try {
                    BeanInfo beanInfo = config.getBeanInfo(className, Thread.currentThread().getContextClassLoader());
                    Object object = Configurator.instantiate(config, beanInfo, null);
                    holder.setValue(object);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error instantiating class " + className, t);
                }
            }

            public Object endElement(Object o, QName qName, ElementBinding element) {
                Holder holder = (Holder)o;
                return holder.getValue();
            }
        });
        beanType.pushInterceptor(propertyQName, new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName name) {
                Holder holder = (Holder)parent;
                Object parentValue = holder.getValue();
                Property prop = (Property)child;
                String property = prop.getProperty();
                MethodInfo method = null;
                Object value = prop.getValue();
                try {
                    PropertyInfo info = JavaBeanSchemaInitializer.this.getProperty(parentValue, property);
                    value = JavaBeanSchemaInitializer.this.convertValue(info, prop.getType(), value);
                    method = info.getSetter();
                    method.invoke(parentValue, new Object[]{value});
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error setting property " + property + " on object" + parentValue + " with value " + value, t);
                }
            }
        });
        TypeBinding propertyType = schema.getType(propertyTypeQName);
        propertyType.setHandler(new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new Property();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                Property property = (Property)o;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if ("name".equals(localName)) {
                        property.setProperty(attrs.getValue(i));
                        continue;
                    }
                    if (!"class".equals(localName)) continue;
                    property.setType(attrs.getValue(i));
                }
            }
        });
        return schema;
    }

    private PropertyInfo getProperty(Object parent, String property) throws Throwable {
        BeanInfo beanInfo = config.getBeanInfo(parent.getClass());
        Set<PropertyInfo> properties = beanInfo.getProperties();
        if (properties != null && properties.size() > 0) {
            for (PropertyInfo prop : properties) {
                if (!prop.getName().equals(property)) continue;
                if (prop.getSetter() == null) {
                    throw new IllegalArgumentException("Property '" + property + "' is read only " + prop);
                }
                return prop;
            }
        }
        throw new IllegalArgumentException("No property '" + property + "' for " + beanInfo);
    }

    private Object convertValue(PropertyInfo info, String override, Object value) throws Throwable {
        TypeInfo type = info.getType();
        if (override != null) {
            type = typeInfoFactory.getTypeInfo(override, null);
        }
        return type.convertValue(value);
    }

    static {
        typeInfoFactory = new IntrospectionTypeInfoFactory();
        javabeanTypeQName = new QName(JAVABEAN_NS, "javabeanType");
        propertyTypeQName = new QName(JAVABEAN_NS, "propertyType");
        propertyQName = new QName(JAVABEAN_NS, "property");
        try {
            config = AccessController.doPrivileged(new PrivilegedExceptionAction<KernelConfig>(){

                @Override
                public KernelConfig run() throws Exception {
                    return new PropertyKernelConfig(System.getProperties());
                }
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting configuration", e);
        }
        PropertyEditors.init();
    }

    public static class Property
    extends Holder {
        private String property;
        private String type;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class Holder {
        private Object object;

        public Object getValue() {
            return this.object;
        }

        public void setValue(Object object) {
            this.object = object;
        }
    }
}

