/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.io.Externalizable;
import java.io.Serializable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import org.jboss.ejb3.entity.ExtendedEntityManager;
import org.jboss.ejb3.entity.ExtendedHibernateSession;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.TransactionScopedEntityManager;
import org.jboss.ejb3.entity.TransactionScopedHibernateSession;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.injection.EncInjector;
import org.jboss.injection.ExtendedPersistenceContextInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.PersistenceUnitHandler;
import org.jboss.naming.Util;

public class PcEncInjector
implements EncInjector {
    private String encName;
    private String unitName;
    private PersistenceContextType type;
    private Class injectionType;
    private String error;

    public PcEncInjector(String encName, String unitName, PersistenceContextType type, Class injectionType, String error) {
        this.encName = encName;
        this.unitName = unitName;
        this.type = type;
        this.injectionType = injectionType;
        this.error = error;
    }

    public void inject(InjectionContainer container) {
        String error1 = this.error;
        ManagedEntityManagerFactory factory = null;
        try {
            factory = PersistenceUnitHandler.getManagedEntityManagerFactory(container, this.unitName);
        }
        catch (NameNotFoundException e) {
            error1 = error1 + " " + e.getMessage();
        }
        if (factory == null) {
            throw new RuntimeException(error1);
        }
        if (this.type == PersistenceContextType.EXTENDED) {
            if (!(container instanceof StatefulContainer)) {
                throw new RuntimeException("It is illegal to inject an EXTENDED PC into something other than a SFSB");
            }
            container.getInjectors().add(0, new ExtendedPersistenceContextInjector(factory));
            Serializable extendedPc = null;
            extendedPc = this.injectionType == null || this.injectionType.getName().equals(EntityManager.class.getName()) ? new ExtendedEntityManager(factory.getKernelName()) : new ExtendedHibernateSession(factory.getKernelName());
            try {
                Util.rebind(container.getEnc(), this.encName, (Object)extendedPc);
            }
            catch (NamingException e) {
                throw new RuntimeException(error1, e);
            }
        }
        Externalizable entityManager = null;
        entityManager = this.injectionType == null || this.injectionType.getName().equals(EntityManager.class.getName()) ? new TransactionScopedEntityManager(factory) : new TransactionScopedHibernateSession(factory);
        try {
            Util.rebind(container.getEnc(), this.encName, (Object)entityManager);
        }
        catch (NamingException e) {
            throw new RuntimeException(error1, e);
        }
    }
}

