/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.quartz;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.management.ObjectName;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.quartz.PersistentTimer;
import org.jboss.ejb3.timerservice.quartz.QuartzTimerJob;
import org.jboss.ejb3.timerservice.quartz.TimerImpl;
import org.jboss.logging.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class TimerServiceImpl
implements TimerService {
    private static final Logger log = Logger.getLogger(TimerServiceImpl.class);
    private Scheduler scheduler;
    private ObjectName objectName;
    private String groupName;
    private long jobNum = 0L;
    private long triggerNum = 0L;

    protected TimerServiceImpl(Scheduler scheduler, ObjectName objectName, TimedObjectInvoker invoker) {
        assert (scheduler != null);
        assert (objectName != null);
        assert (invoker != null);
        this.scheduler = scheduler;
        this.objectName = objectName;
        this.groupName = objectName.getCanonicalName();
    }

    protected Timer createTimer(Trigger trigger, Serializable info) {
        try {
            String name = "myJob" + this.jobNum;
            ++this.jobNum;
            Class<QuartzTimerJob> jobClass = QuartzTimerJob.class;
            TimerImpl timer = new TimerImpl(this.scheduler, trigger, info);
            PersistentTimer persistentTimer = new PersistentTimer(trigger, this.objectName, info);
            JobDetail jobDetail = new JobDetail(name, this.groupName, jobClass);
            jobDetail.getJobDataMap().put((Object)"timer", (Object)persistentTimer);
            this.scheduler.scheduleJob(jobDetail, trigger);
            return timer;
        }
        catch (SchedulerException e) {
            log.error("createTimer failed", e);
            throw new EJBException(e.getMessage());
        }
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must not be negative");
        }
        Date expiration = new Date(System.currentTimeMillis() + duration);
        return this.createTimer(expiration, info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialDuration < 0L) {
            throw new IllegalArgumentException("initialDuration must not be negative");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration must not be negative");
        }
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        return this.createTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (expiration == null) {
            throw new IllegalArgumentException("expiration must not be null");
        }
        if (expiration.getTime() < 0L) {
            throw new IllegalArgumentException("expiration.time must not be negative");
        }
        String triggerName = "myTrigger" + this.triggerNum;
        ++this.triggerNum;
        SimpleTrigger trigger = new SimpleTrigger(triggerName, this.groupName, expiration);
        return this.createTimer((Trigger)trigger, info);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        if (initialExpiration == null) {
            throw new IllegalArgumentException("initialExpiration must not be null");
        }
        if (initialExpiration.getTime() < 0L) {
            throw new IllegalArgumentException("initialExpiration.time must not be negative");
        }
        if (intervalDuration < 0L) {
            throw new IllegalArgumentException("intervalDuration must not be negative");
        }
        String triggerName = "myTrigger" + this.triggerNum;
        ++this.triggerNum;
        Date endTime = null;
        SimpleTrigger trigger = new SimpleTrigger(triggerName, this.groupName, initialExpiration, endTime, SimpleTrigger.REPEAT_INDEFINITELY, intervalDuration);
        return this.createTimer((Trigger)trigger, info);
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        throw new RuntimeException("NYI");
    }

    protected void shutdown() {
        log.info("shutting down " + this);
        try {
            String[] jobNames;
            String[] triggerNames;
            for (String triggerName : triggerNames = this.scheduler.getTriggerNames(this.groupName)) {
                this.scheduler.unscheduleJob(triggerName, this.groupName);
            }
            for (String jobName : jobNames = this.scheduler.getJobNames(this.groupName)) {
                this.scheduler.deleteJob(jobName, this.groupName);
            }
        }
        catch (SchedulerException e) {
            log.error("shutdown failed", e);
        }
    }

    public String toString() {
        return "Timer Service " + this.objectName;
    }
}

